/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots.axes;

import de.erichseifert.gral.AbstractDrawable;
import de.erichseifert.gral.Drawable;
import de.erichseifert.gral.DrawingContext;
import de.erichseifert.gral.plots.Label;
import de.erichseifert.gral.plots.axes.Axis;
import de.erichseifert.gral.plots.axes.AxisRenderer;
import de.erichseifert.gral.plots.axes.Tick;
import de.erichseifert.gral.util.BasicSettingsStorage;
import de.erichseifert.gral.util.Dimension2D;
import de.erichseifert.gral.util.GeometryUtils;
import de.erichseifert.gral.util.GraphicsUtils;
import de.erichseifert.gral.util.MathUtils;
import de.erichseifert.gral.util.PointND;
import de.erichseifert.gral.util.SettingChangeEvent;
import de.erichseifert.gral.util.SettingsListener;
import de.erichseifert.gral.util.SettingsStorage;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.Format;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAxisRenderer2D
extends BasicSettingsStorage
implements AxisRenderer,
SettingsListener {
    private Line2D[] a;
    private Point2D[] b;
    private double[] c;
    private double[] d;

    public AbstractAxisRenderer2D() {
        this.addSettingsListener(this);
        this.setSettingDefault(INTERSECTION, 0.0);
        this.setSettingDefault(SHAPE_DIRECTION_SWAPPED, false);
        this.setSettingDefault(SHAPE, new Line2D.Double(0.0, 0.0, 1.0, 0.0));
        this.setSettingDefault(SHAPE_VISIBLE, true);
        this.setSettingDefault(SHAPE_NORMAL_ORIENTATION_CLOCKWISE, false);
        this.setSettingDefault(SHAPE_STROKE, new BasicStroke());
        this.setSettingDefault(SHAPE_COLOR, Color.BLACK);
        this.setSettingDefault(SHAPE_DIRECTION_SWAPPED, false);
        this.setSettingDefault(TICKS, true);
        this.setSettingDefault(TICKS_SPACING, 0.0);
        this.setSettingDefault(TICKS_AUTO_SPACING, false);
        this.setSettingDefault(TICKS_LENGTH, 1.0);
        this.setSettingDefault(TICKS_STROKE, new BasicStroke());
        this.setSettingDefault(TICKS_ALIGNMENT, 0.5);
        this.setSettingDefault(TICKS_FONT, Font.decode(null));
        this.setSettingDefault(TICKS_COLOR, Color.BLACK);
        this.setSettingDefault(TICK_LABELS, true);
        this.setSettingDefault(TICK_LABELS_FORMAT, NumberFormat.getInstance());
        this.setSettingDefault(TICK_LABELS_DISTANCE, 1.0);
        this.setSettingDefault(TICK_LABELS_OUTSIDE, true);
        this.setSettingDefault(TICK_LABELS_ROTATION, 0.0);
        this.setSettingDefault(TICKS_CUSTOM, null);
        this.setSettingDefault(TICKS_MINOR, true);
        this.setSettingDefault(TICKS_MINOR_COUNT, 1);
        this.setSettingDefault(TICKS_MINOR_LENGTH, 0.5);
        this.setSettingDefault(TICKS_MINOR_STROKE, new BasicStroke());
        this.setSettingDefault(TICKS_MINOR_ALIGNMENT, 0.5);
        this.setSettingDefault(TICKS_MINOR_COLOR, Color.BLACK);
        this.setSettingDefault(LABEL, null);
        this.setSettingDefault(LABEL_DISTANCE, 1.0);
        this.setSettingDefault(LABEL_ROTATION, 0.0);
        this.setSettingDefault(LABEL_FONT, Font.decode(null));
        this.setSettingDefault(LABEL_COLOR, Color.BLACK);
    }

    @Override
    public Drawable getRendererComponent(Axis axis) {
        return new AbstractDrawable(this, axis){
            private /* synthetic */ Axis a;
            private /* synthetic */ AbstractAxisRenderer2D b;
            {
                this.b = abstractAxisRenderer2D;
                this.a = axis;
            }

            public final void draw(DrawingContext drawingContext) {
                double d;
                double d2;
                Object object;
                if (this.b.a == null || this.b.a.length == 0) {
                    return;
                }
                AbstractAxisRenderer2D abstractAxisRenderer2D = this.b;
                Graphics2D graphics2D = drawingContext.getGraphics();
                AffineTransform affineTransform = graphics2D.getTransform();
                graphics2D.translate(this.getX(), this.getY());
                Stroke stroke = graphics2D.getStroke();
                Paint paint = graphics2D.getPaint();
                Paint paint2 = (Paint)abstractAxisRenderer2D.getSetting(AxisRenderer.SHAPE_COLOR);
                Stroke stroke2 = (Stroke)abstractAxisRenderer2D.getSetting(AxisRenderer.SHAPE_STROKE);
                if (((Boolean)abstractAxisRenderer2D.getSetting(AxisRenderer.SHAPE_VISIBLE)).booleanValue()) {
                    Shape shape = (Shape)abstractAxisRenderer2D.getSetting(AxisRenderer.SHAPE);
                    GraphicsUtils.drawPaintedShape(graphics2D, shape, paint2, null, stroke2);
                }
                double d3 = ((Font)abstractAxisRenderer2D.getSetting(AxisRenderer.TICKS_FONT)).getSize2D();
                boolean bl = (Boolean)abstractAxisRenderer2D.getSetting(AxisRenderer.TICKS);
                boolean bl2 = (Boolean)abstractAxisRenderer2D.getSetting(AxisRenderer.TICKS_MINOR);
                if (bl || bl && bl2) {
                    object = this.b.getTicks(this.a);
                    boolean bl3 = (Boolean)abstractAxisRenderer2D.getSetting(AxisRenderer.TICK_LABELS);
                    boolean bl4 = (Boolean)abstractAxisRenderer2D.getSetting(AxisRenderer.TICK_LABELS_OUTSIDE);
                    double d4 = ((Number)abstractAxisRenderer2D.getSetting(AxisRenderer.TICK_LABELS_ROTATION)).doubleValue();
                    double d5 = ((Number)abstractAxisRenderer2D.getSetting(AxisRenderer.TICK_LABELS_DISTANCE)).doubleValue() * d3;
                    Line2D.Double double_ = new Line2D.Double();
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Stroke stroke3;
                        Paint paint3;
                        Tick tick = (Tick)iterator.next();
                        if (tick.getPosition() == null || tick.getNormal() == null) continue;
                        Point2D point2D = tick.getPosition().getPoint2D();
                        Point2D point2D2 = tick.getNormal().getPoint2D();
                        if (Tick.TickType.MINOR.equals((Object)tick.getType())) {
                            d2 = ((Number)abstractAxisRenderer2D.getSetting(AxisRenderer.TICKS_MINOR_LENGTH)).doubleValue() * d3;
                            d = ((Number)abstractAxisRenderer2D.getSetting(AxisRenderer.TICKS_MINOR_ALIGNMENT)).doubleValue();
                            paint3 = (Paint)abstractAxisRenderer2D.getSetting(AxisRenderer.TICKS_MINOR_COLOR);
                            stroke3 = (Stroke)abstractAxisRenderer2D.getSetting(AxisRenderer.TICKS_MINOR_STROKE);
                        } else {
                            d2 = ((Number)abstractAxisRenderer2D.getSetting(AxisRenderer.TICKS_LENGTH)).doubleValue() * d3;
                            d = ((Number)abstractAxisRenderer2D.getSetting(AxisRenderer.TICKS_ALIGNMENT)).doubleValue();
                            paint3 = (Paint)abstractAxisRenderer2D.getSetting(AxisRenderer.TICKS_COLOR);
                            stroke3 = (Stroke)abstractAxisRenderer2D.getSetting(AxisRenderer.TICKS_STROKE);
                        }
                        double d6 = d2 * d;
                        double d7 = d2 * (1.0 - d);
                        if (bl && Tick.TickType.MAJOR.equals((Object)tick.getType()) || Tick.TickType.CUSTOM.equals((Object)tick.getType()) || bl2 && Tick.TickType.MINOR.equals((Object)tick.getType())) {
                            ((Line2D)double_).setLine(point2D.getX() - point2D2.getX() * d6, point2D.getY() - point2D2.getY() * d6, point2D.getX() + point2D2.getX() * d7, point2D.getY() + point2D2.getY() * d7);
                            GraphicsUtils.drawPaintedShape(graphics2D, double_, paint3, null, stroke3);
                        }
                        if (!bl3 || !Tick.TickType.MAJOR.equals((Object)tick.getType()) && !Tick.TickType.CUSTOM.equals((Object)tick.getType()) || (object = tick.getLabel()) == null || ((String)object).trim().isEmpty()) continue;
                        object = new Label((String)object);
                        ((BasicSettingsStorage)object).setSetting(Label.FONT, abstractAxisRenderer2D.getSetting(AxisRenderer.TICKS_FONT));
                        ((BasicSettingsStorage)object).setSetting(Label.COLOR, paint3);
                        double d8 = d7 + d5;
                        1.a((Label)object, point2D, point2D2, d8, bl4, d4);
                        ((Label)object).draw(drawingContext);
                    }
                }
                if ((object = (String)abstractAxisRenderer2D.getSetting(AxisRenderer.LABEL)) != null && !((String)object).trim().isEmpty()) {
                    Label label = new Label((String)object);
                    label.setSetting(Label.FONT, abstractAxisRenderer2D.getSetting(AxisRenderer.LABEL_FONT));
                    label.setSetting(Label.COLOR, abstractAxisRenderer2D.getSetting(AxisRenderer.LABEL_COLOR));
                    double d9 = ((Number)abstractAxisRenderer2D.getSetting(AxisRenderer.TICKS_LENGTH)).doubleValue() * d3;
                    double d10 = ((Number)abstractAxisRenderer2D.getSetting(AxisRenderer.TICKS_ALIGNMENT)).doubleValue();
                    double d11 = d9 * (1.0 - d10);
                    double d12 = ((Number)abstractAxisRenderer2D.getSetting(AxisRenderer.TICK_LABELS_DISTANCE)).doubleValue() * d3;
                    double d13 = ((Number)abstractAxisRenderer2D.getSetting(AxisRenderer.LABEL_DISTANCE)).doubleValue() * d3;
                    d2 = d11 + d12 + d3 + d13;
                    d = ((Number)abstractAxisRenderer2D.getSetting(AxisRenderer.LABEL_ROTATION)).doubleValue();
                    double d14 = (this.a.getMin().doubleValue() + this.a.getMax().doubleValue()) * 0.5;
                    boolean bl5 = (Boolean)abstractAxisRenderer2D.getSetting(AxisRenderer.TICK_LABELS_OUTSIDE);
                    PointND<Double> pointND = this.b.getPosition(this.a, d14, false, true);
                    PointND<Double> pointND2 = this.b.getNormal(this.a, d14, false, true);
                    if (pointND != null && pointND2 != null) {
                        1.a(label, pointND.getPoint2D(), pointND2.getPoint2D(), d2, bl5, d);
                        label.draw(drawingContext);
                    }
                }
                graphics2D.setPaint(paint);
                graphics2D.setStroke(stroke);
                graphics2D.setTransform(affineTransform);
            }

            private static void a(Label label, Point2D point2D, Point2D list, double d, boolean bl, double d2) {
                Rectangle2D rectangle2D = label.getTextRectangle();
                Shape shape = new Rectangle2D.Double(0.0, 0.0, rectangle2D.getWidth() + d * 2.0, rectangle2D.getHeight() + d * 2.0);
                Rectangle2D rectangle2D2 = shape.getBounds2D();
                label.setSetting(Label.ROTATION, d2);
                if (d2 % 360.0 != 0.0) {
                    shape = AffineTransform.getRotateInstance(-d2 / 180.0 * Math.PI, rectangle2D2.getCenterX(), rectangle2D2.getCenterY()).createTransformedShape(shape);
                }
                rectangle2D2 = shape.getBounds2D();
                double d3 = rectangle2D2.getHeight() * rectangle2D2.getHeight() + rectangle2D2.getWidth() * rectangle2D2.getWidth();
                double d4 = (bl ? -1.0 : 1.0) * d3;
                list = GeometryUtils.intersection(rectangle2D2, (Shape)new Line2D.Double(rectangle2D2.getCenterX(), rectangle2D2.getCenterY(), rectangle2D2.getCenterX() + d4 * ((Point2D)((Object)list)).getX(), rectangle2D2.getCenterY() + d4 * ((Point2D)((Object)list)).getY()));
                if (!list.isEmpty()) {
                    list = (Point2D)list.get(0);
                    double d5 = ((Point2D)((Object)list)).getX() - rectangle2D2.getCenterX();
                    double d6 = ((Point2D)((Object)list)).getY() - rectangle2D2.getCenterY();
                    double d7 = point2D.getX() - d5 - rectangle2D.getWidth() / 2.0;
                    double d8 = point2D.getY() - d6 - rectangle2D.getHeight() / 2.0;
                    label.setBounds(d7, d8, rectangle2D.getWidth(), rectangle2D.getHeight());
                }
            }

            public final Dimension2D getPreferredSize() {
                AbstractAxisRenderer2D abstractAxisRenderer2D = this.b;
                double d = ((Font)abstractAxisRenderer2D.getSetting(AxisRenderer.TICKS_FONT)).getSize2D();
                double d2 = ((Number)abstractAxisRenderer2D.getSetting(AxisRenderer.TICKS_LENGTH)).doubleValue() * d;
                double d3 = ((Number)abstractAxisRenderer2D.getSetting(AxisRenderer.TICKS_ALIGNMENT)).doubleValue();
                double d4 = d2 * (1.0 - d3);
                double d5 = ((Number)abstractAxisRenderer2D.getSetting(AxisRenderer.TICK_LABELS_DISTANCE)).doubleValue() * d + d4;
                double d6 = d + d5 + d4;
                return new Dimension2D.Double(d6, d6);
            }
        };
    }

    @Override
    public List<Tick> getTicks(Axis axis) {
        double d;
        Number number;
        double d2 = axis.getMin().doubleValue();
        double d3 = axis.getMax().doubleValue();
        LinkedList<Tick> linkedList = new LinkedList<Tick>();
        HashSet<Double> hashSet = new HashSet<Double>();
        this.createTicksCustom(linkedList, axis, d2, d3, hashSet);
        boolean bl = (Boolean)this.getSetting(TICKS_AUTO_SPACING);
        if (!bl && ((number = (Number)this.getSetting(TICKS_SPACING)) == null || (d = number.doubleValue()) <= 0.0 || Double.isNaN(d) || Double.isInfinite(d))) {
            bl = true;
        }
        this.createTicks(linkedList, axis, d2, d3, hashSet, bl);
        return linkedList;
    }

    protected abstract void createTicks(List<Tick> var1, Axis var2, double var3, double var5, Set<Double> var7, boolean var8);

    protected void createTicksCustom(List<Tick> list, Axis axis, double d, double d2, Set<Double> set) {
        Object object = (Map)this.getSetting(TICKS_CUSTOM);
        if (object != null) {
            object = object.keySet().iterator();
            while (object.hasNext()) {
                double d3 = ((Number)object.next()).doubleValue();
                if (d3 < d || d3 > d2) continue;
                Tick tick = this.getTick(Tick.TickType.CUSTOM, axis, d3);
                list.add(tick);
                set.add(d3);
            }
        }
    }

    protected Tick getTick(Tick.TickType tickType, Axis object, double d) {
        PointND<Double> pointND = this.getPosition((Axis)object, d, false, false);
        object = this.getNormal((Axis)object, d, false, false);
        Map map = (Map)this.getSetting(TICKS_CUSTOM);
        String string = map != null && map.containsKey(d) ? (String)map.get(d) : ((Format)this.getSetting(TICK_LABELS_FORMAT)).format(d);
        return new Tick(tickType, pointND, (PointND<Double>)object, null, null, string);
    }

    @Override
    public PointND<Double> getNormal(Axis axis, Number serializable, boolean bl, boolean bl2) {
        double d = bl2 ? (((Number)serializable).doubleValue() - axis.getMin().doubleValue()) / axis.getRange() * this.getShapeLength() : this.worldToView(axis, (Number)serializable, bl);
        int n = MathUtils.binarySearchFloor(this.d, d);
        if (n < 0 || n >= this.a.length) {
            return null;
        }
        n = MathUtils.limit(n, 0, this.b.length - 1);
        serializable = (Boolean)this.getSetting(SHAPE_NORMAL_ORIENTATION_CLOCKWISE);
        double d2 = serializable != null && ((Boolean)serializable).booleanValue() ? 1.0 : -1.0;
        return new PointND((Number[])new Double[]{d2 * this.b[n].getX(), d2 * this.b[n].getY()});
    }

    protected double getShapeLength() {
        if (this.d == null || this.d.length == 0) {
            return 0.0;
        }
        return this.d[this.d.length - 1];
    }

    @Override
    public PointND<Double> getPosition(Axis object, Number object2, boolean bl, boolean bl2) {
        if (this.a == null || this.a.length == 0 || object2 == null) {
            return null;
        }
        double d = bl2 ? (((Number)object2).doubleValue() - ((Axis)object).getMin().doubleValue()) / ((Axis)object).getRange() * this.getShapeLength() : this.worldToView((Axis)object, (Number)object2, bl);
        if (Double.isNaN(d)) {
            return null;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            d = 0.0;
        } else if (d == Double.POSITIVE_INFINITY) {
            d = this.getShapeLength();
        }
        if (d <= 0.0 || d >= this.getShapeLength()) {
            if (bl) {
                int n = d <= 0.0 ? 0 : this.a.length - 1;
                object2 = this.a[n];
                double d2 = this.c[n];
                double d3 = this.d[n];
                double d4 = (d - d3) / d2;
                return new PointND((Number[])new Double[]{((Line2D)object2).getX1() + (((Line2D)object2).getX2() - ((Line2D)object2).getX1()) * d4, ((Line2D)object2).getY1() + (((Line2D)object2).getY2() - ((Line2D)object2).getY1()) * d4});
            }
            if (d <= 0.0) {
                object = this.a[0].getP1();
                return new PointND((Number[])new Double[]{((Point2D)object).getX(), ((Point2D)object).getY()});
            }
            object = this.a[this.a.length - 1].getP2();
            return new PointND((Number[])new Double[]{((Point2D)object).getX(), ((Point2D)object).getY()});
        }
        int n = MathUtils.binarySearchFloor(this.d, d);
        if (n < 0 || n >= this.a.length) {
            return null;
        }
        object2 = this.a[n];
        double d5 = (d - this.d[n]) / this.c[n];
        return new PointND((Number[])new Double[]{((Line2D)object2).getX1() + (((Line2D)object2).getX2() - ((Line2D)object2).getX1()) * d5, ((Line2D)object2).getY1() + (((Line2D)object2).getY2() - ((Line2D)object2).getY1()) * d5});
    }

    protected void evaluateShape(Shape shape) {
        boolean bl = (Boolean)this.getSetting(SHAPE_DIRECTION_SWAPPED);
        this.a = GeometryUtils.shapeToLines(shape, bl);
        this.c = new double[this.a.length];
        this.d = new double[this.a.length + 1];
        this.b = new Point2D[this.a.length];
        if (this.a.length == 0) {
            return;
        }
        for (int i = 0; i < this.a.length; ++i) {
            double d;
            Line2D line2D = this.a[i];
            this.c[i] = d = line2D.getP1().distance(line2D.getP2());
            this.d[i + 1] = this.d[i] + d;
            this.b[i] = new Point2D.Double((line2D.getY2() - line2D.getY1()) / d, -(line2D.getX2() - line2D.getX1()) / d);
        }
    }

    @Override
    public void settingChanged(SettingChangeEvent settingChangeEvent) {
        SettingsStorage.Key key = settingChangeEvent.getKey();
        if (SHAPE.equals(key)) {
            this.evaluateShape((Shape)settingChangeEvent.getValNew());
        }
    }
}

