/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots;

import de.erichseifert.gral.Drawable;
import de.erichseifert.gral.DrawingContext;
import de.erichseifert.gral.Legend;
import de.erichseifert.gral.PlotArea;
import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.DummyData;
import de.erichseifert.gral.data.Row;
import de.erichseifert.gral.plots.DataPoint;
import de.erichseifert.gral.plots.Plot;
import de.erichseifert.gral.plots.areas.AreaRenderer;
import de.erichseifert.gral.plots.axes.Axis;
import de.erichseifert.gral.plots.axes.AxisListener;
import de.erichseifert.gral.plots.axes.AxisRenderer;
import de.erichseifert.gral.plots.axes.LinearRenderer2D;
import de.erichseifert.gral.plots.axes.Tick;
import de.erichseifert.gral.plots.lines.LineRenderer;
import de.erichseifert.gral.plots.points.DefaultPointRenderer;
import de.erichseifert.gral.plots.points.PointRenderer;
import de.erichseifert.gral.util.GraphicsUtils;
import de.erichseifert.gral.util.Insets2D;
import de.erichseifert.gral.util.PointND;
import de.erichseifert.gral.util.SettingsStorage;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class XYPlot
extends Plot {
    public static String AXIS_X = "x";
    public static String AXIS_X2 = "x2";
    public static String AXIS_Y = "y";
    public static String AXIS_Y2 = "y2";
    private final Map<DataSource, PointRenderer> a = new HashMap<DataSource, PointRenderer>();
    private final Map<DataSource, LineRenderer> b;
    private final Map<DataSource, AreaRenderer> c;

    public XYPlot(DataSource ... object) {
        super(new DataSource[0]);
        this.b = new HashMap<DataSource, LineRenderer>(((DataSource[])object).length);
        this.c = new HashMap<DataSource, AreaRenderer>(((DataSource[])object).length);
        this.setPlotArea(new XYPlotArea2D(this));
        this.setLegend(new XYLegend(this));
        DataSource[] dataSourceArray = object;
        int n = ((DataSource[])object).length;
        for (int i = 0; i < n; ++i) {
            DataSource dataSource = dataSourceArray[i];
            this.add(dataSource);
        }
        double d = this.getAxisMin(AXIS_X);
        double d2 = this.getAxisMax(AXIS_X);
        double d3 = 0.0 * (d2 - d);
        object = new Axis(d - d3, d2 + d3);
        this.setAxis(AXIS_X, (Axis)object);
        double d4 = this.getAxisMin(AXIS_Y);
        double d5 = this.getAxisMax(AXIS_Y);
        double d6 = 0.0 * (d5 - d4);
        Axis axis = new Axis(d4 - d6, d5 + d6);
        this.setAxis(AXIS_Y, axis);
        Object object2 = new LinearRenderer2D();
        LinearRenderer2D linearRenderer2D = new LinearRenderer2D();
        this.setAxisRenderer(AXIS_X, (AxisRenderer)object2);
        this.setAxisRenderer(AXIS_Y, linearRenderer2D);
        object2 = new AxisListener(this){
            private /* synthetic */ XYPlot a;
            {
                this.a = xYPlot;
            }

            public final void rangeChanged(Axis axis, Number number, Number number2) {
                this.a.layoutAxes();
            }
        };
        ((Axis)object).addAxisListener((AxisListener)object2);
        axis.addAxisListener((AxisListener)object2);
    }

    protected void layout() {
        super.layout();
        this.layoutAxes();
        this.layoutLegend();
    }

    protected void layoutAxes() {
        Double d;
        PointND pointND;
        if (this.getPlotArea() == null) {
            return;
        }
        Rectangle2D rectangle2D = this.getPlotArea().getBounds();
        AxisRenderer axisRenderer = this.getAxisRenderer(AXIS_X);
        AxisRenderer axisRenderer2 = this.getAxisRenderer(AXIS_X2);
        AxisRenderer axisRenderer3 = this.getAxisRenderer(AXIS_Y);
        AxisRenderer axisRenderer4 = this.getAxisRenderer(AXIS_Y2);
        Drawable drawable = this.getAxisComponent(AXIS_X);
        Drawable drawable2 = this.getAxisComponent(AXIS_X2);
        Drawable drawable3 = this.getAxisComponent(AXIS_Y);
        Drawable drawable4 = this.getAxisComponent(AXIS_Y2);
        Dimension2D dimension2D = null;
        Dimension2D dimension2D2 = null;
        Dimension2D dimension2D3 = null;
        Dimension2D dimension2D4 = null;
        if (drawable != null && axisRenderer != null) {
            dimension2D = drawable.getPreferredSize();
            axisRenderer.setSetting(AxisRenderer.SHAPE, new Line2D.Double(0.0, 0.0, rectangle2D.getWidth(), 0.0));
        }
        if (drawable2 != null && axisRenderer2 != null) {
            dimension2D2 = drawable2.getPreferredSize();
            axisRenderer2.setSetting(AxisRenderer.SHAPE, new Line2D.Double(0.0, 0.0, rectangle2D.getWidth(), 0.0));
        }
        if (drawable3 != null && axisRenderer3 != null) {
            dimension2D3 = drawable3.getPreferredSize();
            axisRenderer3.setSetting(AxisRenderer.SHAPE, new Line2D.Double(dimension2D3.getWidth(), rectangle2D.getHeight(), dimension2D3.getWidth(), 0.0));
        }
        if (drawable4 != null && axisRenderer4 != null) {
            dimension2D4 = drawable4.getPreferredSize();
            axisRenderer4.setSetting(AxisRenderer.SHAPE, new Line2D.Double(dimension2D4.getWidth(), rectangle2D.getHeight(), dimension2D4.getWidth(), 0.0));
        }
        if (axisRenderer != null && drawable != null) {
            pointND = null;
            if (axisRenderer3 != null) {
                pointND = this.getAxis(AXIS_Y);
                d = ((Number)axisRenderer.getSetting(AxisRenderer.INTERSECTION)).doubleValue();
                pointND = axisRenderer3.getPosition((Axis)((Object)pointND), d, false, false);
            }
            if (pointND == null) {
                pointND = new PointND((Number[])new Double[]{0.0, 0.0});
            }
            drawable.setBounds(rectangle2D.getMinX(), (Double)pointND.get(1) + rectangle2D.getMinY(), rectangle2D.getWidth(), dimension2D.getHeight());
        }
        if (axisRenderer2 != null && drawable2 != null) {
            pointND = null;
            if (axisRenderer3 != null) {
                pointND = this.getAxis(AXIS_Y);
                d = ((Number)axisRenderer2.getSetting(AxisRenderer.INTERSECTION)).doubleValue();
                pointND = axisRenderer3.getPosition((Axis)((Object)pointND), d, false, false);
            }
            if (pointND == null) {
                pointND = new PointND((Number[])new Double[]{0.0, 0.0});
            }
            drawable2.setBounds(rectangle2D.getMinX(), (Double)pointND.get(1) + rectangle2D.getMinY(), rectangle2D.getWidth(), dimension2D2.getHeight());
        }
        if (axisRenderer3 != null && drawable3 != null) {
            pointND = null;
            if (axisRenderer != null) {
                pointND = this.getAxis(AXIS_X);
                d = ((Number)axisRenderer3.getSetting(AxisRenderer.INTERSECTION)).doubleValue();
                pointND = axisRenderer.getPosition((Axis)((Object)pointND), d, false, false);
            }
            if (pointND == null) {
                pointND = new PointND((Number[])new Double[]{0.0, 0.0});
            }
            drawable3.setBounds(rectangle2D.getMinX() - dimension2D3.getWidth() + (Double)pointND.get(0), rectangle2D.getMinY(), dimension2D3.getWidth(), rectangle2D.getHeight());
        }
        if (axisRenderer4 != null && drawable4 != null) {
            pointND = null;
            if (axisRenderer != null) {
                pointND = this.getAxis(AXIS_X);
                d = ((Number)axisRenderer4.getSetting(AxisRenderer.INTERSECTION)).doubleValue();
                pointND = axisRenderer.getPosition((Axis)((Object)pointND), d, false, false);
            }
            if (pointND == null) {
                pointND = new PointND((Number[])new Double[]{0.0, 0.0});
            }
            drawable4.setBounds(rectangle2D.getMinX() - dimension2D4.getWidth() + (Double)pointND.get(0), rectangle2D.getMinY(), dimension2D4.getWidth(), rectangle2D.getHeight());
        }
    }

    protected void layoutLegend() {
        if (this.getPlotArea() == null) {
            return;
        }
        Rectangle2D rectangle2D = this.getPlotArea().getBounds();
        this.getLegendContainer().setBounds(rectangle2D);
    }

    public PointRenderer getPointRenderer(DataSource dataSource) {
        return this.a.get(dataSource);
    }

    public void setPointRenderer(DataSource dataSource, PointRenderer pointRenderer) {
        this.a.put(dataSource, pointRenderer);
    }

    public LineRenderer getLineRenderer(DataSource dataSource) {
        return this.b.get(dataSource);
    }

    public void setLineRenderer(DataSource dataSource, LineRenderer lineRenderer) {
        this.b.put(dataSource, lineRenderer);
    }

    public AreaRenderer getAreaRenderer(DataSource dataSource) {
        return this.c.get(dataSource);
    }

    public void setAreaRenderer(DataSource dataSource, AreaRenderer areaRenderer) {
        this.c.put(dataSource, areaRenderer);
    }

    public void setAxisRenderer(String string, AxisRenderer axisRenderer) {
        if (axisRenderer != null) {
            if (AXIS_X2.equals(string) || AXIS_Y.equals(string)) {
                axisRenderer.setSetting(AxisRenderer.SHAPE_NORMAL_ORIENTATION_CLOCKWISE, true);
            }
            if (AXIS_Y.equals(string)) {
                axisRenderer.setSetting(AxisRenderer.LABEL_ROTATION, 90.0);
            }
        }
        super.setAxisRenderer(string, axisRenderer);
    }

    public void add(int n, DataSource dataSource, boolean bl) {
        super.add(n, dataSource, bl);
        DefaultPointRenderer defaultPointRenderer = new DefaultPointRenderer();
        this.setPointRenderer(dataSource, defaultPointRenderer);
        this.setLineRenderer(dataSource, null);
        this.setAreaRenderer(dataSource, null);
        this.setMapping(dataSource, AXIS_X, AXIS_Y);
    }

    public static class XYLegend
    extends Legend {
        private final DataSource a = new DummyData(1, 1, 0.5);
        private final XYPlot b;

        public XYLegend(XYPlot xYPlot) {
            this.b = xYPlot;
        }

        protected void drawSymbol(DrawingContext drawingContext, Drawable object, DataSource object2) {
            PointRenderer pointRenderer = this.b.getPointRenderer((DataSource)object2);
            Object object3 = this.b.getLineRenderer((DataSource)object2);
            object2 = this.b.getAreaRenderer((DataSource)object2);
            Row row = new Row(this.a, 0);
            object = object.getBounds();
            Object object4 = new DataPoint(new PointND((Number[])new Double[]{((RectangularShape)object).getMinX(), ((RectangularShape)object).getCenterY()}), null, null);
            DataPoint dataPoint = new DataPoint(new PointND((Number[])new Double[]{((RectangularShape)object).getCenterX(), ((RectangularShape)object).getCenterY()}), null, pointRenderer != null ? pointRenderer.getPointPath(row) : null);
            Object object5 = new DataPoint(new PointND((Number[])new Double[]{((RectangularShape)object).getMaxX(), ((RectangularShape)object).getCenterY()}), null, null);
            object4 = Arrays.asList(object4, dataPoint, object5);
            object5 = new Axis(0.0, 1.0);
            LinearRenderer2D linearRenderer2D = new LinearRenderer2D();
            linearRenderer2D.setSetting(LinearRenderer2D.SHAPE, new Line2D.Double(((RectangularShape)object).getCenterX(), ((RectangularShape)object).getMaxY(), ((RectangularShape)object).getCenterX(), ((RectangularShape)object).getMinY()));
            if (object2 != null) {
                object2.getArea((Axis)object5, linearRenderer2D, (Iterable<DataPoint>)object4).draw(drawingContext);
            }
            if (object3 != null) {
                object3.getLine((Iterable<DataPoint>)object4).draw(drawingContext);
            }
            if (pointRenderer != null) {
                object = drawingContext.getGraphics();
                object2 = dataPoint.getPosition().getPoint2D();
                object3 = ((Graphics2D)object).getTransform();
                ((Graphics2D)object).translate(((Point2D)object2).getX(), ((Point2D)object2).getY());
                pointRenderer.getPoint((Axis)object5, linearRenderer2D, row).draw(drawingContext);
                ((Graphics2D)object).setTransform((AffineTransform)object3);
            }
        }
    }

    public static class XYPlotArea2D
    extends PlotArea {
        public static final SettingsStorage.Key GRID_MAJOR_X = new SettingsStorage.Key("xyplot.grid.major.x");
        public static final SettingsStorage.Key GRID_MAJOR_Y = new SettingsStorage.Key("xyplot.grid.major.y");
        public static final SettingsStorage.Key GRID_MAJOR_COLOR = new SettingsStorage.Key("xyplot.grid.major.color");
        public static final SettingsStorage.Key GRID_MINOR_X = new SettingsStorage.Key("xyplot.grid.minor.x");
        public static final SettingsStorage.Key GRID_MINOR_Y = new SettingsStorage.Key("xyplot.grid.minor.y");
        public static final SettingsStorage.Key GRID_MINOR_COLOR = new SettingsStorage.Key("xyplot.grid.minor.color");
        private final XYPlot a;

        public XYPlotArea2D(XYPlot xYPlot) {
            this.a = xYPlot;
            this.setSettingDefault(GRID_MAJOR_X, true);
            this.setSettingDefault(GRID_MAJOR_Y, true);
            this.setSettingDefault(GRID_MAJOR_COLOR, new Color(0.0f, 0.0f, 0.0f, 0.1f));
            this.setSettingDefault(GRID_MINOR_X, false);
            this.setSettingDefault(GRID_MINOR_Y, false);
            this.setSettingDefault(GRID_MINOR_COLOR, new Color(0.0f, 0.0f, 0.0f, 0.05f));
        }

        public void draw(DrawingContext drawingContext) {
            this.drawBackground(drawingContext);
            this.drawGrid(drawingContext);
            this.drawBorder(drawingContext);
            this.drawPlot(drawingContext);
            this.a.drawAxes(drawingContext);
            this.a.drawLegend(drawingContext);
        }

        protected void drawGrid(DrawingContext object) {
            Object object2;
            Object object3;
            Iterator iterator;
            object = ((DrawingContext)object).getGraphics();
            boolean bl = (Boolean)this.getSetting(GRID_MAJOR_X);
            boolean bl2 = (Boolean)this.getSetting(GRID_MAJOR_Y);
            boolean bl3 = (Boolean)this.getSetting(GRID_MINOR_X);
            boolean bl4 = (Boolean)this.getSetting(GRID_MINOR_Y);
            AffineTransform affineTransform = ((Graphics2D)object).getTransform();
            ((Graphics2D)object).translate(this.getX(), this.getY());
            AffineTransform affineTransform2 = ((Graphics2D)object).getTransform();
            Rectangle2D rectangle2D = this.getBounds();
            if ((bl || bl3) && (iterator = this.a.getAxisRenderer(AXIS_X)) != null) {
                object3 = this.a.getAxis(AXIS_X);
                object2 = ((Shape)iterator.getSetting(AxisRenderer.SHAPE)).getBounds2D();
                iterator = iterator.getTicks((Axis)object3);
                object3 = new Line2D.Double(-((RectangularShape)object2).getMinX(), -((RectangularShape)object2).getMinY(), -((RectangularShape)object2).getMinX(), rectangle2D.getHeight() - ((RectangularShape)object2).getMinY());
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    Point2D point2D;
                    object2 = (Tick)iterator.next();
                    if (Tick.TickType.MAJOR.equals((Object)((Tick)object2).getType()) && !bl || Tick.TickType.MINOR.equals((Object)((Tick)object2).getType()) && !bl3 || (point2D = ((DataPoint)object2).getPosition().getPoint2D()) == null) continue;
                    Paint paint = (Paint)this.getSetting(GRID_MAJOR_COLOR);
                    if (Tick.TickType.MINOR.equals((Object)((Tick)object2).getType())) {
                        paint = (Paint)this.getSetting(GRID_MINOR_COLOR);
                    }
                    ((Graphics2D)object).translate(point2D.getX(), point2D.getY());
                    GraphicsUtils.drawPaintedShape((Graphics2D)object, (Shape)object3, paint, null, null);
                    ((Graphics2D)object).setTransform(affineTransform2);
                }
            }
            if ((bl2 || bl4) && (iterator = this.a.getAxisRenderer(AXIS_Y)) != null) {
                object3 = this.a.getAxis(AXIS_Y);
                object2 = ((Shape)iterator.getSetting(AxisRenderer.SHAPE)).getBounds2D();
                iterator = iterator.getTicks((Axis)object3);
                object3 = new Line2D.Double(-((RectangularShape)object2).getMinX(), -((RectangularShape)object2).getMinY(), rectangle2D.getWidth() - ((RectangularShape)object2).getMinX(), -((RectangularShape)object2).getMinY());
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    Point2D point2D;
                    object2 = (Tick)iterator.next();
                    boolean bl5 = Tick.TickType.MAJOR.equals((Object)((Tick)object2).getType());
                    boolean bl6 = Tick.TickType.MINOR.equals((Object)((Tick)object2).getType());
                    if (bl5 && !bl2 || bl6 && !bl4 || (point2D = ((DataPoint)object2).getPosition().getPoint2D()) == null) continue;
                    Paint paint = (Paint)this.getSetting(GRID_MAJOR_COLOR);
                    if (Tick.TickType.MINOR.equals((Object)((Tick)object2).getType())) {
                        paint = (Paint)this.getSetting(GRID_MINOR_COLOR);
                    }
                    ((Graphics2D)object).translate(point2D.getX(), point2D.getY());
                    GraphicsUtils.drawPaintedShape((Graphics2D)object, (Shape)object3, paint, null, null);
                    ((Graphics2D)object).setTransform(affineTransform2);
                }
            }
            ((Graphics2D)object).setTransform(affineTransform);
        }

        protected void drawPlot(DrawingContext drawingContext) {
            Graphics2D graphics2D = drawingContext.getGraphics();
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate(this.getX(), this.getY());
            AffineTransform affineTransform2 = graphics2D.getTransform();
            Insets2D insets2D = (Insets2D)this.getSetting(CLIPPING);
            if (insets2D != null) {
                Rectangle2D.Double double_ = new Rectangle2D.Double(insets2D.getLeft() * 10.0, insets2D.getTop() * 10.0, this.getWidth() - insets2D.getHorizontal() * 10.0, this.getHeight() - insets2D.getVertical() * 10.0);
                graphics2D.setClip(double_);
            }
            for (DataSource dataSource : this.a.getVisibleData()) {
                Object object;
                PointRenderer pointRenderer = this.a.getPointRenderer(dataSource);
                LineRenderer lineRenderer = this.a.getLineRenderer(dataSource);
                AreaRenderer areaRenderer = this.a.getAreaRenderer(dataSource);
                Object object2 = this.a.getMapping(dataSource);
                Axis axis = this.a.getAxis(object2[0]);
                Axis axis2 = this.a.getAxis(object2[1]);
                AxisRenderer axisRenderer = this.a.getAxisRenderer(object2[0]);
                object2 = this.a.getAxisRenderer(object2[1]);
                LinkedList<DataPoint> linkedList = new LinkedList<DataPoint>();
                for (int i = 0; i < dataSource.getRowCount(); ++i) {
                    PointND pointND;
                    Row row = new Row(dataSource, i);
                    object = row.get(0);
                    Number number = row.get(1);
                    PointND pointND2 = axisRenderer != null ? axisRenderer.getPosition(axis, (Number)object, true, false) : new PointND((Number[])new Double[]{0.0, 0.0});
                    PointND pointND3 = pointND = object2 != null ? object2.getPosition(axis2, number, true, false) : new PointND((Number[])new Double[]{0.0, 0.0});
                    if (pointND2 == null || pointND == null) continue;
                    PointND pointND4 = new PointND((Number[])new Double[]{(Double)pointND2.get(0), (Double)pointND.get(1)});
                    object = null;
                    Shape shape = null;
                    if (pointRenderer != null) {
                        object = pointRenderer.getPoint(axis2, (AxisRenderer)object2, row);
                        shape = pointRenderer.getPointPath(row);
                    }
                    DataPoint dataPoint = new DataPoint(pointND4, (Drawable)object, shape);
                    linkedList.add(dataPoint);
                }
                if (areaRenderer != null) {
                    areaRenderer.getArea(axis2, (AxisRenderer)object2, linkedList).draw(drawingContext);
                }
                if (lineRenderer != null) {
                    lineRenderer.getLine(linkedList).draw(drawingContext);
                }
                if (pointRenderer == null) continue;
                for (DataPoint dataPoint : linkedList) {
                    object = dataPoint.getPosition();
                    double d = ((PointND)object).get(0);
                    double d2 = (Double)((PointND)object).get(1);
                    graphics2D.translate(d, d2);
                    dataPoint.getDrawable().draw(drawingContext);
                    graphics2D.setTransform(affineTransform2);
                }
            }
            if (insets2D != null) {
                graphics2D.setClip(null);
            }
            graphics2D.setTransform(affineTransform);
        }
    }
}

