/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots;

import de.erichseifert.gral.AbstractDrawable;
import de.erichseifert.gral.Drawable;
import de.erichseifert.gral.DrawingContext;
import de.erichseifert.gral.data.DataChangeEvent;
import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.DataTable;
import de.erichseifert.gral.data.Row;
import de.erichseifert.gral.data.statistics.Statistics;
import de.erichseifert.gral.plots.XYPlot;
import de.erichseifert.gral.plots.axes.Axis;
import de.erichseifert.gral.plots.axes.AxisRenderer;
import de.erichseifert.gral.plots.colors.ColorMapper;
import de.erichseifert.gral.plots.colors.Grayscale;
import de.erichseifert.gral.plots.points.AbstractPointRenderer;
import de.erichseifert.gral.plots.points.PointRenderer;
import de.erichseifert.gral.util.GraphicsUtils;
import de.erichseifert.gral.util.SettingsStorage;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

public class RasterPlot
extends XYPlot {
    public static final SettingsStorage.Key OFFSET = new SettingsStorage.Key("rasterplot.offset");
    public static final SettingsStorage.Key DISTANCE = new SettingsStorage.Key("rasterplot.distance");
    public static final SettingsStorage.Key COLORS = new SettingsStorage.Key("rasterplot.color");
    private final DataSource a;
    private final DataTable b;

    public RasterPlot(DataSource object) {
        super(new DataSource[0]);
        this.setSettingDefault(COLORS, new Grayscale());
        this.getPlotArea().setSettingDefault(XYPlot.XYPlotArea2D.GRID_MAJOR_X, false);
        this.getPlotArea().setSettingDefault(XYPlot.XYPlotArea2D.GRID_MAJOR_Y, false);
        this.getAxisRenderer(AXIS_X).setSetting(AxisRenderer.INTERSECTION, -1.7976931348623157E308);
        this.getAxisRenderer(AXIS_Y).setSetting(AxisRenderer.INTERSECTION, -1.7976931348623157E308);
        this.a = object;
        object.addDataListener(this);
        this.b = new DataTable(Double.class, Double.class, Double.class);
        this.a();
        this.add(this.b);
        this.getAxis(AXIS_X).setRange(0.0, object.getColumnCount());
        this.getAxis(AXIS_Y).setRange(-object.getRowCount(), 0.0);
        object = new RasterRenderer(this);
        this.setLineRenderer(this.b, null);
        this.setPointRenderer(this.b, (PointRenderer)object);
    }

    private void a() {
        this.b.clear();
        Statistics statistics = this.a.getStatistics();
        double d = statistics.get("min");
        double d2 = statistics.get("max") - d;
        int n = 0;
        for (Number number : this.a) {
            double d3 = n % this.a.getColumnCount();
            double d4 = -n / this.a.getColumnCount();
            double d5 = (number.doubleValue() - d) / d2;
            this.b.add(d3, d4, d5);
            ++n;
        }
    }

    public void add(int n, DataSource dataSource, boolean bl) {
        if (this.getData().size() != 0) {
            throw new IllegalArgumentException("This plot type only supports a single data source.");
        }
        super.add(n, dataSource, bl);
    }

    public void dataAdded(DataSource dataSource, DataChangeEvent ... dataChangeEventArray) {
        super.dataAdded(dataSource, dataChangeEventArray);
        if (dataSource == this.a) {
            this.a();
        }
    }

    public void dataUpdated(DataSource dataSource, DataChangeEvent ... dataChangeEventArray) {
        super.dataUpdated(dataSource, dataChangeEventArray);
        if (dataSource == this.a) {
            this.a();
        }
    }

    public void dataRemoved(DataSource dataSource, DataChangeEvent ... dataChangeEventArray) {
        super.dataRemoved(dataSource, dataChangeEventArray);
        if (dataSource == this.a) {
            this.a();
        }
    }

    protected static class RasterRenderer
    extends AbstractPointRenderer {
        private final RasterPlot a;

        public RasterRenderer(RasterPlot rasterPlot) {
            this.a = rasterPlot;
        }

        public Drawable getPoint(Axis axis, AxisRenderer axisRenderer, Row row) {
            return new AbstractDrawable(this, row){
                private final Rectangle2D a = new Rectangle2D.Double();
                private final Axis b = RasterRenderer.a(this.g).getAxis(XYPlot.AXIS_X);
                private final Axis c = RasterRenderer.a(this.g).getAxis(XYPlot.AXIS_Y);
                private final AxisRenderer d = RasterRenderer.a(this.g).getAxisRenderer(XYPlot.AXIS_X);
                private final AxisRenderer e = RasterRenderer.a(this.g).getAxisRenderer(XYPlot.AXIS_Y);
                private /* synthetic */ Row f;
                private /* synthetic */ RasterRenderer g;
                {
                    this.g = rasterRenderer;
                    this.f = row;
                }

                public final void draw(DrawingContext object) {
                    double d = this.f.get(0).doubleValue();
                    double d2 = this.f.get(1).doubleValue();
                    double d3 = this.f.get(2).doubleValue();
                    double d4 = this.d.getPosition(this.b, d - 0.5, true, false).get(0);
                    double d5 = Math.abs(this.d.getPosition(this.b, d + 0.5, true, false).get(0) - d4) + 1.0;
                    double d6 = this.e.getPosition(this.c, d2 - 0.5, true, false).get(1);
                    double d7 = Math.abs(this.e.getPosition(this.c, d2 + 0.5, true, false).get(1) - d6) + 1.0;
                    this.a.setFrame(0.0, 0.0, d5, d7);
                    object = ((DrawingContext)object).getGraphics();
                    Color color = ((ColorMapper)this.g.a.getSetting(COLORS)).get(d3);
                    GraphicsUtils.fillPaintedShape((Graphics2D)object, this.a, color, this.a.getBounds2D());
                }
            };
        }

        public Shape getPointPath(Row row) {
            return null;
        }
    }
}

