/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots;

import de.erichseifert.gral.plots.NavigationListener;
import de.erichseifert.gral.plots.Plot;
import de.erichseifert.gral.plots.axes.Axis;
import de.erichseifert.gral.plots.axes.AxisRenderer;
import de.erichseifert.gral.util.MathUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlotNavigator {
    private final Plot a;
    private final Map<String, a> b;
    private final Set<String> c = new HashSet<String>();
    private final Set<NavigationListener> d = new HashSet<NavigationListener>();
    private double e;
    private double f;

    public PlotNavigator(Plot plot) {
        this.a = plot;
        this.setAxes(plot.getAxesNames());
        this.b = new HashMap<String, a>();
        this.setDefaultState();
        this.e = 0.01;
        this.f = 100.0;
    }

    private void a() {
        for (String string : this.c) {
            Object object = this.a.getAxisRenderer(string);
            if (object == null) continue;
            Axis axis = this.getPlot().getAxis(string);
            a a2 = this.b.get(string);
            double d = object.worldToView(axis, a2.a(), true);
            double d2 = object.worldToView(axis, a2.b(), true) - d;
            double d3 = a2.e();
            double d4 = d2 * d3;
            double d5 = object.worldToView(axis, a2.d(), true);
            Number number = object.viewToWorld(axis, d5 - d4 * 0.5, true);
            object = object.viewToWorld(axis, d5 + d4 * 0.5, true);
            axis.setRange(number, (Number)object);
        }
    }

    public Plot getPlot() {
        return this.a;
    }

    public double getZoom() {
        double d = 0.0;
        int n = 0;
        for (a a2 : this.b.values()) {
            if (Double.isNaN(a2.e())) continue;
            d += a2.e();
            ++n;
        }
        return d / (double)n;
    }

    public void setZoom(double d) {
        if (d <= 0.0 || Double.isNaN(d) || Double.isInfinite(d)) {
            return;
        }
        d = MathUtils.limit(d, this.e, this.f);
        boolean bl = false;
        for (Map.Entry<String, a> entry : this.b.entrySet()) {
            String string = entry.getKey();
            a object = entry.getValue();
            double d2 = object.e();
            if (d2 == d) continue;
            bl = true;
            object.b(d);
            this.fireZoomChanged(string, d2, d);
        }
        if (bl) {
            this.a();
        }
    }

    public Number getCenter(String string) {
        if (!this.b.containsKey(string)) {
            return null;
        }
        return this.b.get(string).d();
    }

    public void setCenter(String string, Number number) {
        Number number2 = this.getCenter(string);
        if (number2.equals(number)) {
            return;
        }
        this.b.get(string).a(number.doubleValue());
        this.fireCenterChanged(string, number2, number);
        this.a();
    }

    public void setDefaultState() {
        this.b.clear();
        for (String string : this.a.getAxesNames()) {
            Object object = this.a.getAxis(string);
            Number number = 0.0;
            AxisRenderer axisRenderer = this.a.getAxisRenderer(string);
            if (axisRenderer != null) {
                double d = axisRenderer.worldToView((Axis)object, ((Axis)object).getMin(), false);
                double d2 = axisRenderer.worldToView((Axis)object, ((Axis)object).getMax(), false);
                if (!Double.isNaN(d) && !Double.isNaN(d2)) {
                    number = axisRenderer.viewToWorld((Axis)object, (d + d2) / 2.0, false);
                }
            }
            object = new a(((Axis)object).getMin(), ((Axis)object).getMax(), (double)number);
            this.b.put(string, (a)object);
        }
    }

    public void reset() {
        for (Map.Entry<String, a> entry : this.b.entrySet()) {
            String string = entry.getKey();
            a object = entry.getValue();
            double d = object.c();
            double d2 = object.d();
            object.a(d);
            this.fireCenterChanged(string, d2, d);
            double d3 = object.e();
            object.b(1.0);
            this.fireZoomChanged(string, d3, 1.0);
        }
        this.a();
    }

    public double getZoomMin() {
        return this.e;
    }

    public void setZoomMin(double d) {
        this.e = d;
    }

    public double getZoomMax() {
        return this.f;
    }

    public void setZoomMax(double d) {
        this.f = d;
    }

    public void addNavigationListener(NavigationListener navigationListener) {
        this.d.add(navigationListener);
    }

    public void removeNavigationListener(NavigationListener navigationListener) {
        this.d.remove(navigationListener);
    }

    protected void fireCenterChanged(String string, Number number, Number number2) {
        if (!this.c.contains(string)) {
            return;
        }
        Iterator<NavigationListener> iterator = this.d.iterator();
        while (iterator.hasNext()) {
            iterator.next().centerChanged(this, string, number, number2);
        }
    }

    protected void fireZoomChanged(String string, double d, double d2) {
        if (!this.c.contains(string)) {
            return;
        }
        Iterator<NavigationListener> iterator = this.d.iterator();
        while (iterator.hasNext()) {
            iterator.next().zoomChanged(this, string, d, d2);
        }
    }

    public Set<String> getAxes() {
        return Collections.unmodifiableSet(this.c);
    }

    public void setAxes(Collection<String> collection) {
        this.c.clear();
        this.c.addAll(collection);
    }

    public void setAxes(String ... stringArray) {
        this.setAxes(Arrays.asList(stringArray));
    }

    private static final class a {
        private final Number a;
        private final Number b;
        private final double c;
        private double d;
        private double e;

        public a(Number number, Number number2, double d) {
            this.a = number;
            this.b = number2;
            this.d = this.c = d;
            this.e = 1.0;
        }

        public final Number a() {
            return this.a;
        }

        public final Number b() {
            return this.b;
        }

        public final double c() {
            return this.c;
        }

        public final double d() {
            return this.d;
        }

        public final void a(double d) {
            this.d = d;
        }

        public final double e() {
            return this.e;
        }

        public final void b(double d) {
            this.e = d;
        }
    }
}

