/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots;

import de.erichseifert.gral.Container;
import de.erichseifert.gral.Drawable;
import de.erichseifert.gral.DrawableContainer;
import de.erichseifert.gral.DrawingContext;
import de.erichseifert.gral.EdgeLayout;
import de.erichseifert.gral.Legend;
import de.erichseifert.gral.Location;
import de.erichseifert.gral.PlotArea;
import de.erichseifert.gral.data.Column;
import de.erichseifert.gral.data.DataChangeEvent;
import de.erichseifert.gral.data.DataListener;
import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.plots.Label;
import de.erichseifert.gral.plots.axes.Axis;
import de.erichseifert.gral.plots.axes.AxisRenderer;
import de.erichseifert.gral.util.GraphicsUtils;
import de.erichseifert.gral.util.Insets2D;
import de.erichseifert.gral.util.SettingChangeEvent;
import de.erichseifert.gral.util.SettingsListener;
import de.erichseifert.gral.util.SettingsStorage;
import de.erichseifert.gral.util.Tuple;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Plot
extends DrawableContainer
implements DataListener,
SettingsListener {
    public static final SettingsStorage.Key TITLE = new SettingsStorage.Key("plot.title");
    public static final SettingsStorage.Key TITLE_FONT = new SettingsStorage.Key("plot.title.font");
    public static final SettingsStorage.Key BACKGROUND = new SettingsStorage.Key("plot.background");
    public static final SettingsStorage.Key BORDER = new SettingsStorage.Key("plot.border");
    public static final SettingsStorage.Key COLOR = new SettingsStorage.Key("plot.color");
    public static final SettingsStorage.Key ANTIALISING = new SettingsStorage.Key("plot.antialiasing");
    public static final SettingsStorage.Key LEGEND = new SettingsStorage.Key("plot.legend");
    public static final SettingsStorage.Key LEGEND_LOCATION = new SettingsStorage.Key("plot.legend.location");
    public static final SettingsStorage.Key LEGEND_MARGIN = new SettingsStorage.Key("plot.legend.margin");
    private final List<DataSource> a;
    private final Set<DataSource> b;
    private final Map<String, Axis> c;
    private final Map<String, AxisRenderer> d;
    private final Map<String, Drawable> e;
    private final Map<Tuple, String> f;
    private final Map<String, Double> g;
    private final Map<String, Double> h;
    private final Label i = new Label();
    private PlotArea j;
    private final Container k;
    private Legend l;

    public Plot(DataSource ... dataSourceArray) {
        super(new EdgeLayout(20.0, 20.0));
        this.i.setSetting(Label.FONT, Font.decode(null).deriveFont(18.0f));
        this.k = new DrawableContainer(new EdgeLayout(0.0, 0.0));
        this.b = new HashSet<DataSource>();
        this.c = new HashMap<String, Axis>();
        this.d = new HashMap<String, AxisRenderer>();
        this.e = new HashMap<String, Drawable>();
        this.f = new HashMap<Tuple, String>();
        this.g = new HashMap<String, Double>();
        this.h = new HashMap<String, Double>();
        this.a = new LinkedList<DataSource>();
        for (DataSource dataSource : dataSourceArray) {
            this.add(dataSource);
        }
        this.addSettingsListener(this);
        this.setSettingDefault(TITLE, null);
        this.setSettingDefault(TITLE_FONT, Font.decode(null).deriveFont(18.0f));
        this.setSettingDefault(BACKGROUND, null);
        this.setSettingDefault(BORDER, null);
        this.setSettingDefault(COLOR, Color.BLACK);
        this.setSettingDefault(ANTIALISING, true);
        this.setSettingDefault(LEGEND, false);
        this.setSettingDefault(LEGEND_LOCATION, Location.NORTH_WEST);
        this.setSettingDefault(LEGEND_MARGIN, new Insets2D.Double(20.0));
        this.add(this.i, (Object)Location.NORTH);
    }

    @Override
    public void draw(DrawingContext drawingContext) {
        Graphics2D graphics2D = drawingContext.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, (Boolean)this.getSetting(ANTIALISING) != false ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        Object object = (Paint)this.getSetting(BACKGROUND);
        if (object != null) {
            GraphicsUtils.fillPaintedShape(graphics2D, this.getBounds(), (Paint)object, null);
        }
        if ((object = (Stroke)this.getSetting(BORDER)) != null) {
            Paint paint = (Paint)this.getSetting(COLOR);
            GraphicsUtils.drawPaintedShape(graphics2D, this.getBounds(), paint, null, (Stroke)object);
        }
        this.drawComponents(drawingContext);
    }

    protected void drawAxes(DrawingContext drawingContext) {
        for (Drawable drawable : this.e.values()) {
            if (drawable == null) continue;
            drawable.draw(drawingContext);
        }
    }

    protected void drawLegend(DrawingContext drawingContext) {
        if (!((Boolean)this.getSetting(LEGEND)).booleanValue() || this.l == null) {
            return;
        }
        this.l.draw(drawingContext);
    }

    public Axis getAxis(String string) {
        return this.c.get(string);
    }

    public void setAxis(String string, Axis axis) {
        if (axis == null) {
            this.removeAxis(string);
            return;
        }
        this.c.put(string, axis);
    }

    public void removeAxis(String string) {
        this.c.remove(string);
        this.d.remove(string);
        this.e.remove(string);
    }

    public Collection<String> getAxesNames() {
        return this.c.keySet();
    }

    public AxisRenderer getAxisRenderer(String string) {
        return this.d.get(string);
    }

    public void setAxisRenderer(String object, AxisRenderer object2) {
        Object object3 = null;
        if (object2 == null) {
            this.d.remove(object);
        } else {
            this.d.put((String)object, (AxisRenderer)object2);
            object3 = this.getAxis((String)object);
            object3 = object2.getRendererComponent((Axis)object3);
        }
        object2 = object;
        object = this;
        if (object3 == null) {
            ((Plot)object).e.remove(object2);
        } else {
            ((Plot)object).e.put((String)object2, (Drawable)object3);
        }
        this.layout();
    }

    protected Drawable getAxisComponent(String string) {
        return this.e.get(string);
    }

    public PlotArea getPlotArea() {
        return this.j;
    }

    protected void setPlotArea(PlotArea plotArea) {
        if (this.j != null) {
            this.remove(this.j);
        }
        this.j = plotArea;
        if (this.j != null) {
            this.add(this.j, (Object)Location.CENTER);
        }
    }

    public Label getTitle() {
        return this.i;
    }

    protected Container getLegendContainer() {
        return this.k;
    }

    public Legend getLegend() {
        return this.l;
    }

    protected void setLegend(Legend legend) {
        if (this.l != null) {
            this.k.remove(this.l);
        }
        this.l = legend;
        if (this.l != null) {
            Location location = (Location)((Object)this.getSetting(LEGEND_LOCATION));
            this.k.add(legend, (Object)location);
        }
    }

    @Override
    public void settingChanged(SettingChangeEvent object) {
        if (TITLE.equals(object = ((SettingChangeEvent)object).getKey())) {
            object = (String)this.getSetting(TITLE);
            if (object == null) {
                object = "";
            }
            this.i.setText((String)object);
            return;
        }
        if (TITLE_FONT.equals(object)) {
            object = (Font)this.getSetting(TITLE_FONT);
            if (object == null) {
                object = Font.decode(null).deriveFont(18.0f);
            }
            this.i.setSetting(Label.FONT, object);
            return;
        }
        if (LEGEND_LOCATION.equals(object)) {
            object = (Location)((Object)this.getSetting(LEGEND_LOCATION));
            if (this.l != null) {
                this.k.remove(this.l);
                this.k.add(this.l, object);
            }
            return;
        }
        if (LEGEND_MARGIN.equals(object)) {
            object = (Insets2D)this.getSetting(LEGEND_MARGIN);
            this.k.setInsets((Insets2D)object);
        }
    }

    public void add(DataSource dataSource) {
        this.add(dataSource, true);
    }

    public void add(DataSource dataSource, boolean bl) {
        this.add(this.a.size(), dataSource, bl);
    }

    public void add(int n, DataSource dataSource, boolean bl) {
        this.a.add(n, dataSource);
        if (this.getLegend() != null) {
            this.getLegend().add(dataSource);
        }
        if (bl) {
            this.b.add(dataSource);
        }
        dataSource.addDataListener(this);
        this.refresh();
    }

    public boolean contains(DataSource dataSource) {
        return this.a.contains(dataSource);
    }

    public DataSource get(int n) {
        return this.a.get(n);
    }

    public boolean remove(DataSource dataSource) {
        dataSource.removeDataListener(this);
        this.b.remove(dataSource);
        if (this.getLegend() != null) {
            this.getLegend().remove(dataSource);
        }
        boolean bl = this.a.remove(dataSource);
        this.refresh();
        return bl;
    }

    public void clear() {
        Iterator<DataSource> iterator = this.a.iterator();
        while (iterator.hasNext()) {
            iterator.next().removeDataListener(this);
        }
        this.b.clear();
        if (this.getLegend() != null) {
            this.getLegend().clear();
        }
        this.a.clear();
        this.refresh();
    }

    public String[] getMapping(DataSource dataSource) {
        String[] stringArray = new String[dataSource.getColumnCount()];
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            int n = i;
            Plot plot = this;
            Object object = dataSource;
            if (!plot.contains((DataSource)object)) {
                string = null;
            } else {
                object = new Tuple(object, n);
                string = plot.f.get(object);
            }
            stringArray[i] = string;
        }
        return stringArray;
    }

    public void setMapping(DataSource dataSource, String ... stringArray) {
        if (!this.contains(dataSource)) {
            throw new IllegalArgumentException("Data source does not exist in plot.");
        }
        if (stringArray.length > dataSource.getColumnCount()) {
            throw new IllegalArgumentException(String.format("Data source only has %d column, %d values given.", dataSource.getColumnCount(), stringArray.length));
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string == null) continue;
            Tuple tuple = new Tuple(dataSource, i);
            this.f.put(tuple, string);
        }
        this.refresh();
    }

    protected Double getAxisMin(String object) {
        if ((object = this.g.get(object)) == null) {
            return 0.0;
        }
        return object;
    }

    protected Double getAxisMax(String object) {
        if ((object = this.h.get(object)) == null) {
            return 0.0;
        }
        return object;
    }

    public List<DataSource> getData() {
        return Collections.unmodifiableList(this.a);
    }

    public List<DataSource> getVisibleData() {
        LinkedList<DataSource> linkedList = new LinkedList<DataSource>();
        for (DataSource dataSource : this.a) {
            if (!this.b.contains(dataSource)) continue;
            linkedList.add(dataSource);
        }
        return linkedList;
    }

    public boolean isVisible(DataSource dataSource) {
        return this.b.contains(dataSource);
    }

    public void setVisible(DataSource dataSource, boolean bl) {
        if (bl) {
            if (this.b.add(dataSource)) {
                this.refresh();
                return;
            }
        } else if (this.b.remove(dataSource)) {
            this.refresh();
        }
    }

    @Override
    public void dataAdded(DataSource dataSource, DataChangeEvent ... dataChangeEventArray) {
        this.refresh();
    }

    @Override
    public void dataUpdated(DataSource dataSource, DataChangeEvent ... dataChangeEventArray) {
        this.refresh();
    }

    @Override
    public void dataRemoved(DataSource dataSource, DataChangeEvent ... dataChangeEventArray) {
        this.refresh();
    }

    public void refresh() {
        this.g.clear();
        this.h.clear();
        for (Map.Entry<Tuple, String> entry : this.f.entrySet()) {
            Object object = entry.getKey();
            object = ((DataSource)((Tuple)object).get(0)).getColumn((Integer)((Tuple)object).get(1));
            String object2 = entry.getValue();
            Double d = this.g.get(object2);
            Double d2 = this.h.get(object2);
            if (d == null || d2 == null) {
                d = ((Column)object).getStatistics("min");
                d2 = ((Column)object).getStatistics("max");
            } else {
                d = Math.min(d, ((Column)object).getStatistics("min"));
                d2 = Math.max(d2, ((Column)object).getStatistics("max"));
            }
            this.g.put(object2, d);
            this.h.put(object2, d2);
        }
    }
}

