/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots;

import de.erichseifert.gral.DrawingContext;
import de.erichseifert.gral.PlotArea;
import de.erichseifert.gral.data.DataChangeEvent;
import de.erichseifert.gral.data.DataListener;
import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.plots.Plot;
import de.erichseifert.gral.plots.colors.ColorMapper;
import de.erichseifert.gral.plots.colors.QuasiRandomColors;
import de.erichseifert.gral.util.GraphicsUtils;
import de.erichseifert.gral.util.Insets2D;
import de.erichseifert.gral.util.SettingsStorage;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class PiePlot
extends Plot
implements DataListener {
    public static final SettingsStorage.Key RADIUS = new SettingsStorage.Key("pieplot.radius");
    public static final SettingsStorage.Key RADIUS_INNER = new SettingsStorage.Key("pieplot.radius.inner");
    public static final SettingsStorage.Key COLORS = new SettingsStorage.Key("pieplot.colorlist");
    public static final SettingsStorage.Key CLOCKWISE = new SettingsStorage.Key("pieplot.clockwise");
    public static final SettingsStorage.Key START = new SettingsStorage.Key("pieplot.start");
    public static final SettingsStorage.Key GAP = new SettingsStorage.Key("pieplot.gap");

    public PiePlot(DataSource dataSource) {
        super(dataSource);
        this.setSettingDefault(RADIUS, 1.0);
        this.setSettingDefault(RADIUS_INNER, 0.0);
        this.setSettingDefault(COLORS, new QuasiRandomColors());
        this.setSettingDefault(CLOCKWISE, true);
        this.setSettingDefault(START, 0.0);
        this.setSettingDefault(GAP, 0.0);
        this.setPlotArea(new PiePlotArea2D(this));
        this.dataUpdated(dataSource, new DataChangeEvent[0]);
        dataSource.addDataListener(this);
    }

    public void add(int n, DataSource dataSource, boolean bl) {
        if (this.getData().size() != 0) {
            throw new IllegalArgumentException("This plot type only supports a single data source.");
        }
        super.add(n, dataSource, bl);
    }

    public void dataAdded(DataSource dataSource, DataChangeEvent ... dataChangeEventArray) {
        ((DataListener)((Object)this.getPlotArea())).dataAdded(dataSource, dataChangeEventArray);
    }

    public void dataUpdated(DataSource dataSource, DataChangeEvent ... dataChangeEventArray) {
        ((DataListener)((Object)this.getPlotArea())).dataUpdated(dataSource, dataChangeEventArray);
    }

    public void dataRemoved(DataSource dataSource, DataChangeEvent ... dataChangeEventArray) {
        ((DataListener)((Object)this.getPlotArea())).dataRemoved(dataSource, dataChangeEventArray);
    }

    public static class PiePlotArea2D
    extends PlotArea
    implements DataListener {
        private final PiePlot a;
        private double b;
        private ArrayList<double[]> c;

        public PiePlotArea2D(PiePlot piePlot) {
            this.a = piePlot;
        }

        public void draw(DrawingContext drawingContext) {
            this.drawBackground(drawingContext);
            this.drawBorder(drawingContext);
            this.drawPlot(drawingContext);
        }

        protected void drawPlot(DrawingContext object) {
            object = ((DrawingContext)object).getGraphics();
            AffineTransform affineTransform = ((Graphics2D)object).getTransform();
            ((Graphics2D)object).translate(this.getX(), this.getY());
            AffineTransform affineTransform2 = ((Graphics2D)object).getTransform();
            Insets2D insets2D = (Insets2D)this.getSetting(CLIPPING);
            if (insets2D != null) {
                Rectangle2D.Double double_ = new Rectangle2D.Double(insets2D.getLeft() * 10.0, insets2D.getTop() * 10.0, this.getWidth() - insets2D.getHorizontal() * 10.0, this.getHeight() - insets2D.getVertical() * 10.0);
                ((Graphics)object).setClip(double_);
            }
            double d = this.getWidth();
            double d2 = this.getHeight();
            if (d <= 0.0 || d2 <= 0.0) {
                return;
            }
            ((Graphics2D)object).translate(d / 2.0, d2 / 2.0);
            ColorMapper colorMapper = (ColorMapper)this.a.getSetting(COLORS);
            double d3 = ((Number)this.a.getSetting(RADIUS)).doubleValue();
            double d4 = Math.min(d, d2) * d3;
            double d5 = ((Number)this.a.getSetting(RADIUS_INNER)).doubleValue();
            double d6 = d4 * d5;
            Shape shape = new Ellipse2D.Double(-d6 / 2.0, -d6 / 2.0, d6, d6);
            shape = new Area(shape);
            double d7 = ((Number)this.a.getSetting(GAP)).doubleValue();
            double d8 = ((Number)this.a.getSetting(START)).doubleValue();
            int n = 0;
            for (Object object2 : this.c) {
                double d9 = d8 + object2[0];
                double d10 = object2[1];
                ++n;
                if (Double.isNaN(d10)) continue;
                object2 = new Arc2D.Double(-d4 / 2.0, -d4 / 2.0, d4, d4, d9, d10, 2);
                Area area = new Area((Shape)object2);
                if (d7 > 0.0) {
                    BasicStroke basicStroke = new BasicStroke((float)(d7 * 10.0));
                    object2 = new Area(basicStroke.createStrokedShape((Shape)object2));
                    area.subtract((Area)object2);
                }
                if (d5 > 0.0) {
                    area.subtract((Area)shape);
                }
                Color color = colorMapper.get((double)n - 1.0 / (double)this.c.size());
                GraphicsUtils.fillPaintedShape((Graphics2D)object, area, color, null);
            }
            if (insets2D != null) {
                ((Graphics)object).setClip(null);
            }
            ((Graphics2D)object).setTransform(affineTransform2);
            ((Graphics2D)object).setTransform(affineTransform);
        }

        public void dataAdded(DataSource dataSource, DataChangeEvent ... dataChangeEventArray) {
            this.a(dataSource);
        }

        public void dataUpdated(DataSource dataSource, DataChangeEvent ... dataChangeEventArray) {
            this.a(dataSource);
        }

        public void dataRemoved(DataSource dataSource, DataChangeEvent ... dataChangeEventArray) {
            this.a(dataSource);
        }

        private void a(DataSource dataSource) {
            double d;
            double d2 = 0.0;
            for (int i = 0; i < dataSource.getRowCount(); ++i) {
                d = dataSource.get(0, i).doubleValue();
                d2 += Math.abs(d);
            }
            this.b = (Boolean)this.a.getSetting(CLOCKWISE) != false ? -360.0 / d2 : 360.0 / d2;
            this.c = new ArrayList(dataSource.getRowCount());
            d = 0.0;
            for (int i = 0; i < dataSource.getRowCount(); ++i) {
                double d3 = dataSource.get(0, i).doubleValue();
                double[] dArray = new double[]{d, Double.NaN};
                this.c.add(dArray);
                if (Double.isNaN(d3) || Double.isInfinite(d3)) continue;
                dArray[0] = d;
                dArray[1] = Double.NaN;
                if (d3 >= 0.0) {
                    dArray[1] = d3 * this.b;
                }
                d += Math.abs(d3) * this.b;
            }
        }
    }
}

