/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots;

import de.erichseifert.gral.AbstractDrawable;
import de.erichseifert.gral.DrawingContext;
import de.erichseifert.gral.Location;
import de.erichseifert.gral.util.GraphicsUtils;
import de.erichseifert.gral.util.SettingChangeEvent;
import de.erichseifert.gral.util.SettingsListener;
import de.erichseifert.gral.util.SettingsStorage;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class Label
extends AbstractDrawable
implements SettingsListener {
    public static final SettingsStorage.Key ALIGNMENT_X = new SettingsStorage.Key("label.alignment.x");
    public static final SettingsStorage.Key ALIGNMENT_Y = new SettingsStorage.Key("label.alignment.y");
    public static final SettingsStorage.Key ANCHOR = new SettingsStorage.Key("label.anchor");
    public static final SettingsStorage.Key FONT = new SettingsStorage.Key("label.font");
    public static final SettingsStorage.Key ROTATION = new SettingsStorage.Key("label.rotation");
    public static final SettingsStorage.Key COLOR = new SettingsStorage.Key("label.color");
    private String a;
    private TextLayout b;
    private Shape c;
    private boolean d;

    public Label() {
        this("");
    }

    public Label(String string) {
        this.addSettingsListener(this);
        this.a = string;
        this.setSettingDefault(ALIGNMENT_X, 0.5);
        this.setSettingDefault(ALIGNMENT_Y, 0.5);
        this.setSettingDefault(ANCHOR, Location.CENTER);
        this.setSettingDefault(FONT, Font.decode(null));
        this.setSettingDefault(ROTATION, 0.0);
        this.setSettingDefault(COLOR, Color.BLACK);
    }

    public void draw(DrawingContext object) {
        if (this.getLayout() == null) {
            return;
        }
        Object object2 = AffineTransform.getTranslateInstance(this.getX() + this.getWidth() / 2.0, this.getY() + this.getHeight() / 2.0);
        double d = ((Number)this.getSetting(ROTATION)).doubleValue();
        if (!Double.isNaN(d) && d % 360.0 != 0.0) {
            ((AffineTransform)object2).rotate(-d / 180.0 * Math.PI);
        }
        Object object3 = this.getLayout().getBounds();
        double d2 = ((Number)this.getSetting(ALIGNMENT_X)).doubleValue();
        double d3 = ((Number)this.getSetting(ALIGNMENT_Y)).doubleValue();
        Object object4 = (Location)((Object)this.getSetting(ANCHOR));
        double d4 = object4.getAlignmentH() - 0.5;
        double d5 = -object4.getAlignmentV() + 0.5;
        ((AffineTransform)object2).translate(-((RectangularShape)object3).getX() - d4 * ((RectangularShape)object3).getWidth() - d2 * ((RectangularShape)object3).getWidth() + (d2 - 0.5) * this.getWidth(), -((RectangularShape)object3).getY() - d5 * ((RectangularShape)object3).getHeight() - d3 * ((RectangularShape)object3).getHeight() + (d3 - 0.5) * this.getHeight());
        object2 = ((AffineTransform)object2).createTransformedShape(this.c);
        object = ((DrawingContext)object).getGraphics();
        object3 = ((Graphics2D)object).getPaint();
        object4 = (Paint)this.getSetting(COLOR);
        ((Graphics2D)object).setPaint((Paint)object4);
        GraphicsUtils.fillPaintedShape((Graphics2D)object, (Shape)object2, (Paint)object4, null);
        ((Graphics2D)object).setPaint((Paint)object3);
    }

    public Dimension2D getPreferredSize() {
        Dimension2D dimension2D = super.getPreferredSize();
        if (this.getLayout() != null) {
            Shape shape = this.getTextRectangle();
            Rectangle2D rectangle2D = shape.getBounds2D();
            double d = ((Number)this.getSetting(ROTATION)).doubleValue();
            if (!Double.isNaN(d) && d % 360.0 != 0.0) {
                shape = AffineTransform.getRotateInstance(-d / 180.0 * Math.PI, rectangle2D.getCenterX(), rectangle2D.getCenterY()).createTransformedShape(shape);
            }
            dimension2D.setSize(shape.getBounds2D().getWidth(), shape.getBounds2D().getHeight());
        }
        return dimension2D;
    }

    protected TextLayout getLayout() {
        if (!this.d && this.a != null && !this.a.isEmpty()) {
            this.b = GraphicsUtils.getLayout(this.a, (Font)this.getSetting(FONT));
            this.c = this.b.getOutline(null);
            this.d = true;
        }
        return this.b;
    }

    public Rectangle2D getTextRectangle() {
        return this.getLayout().getBounds();
    }

    public String getText() {
        return this.a;
    }

    public void setText(String string) {
        this.a = string;
        this.invalidate();
    }

    protected void invalidate() {
        this.b = null;
        this.c = null;
        this.d = false;
    }

    public void settingChanged(SettingChangeEvent serializable) {
        if (FONT.equals(serializable = serializable.getKey())) {
            this.invalidate();
        }
    }
}

