/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots;

import de.erichseifert.gral.AbstractDrawable;
import de.erichseifert.gral.Drawable;
import de.erichseifert.gral.DrawingContext;
import de.erichseifert.gral.data.Column;
import de.erichseifert.gral.data.DataChangeEvent;
import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.DataTable;
import de.erichseifert.gral.data.Row;
import de.erichseifert.gral.plots.XYPlot;
import de.erichseifert.gral.plots.axes.Axis;
import de.erichseifert.gral.plots.axes.AxisRenderer;
import de.erichseifert.gral.plots.points.AbstractPointRenderer;
import de.erichseifert.gral.plots.points.PointRenderer;
import de.erichseifert.gral.util.GraphicsUtils;
import de.erichseifert.gral.util.SettingsStorage;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class BoxPlot
extends XYPlot {
    public static final SettingsStorage.Key BOX_WIDTH = new SettingsStorage.Key("boxplot.box.width");
    public static final SettingsStorage.Key BOX_BACKGROUND = new SettingsStorage.Key("boxplot.box.background");
    public static final SettingsStorage.Key BOX_COLOR = new SettingsStorage.Key("boxplot.box.background");
    public static final SettingsStorage.Key BOX_BORDER = new SettingsStorage.Key("boxplot.box.border");
    public static final SettingsStorage.Key WHISKER_COLOR = new SettingsStorage.Key("boxplot.whisker.color");
    public static final SettingsStorage.Key WHISKER_STROKE = new SettingsStorage.Key("boxplot.whisker.stroke");
    public static final SettingsStorage.Key BAR_WIDTH = new SettingsStorage.Key("boxplot.bar.width");
    public static final SettingsStorage.Key BAR_MEDIAN_COLOR = new SettingsStorage.Key("boxplot.bar.median.color");
    public static final SettingsStorage.Key BAR_MEDIAN_STROKE = new SettingsStorage.Key("boxplot.bar.median.stroke");
    private final DataSource a;
    private final DataTable b;

    public BoxPlot(DataSource object) {
        super(new DataSource[0]);
        this.setSettingDefault(BOX_WIDTH, 0.75);
        this.setSettingDefault(BOX_BACKGROUND, Color.WHITE);
        this.setSettingDefault(BOX_COLOR, Color.BLACK);
        this.setSettingDefault(BOX_BORDER, new BasicStroke(1.0f));
        this.setSettingDefault(WHISKER_COLOR, Color.BLACK);
        this.setSettingDefault(WHISKER_STROKE, new BasicStroke(1.0f));
        this.setSettingDefault(BAR_WIDTH, 0.75);
        this.setSettingDefault(BAR_MEDIAN_COLOR, Color.BLACK);
        this.setSettingDefault(BAR_MEDIAN_STROKE, new BasicStroke(2.0f, 0, 0));
        this.getPlotArea().setSettingDefault(XYPlot.XYPlotArea2D.GRID_MAJOR_X, false);
        this.getAxisRenderer(AXIS_X).setSetting(AxisRenderer.TICKS_SPACING, 1.0);
        this.getAxisRenderer(AXIS_X).setSetting(AxisRenderer.TICKS_MINOR, false);
        this.getAxisRenderer(AXIS_X).setSetting(AxisRenderer.INTERSECTION, -1.7976931348623157E308);
        this.getAxisRenderer(AXIS_Y).setSetting(AxisRenderer.INTERSECTION, -1.7976931348623157E308);
        this.a = object;
        object.addDataListener(this);
        this.b = new DataTable(Integer.class, Double.class, Double.class, Double.class, Double.class, Double.class);
        this.a();
        this.add(this.b);
        this.getAxis(AXIS_X).setRange(0.5, (double)object.getColumnCount() + 0.5);
        double d = this.b.getColumn(2).getStatistics("min");
        double d2 = this.b.getColumn(5).getStatistics("max");
        double d3 = 0.05 * (d2 - d);
        this.getAxis(AXIS_Y).setRange(d - d3, d2 + d3);
        object = new BoxWhiskerRenderer(this);
        this.setLineRenderer(this.b, null);
        this.setPointRenderer(this.b, (PointRenderer)object);
    }

    private void a() {
        this.b.clear();
        for (int i = 0; i < this.a.getColumnCount(); ++i) {
            Column column = this.a.getColumn(i);
            this.b.add(i + 1, column.getStatistics("quantile50"), column.getStatistics("min"), column.getStatistics("quantile25"), column.getStatistics("quantile75"), column.getStatistics("max"));
        }
    }

    public void add(int n, DataSource dataSource, boolean bl) {
        if (this.getData().size() != 0) {
            throw new IllegalArgumentException("This plot type only supports a single data source.");
        }
        super.add(n, dataSource, bl);
    }

    public void dataAdded(DataSource dataSource, DataChangeEvent ... dataChangeEventArray) {
        super.dataAdded(dataSource, dataChangeEventArray);
        if (dataSource == this.a) {
            this.a();
        }
    }

    public void dataUpdated(DataSource dataSource, DataChangeEvent ... dataChangeEventArray) {
        super.dataUpdated(dataSource, dataChangeEventArray);
        if (dataSource == this.a) {
            this.a();
        }
    }

    public void dataRemoved(DataSource dataSource, DataChangeEvent ... dataChangeEventArray) {
        super.dataRemoved(dataSource, dataChangeEventArray);
        if (dataSource == this.a) {
            this.a();
        }
    }

    protected static class BoxWhiskerRenderer
    extends AbstractPointRenderer {
        private final BoxPlot a;

        public BoxWhiskerRenderer(BoxPlot boxPlot) {
            this.a = boxPlot;
        }

        public Drawable getPoint(Axis axis, AxisRenderer axisRenderer, Row row) {
            return new AbstractDrawable(this, row){
                private /* synthetic */ Row a;
                private /* synthetic */ BoxWhiskerRenderer b;
                {
                    this.b = boxWhiskerRenderer;
                    this.a = row;
                }

                public final void draw(DrawingContext object) {
                    Object object2 = this.b.a.getAxis(XYPlot.AXIS_X);
                    Object object3 = this.b.a.getAxis(XYPlot.AXIS_Y);
                    Object object4 = this.b.a.getAxisRenderer(XYPlot.AXIS_X);
                    Object object5 = this.b.a.getAxisRenderer(XYPlot.AXIS_Y);
                    double d = this.a.get(0).doubleValue();
                    double d2 = this.a.get(2).doubleValue();
                    double d3 = this.a.get(3).doubleValue();
                    double d4 = this.a.get(1).doubleValue();
                    double d5 = this.a.get(4).doubleValue();
                    double d6 = this.a.get(5).doubleValue();
                    double d7 = ((Number)this.b.a.getSetting(BOX_WIDTH)).doubleValue();
                    double d8 = object4.getPosition((Axis)object2, d - d7 * 0.5, true, false).get(0);
                    double d9 = object4.getPosition((Axis)object2, d, true, false).get(0);
                    double d10 = object4.getPosition((Axis)object2, d + d7 * 0.5, true, false).get(0);
                    double d11 = object5.getPosition((Axis)object3, d2, true, false).get(1);
                    double d12 = object5.getPosition((Axis)object3, d3, true, false).get(1);
                    double d13 = object5.getPosition((Axis)object3, d4, true, false).get(1);
                    double d14 = object5.getPosition((Axis)object3, d5, true, false).get(1);
                    double d15 = object5.getPosition((Axis)object3, d6, true, false).get(1);
                    double d16 = Math.abs(d10 - d8);
                    double d17 = ((Number)this.b.a.getSetting(BAR_WIDTH)).doubleValue();
                    double d18 = d8 + (1.0 - d17) * d16 / 2.0;
                    double d19 = d10 - (1.0 - d17) * d16 / 2.0;
                    object2 = new Rectangle2D.Double(d8 - d9, d14 - d13, d16, Math.abs(d14 - d12));
                    object3 = new Line2D.Double(0.0, d14 - d13, 0.0, d15 - d13);
                    object4 = new Line2D.Double(0.0, d12 - d13, 0.0, d11 - d13);
                    object5 = new Line2D.Double(d18 - d9, d15 - d13, d19 - d9, d15 - d13);
                    Line2D.Double double_ = new Line2D.Double(d18 - d9, d11 - d13, d19 - d9, d11 - d13);
                    Line2D.Double double_2 = new Line2D.Double(d8 - d9, 0.0, d10 - d9, 0.0);
                    object = ((DrawingContext)object).getGraphics();
                    Paint paint = (Paint)this.b.a.getSetting(BOX_BACKGROUND);
                    Paint paint2 = (Paint)this.b.a.getSetting(BOX_COLOR);
                    Stroke stroke = (Stroke)this.b.a.getSetting(BOX_BORDER);
                    Paint paint3 = (Paint)this.b.a.getSetting(WHISKER_COLOR);
                    Stroke stroke2 = (Stroke)this.b.a.getSetting(WHISKER_STROKE);
                    Paint paint4 = (Paint)this.b.a.getSetting(BAR_MEDIAN_COLOR);
                    Stroke stroke3 = (Stroke)this.b.a.getSetting(BAR_MEDIAN_STROKE);
                    GraphicsUtils.fillPaintedShape((Graphics2D)object, (Shape)object2, paint, ((Rectangle2D)object2).getBounds2D());
                    paint = ((Graphics2D)object).getPaint();
                    Stroke stroke4 = ((Graphics2D)object).getStroke();
                    ((Graphics2D)object).setPaint(paint3);
                    ((Graphics2D)object).setStroke(stroke2);
                    ((Graphics2D)object).draw((Shape)object3);
                    ((Graphics2D)object).draw((Shape)object4);
                    ((Graphics2D)object).setPaint(paint2);
                    ((Graphics2D)object).setStroke(stroke);
                    ((Graphics2D)object).draw((Shape)object2);
                    ((Graphics2D)object).draw((Shape)object5);
                    ((Graphics2D)object).draw(double_);
                    ((Graphics2D)object).setPaint(paint4);
                    ((Graphics2D)object).setStroke(stroke3);
                    ((Graphics2D)object).draw(double_2);
                    ((Graphics2D)object).setStroke(stroke4);
                    ((Graphics2D)object).setPaint(paint);
                }
            };
        }

        public Shape getPointPath(Row row) {
            return null;
        }
    }
}

