/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots;

import de.erichseifert.gral.AbstractDrawable;
import de.erichseifert.gral.Drawable;
import de.erichseifert.gral.DrawingContext;
import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.Row;
import de.erichseifert.gral.plots.XYPlot;
import de.erichseifert.gral.plots.axes.Axis;
import de.erichseifert.gral.plots.axes.AxisRenderer;
import de.erichseifert.gral.plots.points.AbstractPointRenderer;
import de.erichseifert.gral.plots.points.PointRenderer;
import de.erichseifert.gral.util.GraphicsUtils;
import de.erichseifert.gral.util.SettingsStorage;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

public class BarPlot
extends XYPlot {
    public static final SettingsStorage.Key BAR_WIDTH = new SettingsStorage.Key("barplot.barWidth");

    public BarPlot(DataSource ... dataSourceArray) {
        super(dataSourceArray);
        this.getPlotArea().setSettingDefault(XYPlot.XYPlotArea2D.GRID_MAJOR_X, false);
        this.setSettingDefault(BAR_WIDTH, 1.0);
        BarRenderer barRenderer = new BarRenderer(this);
        for (DataSource dataSource : dataSourceArray) {
            this.setLineRenderer(dataSource, null);
            this.setPointRenderer(dataSource, barRenderer);
        }
    }

    protected static class BarRenderer
    extends AbstractPointRenderer {
        private final BarPlot a;

        public BarRenderer(BarPlot barPlot) {
            this.a = barPlot;
        }

        public Drawable getPoint(Axis axis, AxisRenderer axisRenderer, Row row) {
            return new AbstractDrawable(this, row){
                private /* synthetic */ Row a;
                private /* synthetic */ BarRenderer b;
                {
                    this.b = barRenderer;
                    this.a = row;
                }

                public final void draw(DrawingContext drawingContext) {
                    Shape shape = this.b.getPointPath(this.a);
                    Paint paint = (Paint)this.b.getSetting(PointRenderer.COLOR);
                    GraphicsUtils.fillPaintedShape(drawingContext.getGraphics(), shape, paint, null);
                    if (((Boolean)this.b.getSetting(PointRenderer.VALUE_DISPLAYED)).booleanValue()) {
                        this.b.drawValue(drawingContext, shape, this.a.get(1).doubleValue());
                    }
                }
            };
        }

        public Shape getPointPath(Row object) {
            double d = ((Row)object).get(0).doubleValue();
            double d2 = ((Row)object).get(1).doubleValue();
            object = this.a.getAxis(XYPlot.AXIS_X);
            Axis axis = this.a.getAxis(XYPlot.AXIS_Y);
            AxisRenderer axisRenderer = this.a.getAxisRenderer(XYPlot.AXIS_X);
            AxisRenderer axisRenderer2 = this.a.getAxisRenderer(XYPlot.AXIS_Y);
            double d3 = ((Number)this.a.getSetting(BAR_WIDTH)).doubleValue();
            double d4 = axisRenderer.getPosition((Axis)object, d - d3 * 0.5, true, false).get(0);
            double d5 = axisRenderer.getPosition((Axis)object, d + d3 * 0.5, true, false).get(0);
            double d6 = axisRenderer2.getPosition(axis, d2, true, false).get(1);
            double d7 = axisRenderer2.getPosition(axis, 0.0, true, false).get(1);
            double d8 = Math.min(d6, d7);
            double d9 = Math.max(d6, d7);
            double d10 = Math.abs(d5 - d4);
            double d11 = Math.abs(d9 - d8);
            double d12 = axisRenderer.getPosition((Axis)object, d, true, false).get(0);
            double d13 = d9 == d7 ? 0.0 : -d11;
            return new Rectangle2D.Double(d4 - d12, d13, d10, d11);
        }
    }
}

