/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.io.data;

import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.io.IOCapabilities;
import de.erichseifert.gral.io.data.AbstractDataWriter;
import de.erichseifert.gral.util.Messages;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class CSVWriter
extends AbstractDataWriter {
    public CSVWriter(String string) {
        super(string);
        if ("text/tab-separated-values".equals(string)) {
            this.setDefault("separator", "\t");
            return;
        }
        this.setDefault("separator", ",");
    }

    public void write(DataSource object, OutputStream closeable) throws IOException {
        String string = (String)this.getSetting("separator");
        closeable = new OutputStreamWriter((OutputStream)closeable);
        int n = 0;
        int n2 = object.getColumnCount();
        object = object.iterator();
        while (object.hasNext()) {
            Number number = (Number)object.next();
            ((Writer)closeable).write(String.valueOf(number));
            if (n % n2 < n2 - 1) {
                ((Writer)closeable).write(string);
            } else {
                ((Writer)closeable).write("\r\n");
            }
            ++n;
        }
        ((OutputStreamWriter)closeable).close();
    }

    static {
        CSVWriter.addCapabilities(new IOCapabilities("CSV", Messages.getString("DataIO.csvDescription"), "text/csv", new String[]{"csv", "txt"}));
        CSVWriter.addCapabilities(new IOCapabilities("TSV", Messages.getString("DataIO.tsvDescription"), "text/tab-separated-values", new String[]{"tsv", "tab", "txt"}));
    }
}

