/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.io.data;

import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.DataTable;
import de.erichseifert.gral.io.IOCapabilities;
import de.erichseifert.gral.io.data.AbstractDataReader;
import de.erichseifert.gral.util.Messages;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVReader
extends AbstractDataReader {
    public CSVReader(String string) {
        super(string);
        if ("text/tab-separated-values".equals(string)) {
            this.setDefault("separator", "\t");
            return;
        }
        this.setDefault("separator", ",");
    }

    @Override
    public DataSource read(InputStream stringArray, Class<? extends Number> ... classArray) throws IOException {
        Object object;
        HashMap<Class<? extends Number>, Method> hashMap = new HashMap<Class<? extends Number>, Method>();
        Object object2 = classArray;
        int n = classArray.length;
        for (int i = 0; i < n; ++i) {
            Method method;
            object = object2[i];
            if (hashMap.containsKey(object) || (method = CSVReader.a(object)) == null) continue;
            hashMap.put((Class<? extends Number>)object, method);
        }
        object2 = (String)this.getSetting("separator");
        DataTable dataTable = new DataTable(classArray);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)stringArray));
        int n2 = 0;
        while ((object = bufferedReader.readLine()) != null) {
            stringArray = object.split((String)object2);
            if (stringArray.length < classArray.length) {
                throw new IllegalArgumentException(MessageFormat.format("Column count in file does not match: got {0,number,integer}, but expected {1,number,integer}.", stringArray.length, classArray.length));
            }
            object = new Number[classArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                Method method = (Method)hashMap.get(classArray[i]);
                try {
                    object[i] = (Number)method.invoke(null, stringArray[i]);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new RuntimeException(MessageFormat.format("Could not invoke method for parsing data type {0} in column {1,number,integer}.", classArray[i].getSimpleName(), i));
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException(MessageFormat.format("Could not access method for parsing data type {0} in column {1,number,integer}.", classArray[i].getSimpleName(), i));
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new IOException(MessageFormat.format("Type mismatch in line {0,number,integer}, column {1,number,integer}: got \"{2}\", but expected {3} value.", i, n2, stringArray[i], classArray[i].getSimpleName()));
                }
            }
            dataTable.add((Number)object);
            ++n2;
        }
        return dataTable;
    }

    private static Method a(Class<?> methodArray) {
        Method method = null;
        for (Method method2 : methodArray.getMethods()) {
            Class<?>[] classArray;
            if (!(method2.toString().indexOf("static") >= 0) || !((classArray = method2.getParameterTypes()).length == 1 && String.class.equals(classArray[0])) || !method2.getName().startsWith("parse")) continue;
            method = method2;
        }
        return method;
    }

    static {
        CSVReader.addCapabilities(new IOCapabilities("CSV", Messages.getString("DataIO.csvDescription"), "text/csv", new String[]{"csv", "txt"}));
        CSVReader.addCapabilities(new IOCapabilities("TSV", Messages.getString("DataIO.tsvDescription"), "text/tab-separated-values", new String[]{"tsv", "tab", "txt"}));
    }
}

