/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.data.statistics;

import de.erichseifert.gral.data.DataAccessor;
import de.erichseifert.gral.data.DataChangeEvent;
import de.erichseifert.gral.data.DataListener;
import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.util.MathUtils;
import de.erichseifert.gral.util.Orientation;
import de.erichseifert.gral.util.SortedList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Statistics
implements DataListener {
    public static final String N = "n";
    public static final String SUM = "sum";
    public static final String SUM2 = "sum2";
    public static final String SUM3 = "sum3";
    public static final String SUM4 = "sum4";
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String MEAN = "mean";
    public static final String MEAN_DEVIATION = "mean deviation";
    public static final String VARIANCE = "variance";
    public static final String SKEWNESS = "skewness";
    public static final String KURTOSIS = "kurtosis";
    public static final String MEDIAN = "quantile50";
    public static final String QUARTILE_1 = "quantile25";
    public static final String QUARTILE_2 = "quantile50";
    public static final String QUARTILE_3 = "quantile75";
    private final DataSource a;
    private final Map<String, Double> b = new HashMap<String, Double>();
    private final ArrayList<Map<String, Double>> c;
    private final ArrayList<Map<String, Double>> d;

    public Statistics(DataSource dataSource) {
        int n;
        this.c = new ArrayList(dataSource.getColumnCount());
        for (n = 0; n < dataSource.getColumnCount(); ++n) {
            this.c.add(new HashMap());
        }
        this.d = new ArrayList(dataSource.getRowCount());
        for (n = 0; n < dataSource.getRowCount(); ++n) {
            this.d.add(new HashMap());
        }
        this.a = dataSource;
        this.a.addDataListener(this);
    }

    public double get(String string) {
        return this.a(this.a, this.b, string);
    }

    public double get(String string, Orientation object, int n) {
        DataAccessor dataAccessor;
        if (object == Orientation.VERTICAL) {
            object = this.c.get(n);
            dataAccessor = this.a.getColumn(n);
        } else {
            object = this.d.get(n);
            dataAccessor = this.a.getRow(n);
        }
        return this.a(dataAccessor, (Map<String, Double>)object, string);
    }

    private double a(Iterable<Number> object, Map<String, Double> map, String string) {
        if (!map.containsKey(string)) {
            double d;
            Object object2;
            Object object3;
            Object object4;
            Map<String, Double> map2;
            if (N.equals(string) && !map.containsKey(N) || MIN.equals(string) && !map.containsKey(MIN) || MAX.equals(string) && !map.containsKey(MAX) || SUM.equals(string) && !map.containsKey(SUM) || SUM2.equals(string) && !map.containsKey(SUM2) || SUM3.equals(string) && !map.containsKey(SUM3) || SUM4.equals(string) && !map.containsKey(SUM4)) {
                map2 = map;
                object4 = object;
                map2.put(N, 0.0);
                map2.put(SUM, 0.0);
                map2.put(SUM2, 0.0);
                map2.put(SUM3, 0.0);
                map2.put(SUM4, 0.0);
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    object2 = (Number)object3.next();
                    d = Double.NaN;
                    if (object2 != null) {
                        d = ((Number)object2).doubleValue();
                    }
                    if (Double.isNaN(d)) continue;
                    if (!map2.containsKey(MIN) || d < map2.get(MIN)) {
                        map2.put(MIN, d);
                    }
                    if (!map2.containsKey(MAX) || d > map2.get(MAX)) {
                        map2.put(MAX, d);
                    }
                    double d2 = d * d;
                    map2.put(N, map2.get(N) + 1.0);
                    map2.put(SUM, map2.get(SUM) + d);
                    map2.put(SUM2, map2.get(SUM2) + d2);
                    map2.put(SUM3, map2.get(SUM3) + d2 * d);
                    map2.put(SUM4, map2.get(SUM4) + d2 * d2);
                }
            } else if (MEAN.equals(string) && !map.containsKey(MEAN) || MEAN_DEVIATION.equals(string) && !map.containsKey(MEAN_DEVIATION) || VARIANCE.equals(string) && !map.containsKey(VARIANCE) || SKEWNESS.equals(string) && !map.containsKey(SKEWNESS) || KURTOSIS.equals(string) && !map.containsKey(KURTOSIS)) {
                Map<String, Double> map3 = map;
                map2 = object;
                object4 = this;
                double d3 = ((Statistics)object4).a((Iterable<Number>)((Object)map2), map3, SUM) / super.a((Iterable<Number>)((Object)map2), map3, N);
                map3.put(MEAN, d3);
                d = d3 * d3;
                map3.put(MEAN_DEVIATION, 0.0);
                map3.put(VARIANCE, map3.get(SUM2) - d3 * map3.get(SUM));
                map3.put(SKEWNESS, map3.get(SUM3) - d3 * 3.0 * map3.get(SUM2) + d * 2.0 * map3.get(SUM));
                map3.put(KURTOSIS, map3.get(SUM4) - d3 * 4.0 * map3.get(SUM3) + d * 6.0 * map3.get(SUM2) - d * 3.0 * d3 * map3.get(SUM));
            }
            if ("quantile50".equals(string) && !map.containsKey("quantile50") || QUARTILE_1.equals(string) && !map.containsKey(QUARTILE_1) || "quantile50".equals(string) && !map.containsKey("quantile50") || QUARTILE_3.equals(string) && !map.containsKey(QUARTILE_3)) {
                map2 = map;
                object4 = object;
                object3 = new SortedList();
                object2 = object4.iterator();
                while (object2.hasNext()) {
                    double d4 = ((Number)object2.next()).doubleValue();
                    if (Double.isNaN(d4)) continue;
                    object3.add(d4);
                }
                map2.put(QUARTILE_1, MathUtils.quantile((List<Double>)object3, 0.25));
                map2.put("quantile50", MathUtils.quantile((List<Double>)object3, 0.5));
                map2.put(QUARTILE_3, MathUtils.quantile((List<Double>)object3, 0.75));
                map2.put("quantile50", map2.get("quantile50"));
            }
        }
        if ((object = map.get(string)) != null) {
            return (Double)object;
        }
        return Double.NaN;
    }

    @Override
    public void dataAdded(DataSource dataChangeEventArray, DataChangeEvent ... dataChangeEventArray2) {
        dataChangeEventArray = dataChangeEventArray2;
        int n = dataChangeEventArray2.length;
        for (int i = 0; i < n; ++i) {
            DataChangeEvent dataChangeEvent = dataChangeEventArray[i];
            int n2 = dataChangeEvent.getCol();
            int n3 = dataChangeEvent.getRow();
            if (n2 >= this.c.size()) {
                this.c.add(new HashMap());
            }
            if (n3 >= this.d.size()) {
                this.d.add(new HashMap());
            }
            this.invalidate(n2, n3);
        }
    }

    @Override
    public void dataUpdated(DataSource dataChangeEventArray, DataChangeEvent ... dataChangeEventArray2) {
        dataChangeEventArray = dataChangeEventArray2;
        int n = dataChangeEventArray2.length;
        for (int i = 0; i < n; ++i) {
            DataChangeEvent dataChangeEvent = dataChangeEventArray[i];
            this.invalidate(dataChangeEvent.getCol(), dataChangeEvent.getRow());
        }
    }

    @Override
    public void dataRemoved(DataSource dataChangeEventArray, DataChangeEvent ... dataChangeEventArray2) {
        dataChangeEventArray = dataChangeEventArray2;
        int n = dataChangeEventArray2.length;
        for (int i = 0; i < n; ++i) {
            DataChangeEvent dataChangeEvent = dataChangeEventArray[i];
            this.invalidate(dataChangeEvent.getCol(), dataChangeEvent.getRow());
        }
    }

    protected void invalidate(int n, int n2) {
        this.b.clear();
        this.c.get(n).clear();
        this.d.get(n2).clear();
    }
}

