/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.data.filters;

import de.erichseifert.gral.data.AbstractDataSource;
import de.erichseifert.gral.data.DataChangeEvent;
import de.erichseifert.gral.data.DataListener;
import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.util.MathUtils;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class Filter
extends AbstractDataSource
implements DataListener {
    protected final DataSource original;
    private final int[] a;
    private final ArrayList<Double[]> b;
    private Mode c;

    public Filter(DataSource dataSource, Mode mode, int ... nArray) {
        super(new Class[0]);
        this.b = new ArrayList(dataSource.getRowCount());
        this.original = dataSource;
        this.c = mode;
        this.a = Arrays.copyOf(nArray, nArray.length);
        Arrays.sort(this.a);
        this.original.addDataListener(this);
        this.dataUpdated(this.original, new DataChangeEvent[0]);
    }

    protected Number getOriginal(int n, int n2) {
        int n3 = this.original.getRowCount() - 1;
        if (n2 < 0 || n2 > n3) {
            if (Mode.OMIT.equals((Object)this.c)) {
                return Double.NaN;
            }
            if (Mode.ZERO.equals((Object)this.c)) {
                return 0.0;
            }
            if (Mode.REPEAT.equals((Object)this.c)) {
                n2 = MathUtils.limit(n2, 0, n3);
            } else if (Mode.MIRROR.equals((Object)this.c)) {
                int n4 = Math.abs(n2) / n3;
                n2 = Math.abs(n2) % n3;
                if ((n4 & 1) != 0) {
                    n2 = n3 - n2;
                }
            } else if (Mode.CIRCULAR.equals((Object)this.c)) {
                n2 = n2 >= 0 ? (n2 %= n3 + 1) : (n2 + 1) % (n3 + 1) + n3;
            }
        }
        return this.original.get(n, n2);
    }

    protected void clear() {
        this.b.clear();
    }

    protected void add(Double[] doubleArray) {
        this.b.add(doubleArray);
    }

    protected void add(Number[] numberArray) {
        Double[] doubleArray = new Double[numberArray.length];
        int n = 0;
        for (Number number : numberArray) {
            doubleArray[n++] = number.doubleValue();
        }
        this.b.add(doubleArray);
    }

    public Number get(int n, int n2) {
        int n3 = this.getIndex(n);
        if (n3 < 0) {
            return this.original.get(n, n2);
        }
        return this.b.get(n2)[n3];
    }

    protected Number set(int n, int n2, double d) {
        int n3 = this.getIndex(n);
        if (n3 < 0) {
            throw new IllegalArgumentException("Can't set value in unfiltered column.");
        }
        Double d2 = this.b.get(n2)[n3];
        this.b.get((int)n2)[n3] = d;
        this.notifyDataUpdated(new DataChangeEvent(this, n, n2, d2, d));
        return d2;
    }

    public int getColumnCount() {
        return this.original.getColumnCount();
    }

    protected int getColumnCountFiltered() {
        if (this.a.length == 0) {
            return this.original.getColumnCount();
        }
        return this.a.length;
    }

    public int getRowCount() {
        return this.original.getRowCount();
    }

    protected int getRowCountFiltered() {
        return this.original.getRowCount();
    }

    public void dataAdded(DataSource dataSource, DataChangeEvent ... dataChangeEventArray) {
        this.filter();
        this.notifyDataUpdated(dataChangeEventArray);
    }

    public void dataUpdated(DataSource dataSource, DataChangeEvent ... dataChangeEventArray) {
        this.filter();
        this.notifyDataUpdated(dataChangeEventArray);
    }

    public void dataRemoved(DataSource dataSource, DataChangeEvent ... dataChangeEventArray) {
        this.filter();
        this.notifyDataUpdated(dataChangeEventArray);
    }

    protected int getIndexOriginal(int n) {
        if (this.a.length == 0) {
            return n;
        }
        return this.a[n];
    }

    protected int getIndex(int n) {
        if (this.a.length == 0) {
            return n;
        }
        return Arrays.binarySearch(this.a, n);
    }

    protected boolean isFiltered(int n) {
        return this.getIndex(n) >= 0;
    }

    protected abstract void filter();

    public Mode getMode() {
        return this.c;
    }

    public void setMode(Mode mode) {
        this.c = mode;
        this.dataUpdated(this, new DataChangeEvent[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        OMIT,
        ZERO,
        REPEAT,
        MIRROR,
        CIRCULAR;

    }
}

