/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.data.filters;

import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.filters.Filter;
import de.erichseifert.gral.data.filters.Kernel;

public class Convolution
extends Filter {
    private final Kernel a;

    public Convolution(DataSource dataSource, Kernel kernel, Filter.Mode mode, int ... nArray) {
        super(dataSource, mode, nArray);
        this.a = kernel;
        this.filter();
    }

    public Kernel getKernel() {
        return this.a;
    }

    protected void filter() {
        this.clear();
        for (int i = 0; i < this.getRowCount(); ++i) {
            Double[] doubleArray = new Double[this.getColumnCountFiltered()];
            for (int j = 0; j < doubleArray.length; ++j) {
                double d;
                block6: {
                    int n = this.getIndexOriginal(j);
                    int n2 = i;
                    int n3 = n;
                    Convolution convolution = this;
                    if (convolution.a == null) {
                        Number number = convolution.getOriginal(n3, n2);
                        d = number != null ? number.doubleValue() : Double.NaN;
                    } else {
                        double d2 = 0.0;
                        for (int k = convolution.a.getMinIndex(); k <= convolution.a.getMaxIndex(); ++k) {
                            int n4 = n2 + k;
                            Number number = convolution.getOriginal(n3, n4);
                            double d3 = number != null ? number.doubleValue() : Double.NaN;
                            if (Double.isNaN(d3) || Double.isInfinite(d3)) {
                                d = d3;
                                break block6;
                            }
                            d2 += convolution.a.get(k) * d3;
                        }
                        d = d2;
                    }
                }
                doubleArray[j] = d;
            }
            this.add(doubleArray);
        }
    }
}

