/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.data;

import de.erichseifert.gral.data.AbstractDataSource;
import de.erichseifert.gral.data.DataAccessor;
import de.erichseifert.gral.data.DataChangeEvent;
import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.Row;
import de.erichseifert.gral.data.comparators.DataComparator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTable
extends AbstractDataSource {
    private final List<Number[]> a = new ArrayList<Number[]>();
    private int b;

    public DataTable(Class<? extends Number> ... classArray) {
        super(classArray);
    }

    public DataTable(int n, Class<? extends Number> clazz) {
        this(new Class[0]);
        Object[] objectArray = new Class[n];
        Arrays.fill(objectArray, clazz);
        this.setColumnTypes((Class[])objectArray);
    }

    public DataTable(DataSource dataSource) {
        this(dataSource.getColumnTypes());
        for (int i = 0; i < dataSource.getRowCount(); ++i) {
            this.add(dataSource.getRow(i));
        }
    }

    public void add(Number ... numberArray) {
        this.add(Arrays.asList(numberArray));
    }

    public void add(Collection<? extends Number> object) {
        if (object.size() != this.getColumnCount()) {
            throw new IllegalArgumentException(MessageFormat.format("Wrong number of columns! Expected {0,number,integer}, got {1,number,integer}.", this.getColumnCount(), object.size()));
        }
        int n = 0;
        Number[] numberArray = new Number[object.size()];
        DataChangeEvent[] dataChangeEventArray = new DataChangeEvent[numberArray.length];
        Class<? extends Number>[] classArray = this.getColumnTypes();
        object = object.iterator();
        while (object.hasNext()) {
            Number number = (Number)object.next();
            if (number != null && !classArray[n].isAssignableFrom(number.getClass())) {
                throw new IllegalArgumentException(MessageFormat.format("Wrong column type! Expected {0}, got {1}.", classArray[n], number.getClass()));
            }
            numberArray[n] = number;
            dataChangeEventArray[n] = new DataChangeEvent(this, n, this.b, null, number);
            ++n;
        }
        this.a.add(numberArray);
        ++this.b;
        this.notifyDataAdded(dataChangeEventArray);
    }

    public void add(Row object) {
        ArrayList<Number> arrayList = new ArrayList<Number>(((Row)object).size());
        object = ((DataAccessor)object).iterator();
        while (object.hasNext()) {
            Number number = (Number)object.next();
            arrayList.add(number);
        }
        this.add(arrayList);
    }

    public void remove(int n) {
        Row row = new Row(this, n);
        DataChangeEvent[] dataChangeEventArray = new DataChangeEvent[this.getColumnCount()];
        for (int i = 0; i < dataChangeEventArray.length; ++i) {
            dataChangeEventArray[i] = new DataChangeEvent(this, i, n, row.get(i), null);
        }
        this.a.remove(n);
        --this.b;
        this.notifyDataRemoved(dataChangeEventArray);
    }

    public void clear() {
        this.a.clear();
        this.b = 0;
        this.notifyDataRemoved(new DataChangeEvent[0]);
    }

    @Override
    public Number get(int n, int n2) {
        return this.a.get(n2)[n];
    }

    public Number set(int n, int n2, Number number) {
        Number number2 = this.get(n, n2);
        if (!number2.equals(number)) {
            this.a.get((int)n2)[n] = number;
            this.notifyDataUpdated(new DataChangeEvent(this, n, n2, number2, number));
        }
        return number2;
    }

    @Override
    public int getRowCount() {
        return this.b;
    }

    public void sort(DataComparator ... dataComparatorArray) {
        Collections.sort(this.a, new Comparator<Number[]>(dataComparatorArray){
            private /* synthetic */ DataComparator[] a;
            {
                this.a = dataComparatorArray;
            }
        });
    }
}

