/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.data;

import de.erichseifert.gral.data.DataSource;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataAccessor
implements Iterable<Number> {
    private final DataSource a;
    private final int b;

    public DataAccessor(DataSource dataSource, int n) {
        this.a = dataSource;
        this.b = n;
    }

    public DataSource getSource() {
        return this.a;
    }

    public int getIndex() {
        return this.b;
    }

    public abstract Number get(int var1);

    public abstract int size();

    public boolean equals(Object object) {
        if (!(object instanceof DataAccessor)) {
            return false;
        }
        object = (DataAccessor)object;
        int n = this.size();
        if (((DataAccessor)object).size() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (((DataAccessor)object).get(i).equals(this.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.a.hashCode() ^ this.b;
    }

    public String toString() {
        return String.format(Locale.US, "%s[source=%s,index=%d]", this.getClass().getName(), this.getSource(), this.getIndex());
    }

    public Number[] toArray(Number[] numberArray) {
        if (numberArray == null) {
            numberArray = new Number[this.size()];
        }
        if (numberArray.length != this.size()) {
            throw new IllegalArgumentException(MessageFormat.format("Array of size {0,number,integer} does not match {1,number,integer} elements.", numberArray.length, this.size()));
        }
        for (int i = 0; i < numberArray.length; ++i) {
            numberArray[i] = this.get(i);
        }
        return numberArray;
    }

    public abstract double getStatistics(String var1);

    @Override
    public Iterator<Number> iterator() {
        return new Iterator<Number>(this){
            private int a;
            private /* synthetic */ DataAccessor b;
            {
                this.b = dataAccessor;
            }

            @Override
            public final boolean hasNext() {
                return this.a < this.b.size();
            }

            @Override
            public final void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

