/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral;

import de.erichseifert.gral.AbstractDrawable;
import de.erichseifert.gral.DrawingContext;
import de.erichseifert.gral.util.GraphicsUtils;
import de.erichseifert.gral.util.Insets2D;
import de.erichseifert.gral.util.SettingChangeEvent;
import de.erichseifert.gral.util.SettingsListener;
import de.erichseifert.gral.util.SettingsStorage;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;

public abstract class PlotArea
extends AbstractDrawable
implements SettingsListener {
    public static final SettingsStorage.Key BACKGROUND = new SettingsStorage.Key("plotarea.background");
    public static final SettingsStorage.Key BORDER = new SettingsStorage.Key("plotarea.border");
    public static final SettingsStorage.Key COLOR = new SettingsStorage.Key("plotarea.color");
    public static final SettingsStorage.Key CLIPPING = new SettingsStorage.Key("plotarea.clipping");

    public PlotArea() {
        this.addSettingsListener(this);
        this.setSettingDefault(BACKGROUND, Color.WHITE);
        this.setSettingDefault(BORDER, new BasicStroke(1.0f));
        this.setSettingDefault(COLOR, Color.BLACK);
        this.setSettingDefault(CLIPPING, new Insets2D.Double(0.0));
    }

    protected void drawBackground(DrawingContext drawingContext) {
        Paint paint = (Paint)this.getSetting(BACKGROUND);
        if (paint != null) {
            GraphicsUtils.fillPaintedShape(drawingContext.getGraphics(), this.getBounds(), paint, null);
        }
    }

    protected void drawBorder(DrawingContext drawingContext) {
        Stroke stroke = (Stroke)this.getSetting(BORDER);
        if (stroke != null) {
            Paint paint = (Paint)this.getSetting(COLOR);
            GraphicsUtils.drawPaintedShape(drawingContext.getGraphics(), this.getBounds(), paint, null, stroke);
        }
    }

    protected abstract void drawPlot(DrawingContext var1);

    public void settingChanged(SettingChangeEvent settingChangeEvent) {
    }
}

