/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral;

import de.erichseifert.gral.AbstractDrawable;
import de.erichseifert.gral.Drawable;
import de.erichseifert.gral.DrawableContainer;
import de.erichseifert.gral.DrawingContext;
import de.erichseifert.gral.EdgeLayout;
import de.erichseifert.gral.Layout;
import de.erichseifert.gral.Location;
import de.erichseifert.gral.StackedLayout;
import de.erichseifert.gral.data.DataChangeEvent;
import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.plots.Label;
import de.erichseifert.gral.util.Dimension2D;
import de.erichseifert.gral.util.GraphicsUtils;
import de.erichseifert.gral.util.Insets2D;
import de.erichseifert.gral.util.Orientation;
import de.erichseifert.gral.util.SettingChangeEvent;
import de.erichseifert.gral.util.SettingsListener;
import de.erichseifert.gral.util.SettingsStorage;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.util.HashMap;
import java.util.Map;

public abstract class Legend
extends DrawableContainer
implements SettingsListener {
    public static final SettingsStorage.Key BACKGROUND = new SettingsStorage.Key("legend.background");
    public static final SettingsStorage.Key BORDER = new SettingsStorage.Key("legend.border");
    public static final SettingsStorage.Key FONT = new SettingsStorage.Key("legend.font");
    public static final SettingsStorage.Key COLOR = new SettingsStorage.Key("legend.color");
    public static final SettingsStorage.Key ORIENTATION = new SettingsStorage.Key("legend.orientation");
    public static final SettingsStorage.Key GAP = new SettingsStorage.Key("legend.gap");
    public static final SettingsStorage.Key SYMBOL_SIZE = new SettingsStorage.Key("legend.symbol.size");
    private final Map<DataSource, Drawable> a = new HashMap<DataSource, Drawable>();

    public Legend() {
        this.setInsets(new Insets2D.Double(10.0));
        this.addSettingsListener(this);
        this.setSettingDefault(BACKGROUND, Color.WHITE);
        this.setSettingDefault(BORDER, new BasicStroke(1.0f));
        this.setSettingDefault(FONT, Font.decode(null));
        this.setSettingDefault(COLOR, Color.BLACK);
        this.setSettingDefault(ORIENTATION, Orientation.VERTICAL);
        this.setSettingDefault(GAP, new Dimension2D.Double(20.0, 5.0));
        this.setSettingDefault(SYMBOL_SIZE, new Dimension2D.Double(2.0, 2.0));
    }

    public void draw(DrawingContext drawingContext) {
        this.drawBackground(drawingContext);
        this.drawBorder(drawingContext);
        this.drawComponents(drawingContext);
    }

    protected void drawBackground(DrawingContext drawingContext) {
        Paint paint = (Paint)this.getSetting(BACKGROUND);
        if (paint != null) {
            GraphicsUtils.fillPaintedShape(drawingContext.getGraphics(), this.getBounds(), paint, null);
        }
    }

    protected void drawBorder(DrawingContext drawingContext) {
        Stroke stroke = (Stroke)this.getSetting(BORDER);
        if (stroke != null) {
            Paint paint = (Paint)this.getSetting(COLOR);
            GraphicsUtils.drawPaintedShape(drawingContext.getGraphics(), this.getBounds(), paint, null, stroke);
        }
    }

    protected abstract void drawSymbol(DrawingContext var1, Drawable var2, DataSource var3);

    public void add(DataSource dataSource) {
        Item item = new Item(dataSource, dataSource.toString());
        this.add(item);
        this.a.put(dataSource, item);
    }

    public boolean contains(DataSource dataSource) {
        return this.a.containsKey(dataSource);
    }

    public void remove(DataSource dataSource) {
        Drawable drawable = this.a.get(dataSource);
        if (drawable != null) {
            this.remove(drawable);
        }
        this.a.remove(dataSource);
    }

    public void clear() {
        for (DataSource dataSource : this.a.keySet()) {
            this.remove(dataSource);
        }
    }

    protected void notifyDataChanged(DataChangeEvent ... dataChangeEventArray) {
        this.layout();
    }

    public void settingChanged(SettingChangeEvent object) {
        if (ORIENTATION.equals(object = ((SettingChangeEvent)object).getKey()) || GAP.equals(object)) {
            object = (Orientation)((Object)this.getSetting(ORIENTATION));
            Dimension2D dimension2D = (Dimension2D)this.getSetting(GAP);
            object = new StackedLayout((Orientation)((Object)object), dimension2D);
            this.setLayout((Layout)object);
            return;
        }
        if (FONT.equals(object)) {
            for (Drawable drawable : this.a.values()) {
                if (!(drawable instanceof Item)) continue;
                ((Item)drawable).d.setSetting(Label.FONT, this.getSetting(FONT));
            }
        }
    }

    protected class Item
    extends DrawableContainer {
        private final DataSource b;
        private final Drawable c;
        private final Label d;

        public Item(DataSource dataSource, String string) {
            super(new EdgeLayout(10.0, 0.0));
            this.b = dataSource;
            this.c = new AbstractDrawable(this){
                private /* synthetic */ Item a;
                {
                    this.a = item;
                }

                public final void draw(DrawingContext drawingContext) {
                    this.a.Legend.this.drawSymbol(drawingContext, this, this.a.b);
                }

                public final Dimension2D getPreferredSize() {
                    double d = ((Font)this.a.Legend.this.getSetting(FONT)).getSize2D();
                    Dimension2D dimension2D = (Dimension2D)this.a.Legend.this.getSetting(SYMBOL_SIZE);
                    Dimension2D dimension2D2 = super.getPreferredSize();
                    dimension2D2.setSize(dimension2D.getWidth() * d, dimension2D.getHeight() * d);
                    return dimension2D2;
                }
            };
            this.d = new Label(string);
            this.d.setSetting(Label.FONT, Legend.this.getSetting(FONT));
            this.d.setSetting(Label.ALIGNMENT_X, 0.0);
            this.d.setSetting(Label.ALIGNMENT_Y, 0.5);
            this.add(this.c, (Object)Location.WEST);
            this.add(this.d, (Object)Location.CENTER);
        }

        public Dimension2D getPreferredSize() {
            return this.getLayout().getPreferredSize(this);
        }

        public DataSource getData() {
            return this.b;
        }
    }
}

