/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.PhaseName;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauP_Time;
import edu.sc.seis.seisFile.sac.SacConstants;
import edu.sc.seis.seisFile.sac.SacHeader;
import edu.sc.seis.seisFile.sac.SacTimeSeries;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.List;

public class TauP_SetSac
extends TauP_Time {
    protected List<String> sacFileNames = new ArrayList<String>();
    protected boolean evdpkm = false;
    public static final int A_HEADER = 10;

    public boolean getEvdpkm() {
        return this.evdpkm;
    }

    public void setEvdpkm(boolean evdpkm) {
        this.evdpkm = evdpkm;
    }

    public void setSacFileNames(String[] sacFileNames) {
        this.sacFileNames = new ArrayList<String>();
        for (int i = 0; i < sacFileNames.length; ++i) {
            this.sacFileNames.add(sacFileNames[i]);
        }
    }

    protected TauP_SetSac() {
    }

    public TauP_SetSac(TauModel tMod) throws TauModelException {
        super(tMod);
    }

    public TauP_SetSac(String modelName) throws TauModelException {
        super(modelName);
    }

    protected void setSacVarNums() {
        int i;
        boolean[] headersUsed = new boolean[10];
        for (i = 0; i < headersUsed.length; ++i) {
            headersUsed[i] = false;
        }
        for (i = 0; i < this.phaseNames.size() && i < 10; ++i) {
            if (((PhaseName)this.phaseNames.get((int)i)).sacTNum == -1) continue;
            headersUsed[((PhaseName)this.phaseNames.get((int)i)).sacTNum] = true;
        }
        for (int i2 = 0; i2 < this.phaseNames.size(); ++i2) {
            int j;
            if (((PhaseName)this.phaseNames.get((int)i2)).sacTNum != -1) continue;
            for (j = 0; j < headersUsed.length && headersUsed[j]; ++j) {
            }
            if (j >= 10) continue;
            ((PhaseName)this.phaseNames.get((int)i2)).sacTNum = j;
            headersUsed[j] = true;
        }
    }

    @Override
    public void calculate(double degrees) {
        this.recalcPhases();
        this.calcTime(degrees);
    }

    @Override
    public void init() throws IOException {
        super.init();
        this.setSacVarNums();
    }

    @Override
    public void start() throws IOException, TauModelException {
        for (String filename : this.sacFileNames) {
            if (this.verbose) {
                System.out.println(filename);
            }
            this.processSacFile(new File(filename));
        }
    }

    public void processSacFile(File f) throws FileNotFoundException, IOException, TauModelException {
        double deg;
        if (f.isDirectory()) {
            File[] subfiles = f.listFiles();
            for (int j = 0; j < subfiles.length; ++j) {
                if (subfiles[j].getName().startsWith(".")) continue;
                this.processSacFile(subfiles[j]);
            }
            return;
        }
        SacTimeSeries sacFile = new SacTimeSeries(f);
        SacHeader header = sacFile.getHeader();
        if (SacConstants.isUndef((float)header.getEvdp())) {
            System.out.println("Depth not set in " + f.getName() + ", skipping");
            return;
        }
        if (SacConstants.isUndef((float)header.getO())) {
            System.out.println("O marker not set in " + f + ", skipping");
            return;
        }
        if (!SacConstants.isUndef((float)header.getGcarc())) {
            if (this.verbose) {
                System.out.println("Using gcarc: " + header.getGcarc());
            }
            deg = header.getGcarc();
        } else if (!SacConstants.isUndef((float)header.getDist())) {
            if (this.verbose) {
                System.out.println("Using dist: " + header.getDist());
            }
            deg = (double)header.getDist() / 6371.0 * 180.0 / Math.PI;
        } else if (!(SacConstants.isUndef((float)sacFile.getHeader().getStla()) || SacConstants.isUndef((float)sacFile.getHeader().getStlo()) || SacConstants.isUndef((float)sacFile.getHeader().getEvla()) || SacConstants.isUndef((float)sacFile.getHeader().getEvlo()))) {
            if (this.verbose) {
                System.out.println("Using stla,stlo, evla,evlo to calculate");
            }
            Alert.warning("Warning: Sac header gcarc is not set,", "using lat and lons to calculate distance.");
            Alert.warning("No ellipticity correction will be applied.", "This may introduce errors. Please see the manual.");
            deg = SphericalCoords.distance(header.getStla(), header.getStlo(), header.getEvla(), header.getEvlo());
        } else {
            Alert.warning("Can't get a distance, all distance fields are undef.", "skipping " + f);
            return;
        }
        if (!(this.evdpkm && this.depth == (double)header.getEvdp() || !this.evdpkm && this.depth == (double)(1000.0f * header.getEvdp()))) {
            if (!this.evdpkm && header.getEvdp() != 0.0f && (double)header.getEvdp() < 1000.0) {
                Alert.warning("Sac header evdp is < 1000 in " + f, "If the depth is in kilometers instead of meters (default), you should use the -evdpkm flag");
            }
            if (this.evdpkm) {
                this.depthCorrect(header.getEvdp());
            } else {
                this.depthCorrect((double)header.getEvdp() / 1000.0);
            }
        }
        if (this.verbose) {
            System.out.println(f + " searching for " + this.getPhaseNameString());
        }
        this.calculate(deg);
        if (this.verbose) {
            System.out.println(f + " " + this.arrivals.size() + " arrivals found.");
        }
        for (int arrivalNum = this.arrivals.size() - 1; arrivalNum >= 0; --arrivalNum) {
            int phaseNum = -1;
            for (int j = this.phaseNames.size() - 1; j >= 0; --j) {
                if (!this.getArrival(arrivalNum).getName().equals(((PhaseName)this.phaseNames.get((int)j)).name)) continue;
                phaseNum = j;
                break;
            }
            if (phaseNum == -1) continue;
            if (this.verbose) {
                System.out.println(f + " phase found " + this.getArrival(arrivalNum).getName() + " -> t" + ((PhaseName)this.phaseNames.get((int)phaseNum)).sacTNum + ", travel time=" + (float)this.getArrival(arrivalNum).getTime());
            }
            TauP_SetSac.setSacTHeader(sacFile, ((PhaseName)this.phaseNames.get((int)phaseNum)).sacTNum, this.getArrival(arrivalNum));
        }
        sacFile.write(f);
    }

    public static void setSacTHeader(SacTimeSeries sacFile, int headerNum, Arrival arrival) {
        float arrivalTime = sacFile.getHeader().getO() + (float)arrival.getTime();
        if (headerNum == 10) {
            sacFile.getHeader().setA(arrivalTime);
            sacFile.getHeader().setKa(arrival.getName());
        } else {
            sacFile.getHeader().setTHeader(headerNum, arrivalTime, arrival.getName());
            sacFile.getHeader().setUserHeader(headerNum, (float)arrival.getRayParam());
        }
    }

    @Override
    public void printStdUsage() {
        String className = this.getClass().getName();
        className = className.substring(className.lastIndexOf(46) + 1, className.length());
        System.out.println("Usage: " + className.toLowerCase() + " [arguments]");
        System.out.println("  or, for purists, java " + this.getClass().getName() + " [arguments]");
        System.out.println("\nArguments are:");
        System.out.println("-ph phase list     -- comma separated phase list,\n                      use phase-# to specify the sac header,\n                      for example, ScS-8 puts ScS in t8\n-pf phasefile      -- file containing phases\n\n-mod[el] modelname -- use velocity model \"modelname\" for calculations\n                      Default is iasp91.\n\n");
    }

    @Override
    public void printStdUsageTail() {
        System.out.println("\n-debug             -- enable debugging output\n-verbose           -- enable verbose output\n-version           -- print the version\n-help              -- print this out, but you already know that!\n");
    }

    @Override
    public void printUsage() {
        this.printStdUsage();
        System.out.println("-evdpkm            -- sac depth header is in km, default is meters\n");
        this.printStdUsageTail();
        System.out.println("sacfilename [sacfilename ...]");
        System.out.println("\nEx: taup_setsac -mod S_prem -ph S-8,ScS-9 wmq.r wmq.t wmq.z");
        System.out.println("puts the first S arrival in T8 and ScS in T9");
    }

    @Override
    public String[] parseCmdLineArgs(String[] args) throws IOException {
        int numNoComprendoArgs = 0;
        String[] leftOverArgs = super.parseCmdLineArgs(args);
        String[] noComprendoArgs = new String[leftOverArgs.length];
        for (int i = 0; i < leftOverArgs.length; ++i) {
            if (TauP_SetSac.dashEquals("evdpkm", leftOverArgs[i])) {
                this.evdpkm = true;
                continue;
            }
            if (TauP_SetSac.dashEquals("help", leftOverArgs[i])) {
                noComprendoArgs[numNoComprendoArgs++] = leftOverArgs[i];
                continue;
            }
            File tempFile = new File(leftOverArgs[i]);
            if (tempFile.exists() && tempFile.isFile() && tempFile.canRead()) {
                this.sacFileNames.add(leftOverArgs[i]);
                continue;
            }
            if (!tempFile.exists()) {
                System.err.println(leftOverArgs[i] + " does not exist. " + tempFile.getAbsolutePath());
            } else if (!tempFile.isFile()) {
                System.err.println(leftOverArgs[i] + " is not a file.");
            } else if (!tempFile.canRead()) {
                System.err.println(leftOverArgs[i] + " is not readable.");
            }
            noComprendoArgs[numNoComprendoArgs++] = leftOverArgs[i];
        }
        if (numNoComprendoArgs > 0) {
            String[] temp = new String[numNoComprendoArgs];
            System.arraycopy(noComprendoArgs, 0, temp, 0, numNoComprendoArgs);
            return temp;
        }
        return new String[0];
    }

    public static void main(String[] args) throws FileNotFoundException, IOException, StreamCorruptedException, ClassNotFoundException, OptionalDataException {
        TauP_SetSac tauPSetSac = new TauP_SetSac();
        if (args.length == 0) {
            tauPSetSac.printUsage();
            System.exit(1);
        } else {
            try {
                String[] noComprendoArgs = tauPSetSac.parseCmdLineArgs(args);
                TauP_SetSac.printNoComprendoArgs(noComprendoArgs);
                if (TauP_Time.DEBUG) {
                    System.out.println("Done reading " + tauPSetSac.modelName);
                }
                tauPSetSac.init();
                tauPSetSac.start();
            }
            catch (TauModelException e) {
                System.out.println("Caught TauModelException: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

