/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TauP_Pierce;
import edu.sc.seis.TauP.TauP_Time;
import edu.sc.seis.TauP.TimeDist;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OptionalDataException;
import java.io.PrintWriter;
import java.io.StreamCorruptedException;
import java.io.Writer;
import java.util.List;

public class TauP_Path
extends TauP_Pierce {
    protected String mapWidthUnit = "i";
    protected float mapWidth = 6.0f;
    protected boolean gmtScript = false;
    protected String psFile;
    protected static double maxPathInc = 1.0;

    protected TauP_Path() {
        this.outFile = null;
    }

    public TauP_Path(TauModel tMod) throws TauModelException {
        super(tMod);
        this.outFile = null;
    }

    public TauP_Path(String modelName) throws TauModelException {
        super(modelName);
        this.outFile = null;
    }

    public TauP_Path(TauModel tMod, String outFileBase) throws TauModelException {
        super(tMod);
        this.setOutFileBase(outFileBase);
    }

    public TauP_Path(String modelName, String outFileBase) throws TauModelException {
        super(modelName);
        this.setOutFileBase(outFileBase);
    }

    public void setOutFileBase(String outFileBase) {
        this.outFile = "stdout".equals(outFileBase) ? "stdout" : (outFileBase != null && outFileBase.length() != 0 ? outFileBase + ".gmt" : "taup_path.gmt");
    }

    public void setMapWidth(float mapWidth) {
        this.mapWidth = mapWidth;
    }

    public float getMapWidth() {
        return this.mapWidth;
    }

    public boolean isGmtScript() {
        return this.gmtScript;
    }

    public void setGmtScript(boolean gmtScript) {
        this.gmtScript = gmtScript;
    }

    public static double getMaxPathInc() {
        return maxPathInc;
    }

    public static void setMaxPathInc(double max) {
        maxPathInc = max;
    }

    @Override
    public void calculate(double degrees) throws TauModelException {
        this.depthCorrect(this.getSourceDepth());
        this.recalcPhases();
        this.clearArrivals();
        this.calcPath(degrees);
    }

    public void calcPath(double degrees) {
        this.degrees = degrees;
        for (int phaseNum = 0; phaseNum < this.phases.size(); ++phaseNum) {
            SeismicPhase phase = (SeismicPhase)this.phases.get(phaseNum);
            List<Arrival> phaseArrivals = phase.calcPath(degrees);
            for (Arrival arrival : phaseArrivals) {
                this.arrivals.add(arrival);
            }
        }
    }

    @Override
    public void printResult(PrintWriter out) throws IOException {
        if (this.gmtScript) {
            out.write("psxy -P -R -K -O -JP -m -A >> " + this.psFile + " <<END\n");
        }
        double radiusOfEarth = this.tModDepth.getRadiusOfEarth();
        for (int i = 0; i < this.arrivals.size(); ++i) {
            Arrival currArrival = (Arrival)this.arrivals.get(i);
            out.write(this.getCommentLine(currArrival));
            boolean longWayRound = false;
            if (currArrival.getDistDeg() % 360.0 > 180.0) {
                longWayRound = true;
            }
            double calcTime = 0.0;
            double calcDist = 0.0;
            TimeDist prevTimeDist = new TimeDist(0.0, 0.0, 0.0, 0.0);
            double calcDepth = currArrival.getSourceDepth();
            for (int j = 0; j < currArrival.path.length; ++j) {
                if (currArrival.path[j].getDistRadian() < prevTimeDist.getDistRadian()) {
                    throw new RuntimeException("ray path is backtracking, not possible: " + j + " (" + currArrival.path[j] + ") < (" + prevTimeDist + ")");
                }
                calcTime = currArrival.path[j].time;
                double prevDepth = calcDepth = currArrival.path[j].depth;
                calcDist = currArrival.path[j].getDistDeg();
                if (longWayRound && calcDist != 0.0) {
                    calcDist = -1.0 * calcDist;
                }
                out.write(Outputs.formatDistance(calcDist) + "  " + Outputs.formatDepth(radiusOfEarth - calcDepth));
                if (!this.gmtScript) {
                    this.printLatLon(out, calcDist);
                }
                out.write("\n");
                if (j < currArrival.path.length - 1 && currArrival.getRayParam() != 0.0 && currArrival.path[j + 1].getDistDeg() - currArrival.path[j].getDistDeg() > maxPathInc) {
                    int maxInterpNum = (int)Math.ceil((currArrival.path[j + 1].getDistDeg() - currArrival.path[j].getDistDeg()) / maxPathInc);
                    for (int interpNum = 1; interpNum < maxInterpNum; ++interpNum) {
                        calcTime += (currArrival.path[j + 1].time - currArrival.path[j].time) / (double)maxInterpNum;
                        calcDist = longWayRound ? (calcDist -= (currArrival.path[j + 1].getDistDeg() - currArrival.path[j].getDistDeg()) / (double)maxInterpNum) : (calcDist += (currArrival.path[j + 1].getDistDeg() - currArrival.path[j].getDistDeg()) / (double)maxInterpNum);
                        calcDepth = prevDepth + (double)interpNum * (currArrival.path[j + 1].depth - prevDepth) / (double)maxInterpNum;
                        out.write(Outputs.formatDistance(calcDist) + "  " + Outputs.formatDepth(radiusOfEarth - calcDepth));
                        if (!this.gmtScript) {
                            this.printLatLon(out, calcDist);
                        }
                        out.write("\n");
                    }
                }
                prevDepth = currArrival.path[j].depth;
            }
        }
        if (this.gmtScript) {
            out.write("END\n");
            out.write("psxy -P -R -O -JP -m -A >> " + this.psFile + " <<END\n");
            out.write("END\n");
        }
    }

    protected void printLatLon(Writer out, double calcDist) throws IOException {
        if (this.eventLat != Double.MAX_VALUE && this.eventLon != Double.MAX_VALUE && this.azimuth != Double.MAX_VALUE) {
            double lat = SphericalCoords.latFor(this.eventLat, this.eventLon, calcDist, this.azimuth);
            double lon = SphericalCoords.lonFor(this.eventLat, this.eventLon, calcDist, this.azimuth);
            out.write("  " + Outputs.formatLatLon(lat) + "  " + Outputs.formatLatLon(lon));
        } else if (this.stationLat != Double.MAX_VALUE && this.stationLon != Double.MAX_VALUE && this.backAzimuth != Double.MAX_VALUE) {
            double lat = SphericalCoords.latFor(this.stationLat, this.stationLon, this.degrees - calcDist, this.backAzimuth);
            double lon = SphericalCoords.lonFor(this.stationLat, this.stationLon, this.degrees - calcDist, this.backAzimuth);
            out.write("  " + Outputs.formatLatLon(lat) + "  " + Outputs.formatLatLon(lon));
        } else if (this.stationLat != Double.MAX_VALUE && this.stationLon != Double.MAX_VALUE && this.eventLat != Double.MAX_VALUE && this.eventLon != Double.MAX_VALUE) {
            this.azimuth = SphericalCoords.azimuth(this.eventLat, this.eventLon, this.stationLat, this.stationLon);
            this.backAzimuth = SphericalCoords.azimuth(this.stationLat, this.stationLon, this.eventLat, this.eventLon);
            double lat = SphericalCoords.latFor(this.eventLat, this.eventLon, calcDist, this.azimuth);
            double lon = SphericalCoords.lonFor(this.eventLat, this.eventLon, calcDist, this.azimuth);
            out.write("  " + Outputs.formatLatLon(lat) + "  " + Outputs.formatLatLon(lon));
        }
    }

    @Override
    public void printScriptBeginning(PrintWriter out) throws IOException {
        if (!this.gmtScript) {
            return;
        }
        if (this.outFile == null) {
            this.outFile = "taup_path.gmt";
            this.psFile = "taup_path.ps";
        } else {
            this.psFile = this.outFile.endsWith(".gmt") ? this.outFile.substring(0, this.outFile.length() - 4) + ".ps" : this.outFile + ".ps";
        }
        this.printScriptBeginning(out, this.psFile);
    }

    public void printScriptBeginning(PrintWriter out, String psFile) throws IOException {
        out.println("#!/bin/sh");
        out.println("#\n# This script will plot ray paths using GMT. If you want to\n#use this as a data file for psxy in another script, delete these\n# first lines, to the last psxy, as well as the last line.\n#");
        out.println("/bin/rm -f " + psFile);
        out.println("# draw surface and label distances.\npsbasemap -K -P -R0/360/0/" + this.getTauModel().getRadiusOfEarth() + " -JP" + this.mapWidth + this.mapWidthUnit + " -B30p/500N > " + psFile);
        out.println("# draw circles for branches, note these are scaled for a \n# map using -JP" + this.mapWidth + this.mapWidthUnit + "\n" + "psxy -K -O -P -R -JP -Sc -A >> " + psFile + " <<ENDLAYERS");
        out.println("0.0 0.0 " + this.mapWidth + this.mapWidthUnit);
        double[] branchDepths = this.tMod.getBranchDepths();
        for (int i = 0; i < branchDepths.length; ++i) {
            out.println("0.0 0.0 " + (float)((this.getTauModel().getRadiusOfEarth() - branchDepths[i]) * (double)this.mapWidth / this.getTauModel().getRadiusOfEarth()) + this.mapWidthUnit);
        }
        out.println("ENDLAYERS\n");
        out.println("# draw paths");
    }

    @Override
    public void printUsage() {
        this.printStdUsage();
        System.out.println("--gmt             -- outputs path as a complete GMT script.");
        System.out.println("--mapwidth        -- sets map width for GMT script.");
        this.printStdUsageTail();
    }

    @Override
    public String[] parseCmdLineArgs(String[] args) throws IOException {
        int numNoComprendoArgs = 0;
        String[] leftOverArgs = super.parseCmdLineArgs(args);
        String[] noComprendoArgs = new String[leftOverArgs.length];
        for (int i = 0; i < leftOverArgs.length; ++i) {
            if (TauP_Path.dashEquals("gmt", leftOverArgs[i])) {
                this.gmtScript = true;
                continue;
            }
            if (TauP_Path.dashEquals("mapwidth", leftOverArgs[i]) && i < leftOverArgs.length - 1) {
                this.setMapWidth(Float.parseFloat(leftOverArgs[i + 1]));
                ++i;
                continue;
            }
            noComprendoArgs[numNoComprendoArgs++] = TauP_Path.dashEquals("help", leftOverArgs[i]) ? leftOverArgs[i] : leftOverArgs[i];
        }
        if (numNoComprendoArgs > 0) {
            String[] temp = new String[numNoComprendoArgs];
            System.arraycopy(noComprendoArgs, 0, temp, 0, numNoComprendoArgs);
            return temp;
        }
        return new String[0];
    }

    @Override
    public void start() throws IOException, TauModelException, TauPException {
        super.start();
    }

    @Override
    public void destroy() throws IOException {
        super.destroy();
    }

    public static void main(String[] args) throws FileNotFoundException, IOException, StreamCorruptedException, ClassNotFoundException, OptionalDataException {
        try {
            TauP_Path tauPPath = new TauP_Path();
            tauPPath.setOutFileBase("taup_path");
            String[] noComprendoArgs = tauPPath.parseCmdLineArgs(args);
            TauP_Path.printNoComprendoArgs(noComprendoArgs);
            tauPPath.init();
            if (TauP_Time.DEBUG) {
                System.out.println("Done reading " + tauPPath.modelName);
            }
            tauPPath.start();
            tauPPath.destroy();
        }
        catch (TauModelException e) {
            System.out.println("Caught TauModelException: " + e.getMessage());
            e.printStackTrace();
        }
        catch (TauPException e) {
            System.out.println("Caught TauPException: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

