/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.PolarPlot;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauP_Time;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class TauPApplet
extends Applet
implements ActionListener,
ItemListener {
    Choice getModel;
    Choice toolChoice;
    TauP_Time tool;
    TauModel tMod;
    Panel inputPanel;
    TextField modelField;
    TextField depthField;
    TextField distanceField;
    TextField phasesField;
    TextArea textArea;
    PolarPlot plotArea;
    CardLayout outputCards;
    Panel outputPanel;
    Button calculate;
    Button textOrPlot;
    Button clearTextArea;
    String newline;
    String modelName;
    String phases = "";
    double distance;
    double depth;

    protected void resetInputPanel() {
        String modelName = this.getModel.getSelectedItem();
        this.inputPanel.removeAll();
        Label l = new Label("Model Name", 1);
        this.inputPanel.add(l);
        l = new Label("Source Depth", 1);
        this.inputPanel.add(l);
        l = new Label("Distance", 1);
        this.inputPanel.add(l);
        l = new Label("Phase List", 1);
        this.inputPanel.add(l);
        this.modelField = new TextField(modelName, 5);
        this.modelField.setEditable(false);
        this.inputPanel.add(this.modelField);
        this.depthField = new TextField("0.0", 5);
        this.inputPanel.add(this.depthField);
        this.distanceField = new TextField("10.0", 5);
        this.inputPanel.add(this.distanceField);
        this.phasesField = new TextField("P,S,PKP,SKS", 5);
        this.inputPanel.add(this.phasesField);
        this.inputPanel.validate();
    }

    @Override
    public void init() {
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = 0;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(4, 4, 5, 5);
        Panel choicePanel = new Panel();
        this.toolChoice = new Choice();
        this.toolChoice.addItem("TauP_Time");
        this.toolChoice.addItem("TauP_Pierce");
        this.toolChoice.addItem("TauP_Path");
        this.toolChoice.addItem("TauP_Curve");
        this.toolChoice.select(0);
        this.toolChoice.addItemListener(this);
        choicePanel.add(new Label("Tool"));
        choicePanel.add(this.toolChoice);
        this.getModel = new Choice();
        choicePanel.add(new Label("Choose model."));
        choicePanel.add(this.getModel);
        this.getModel.addItemListener(this);
        gridbag.setConstraints(choicePanel, constraints);
        this.add(choicePanel);
        this.inputPanel = new Panel();
        this.inputPanel.setLayout(new GridLayout(0, 4));
        constraints.weighty = 0.0;
        gridbag.setConstraints(this.inputPanel, constraints);
        this.add(this.inputPanel);
        this.resetInputPanel();
        this.calculate = new Button("Calculate");
        this.calculate.addActionListener(this);
        this.clearTextArea = new Button("Clear");
        this.clearTextArea.addActionListener(this);
        this.textOrPlot = new Button("Plot");
        this.textOrPlot.addActionListener(this);
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        this.add(this.clearTextArea);
        this.add(this.textOrPlot);
        constraints.gridwidth = 0;
        gridbag.setConstraints(this.calculate, constraints);
        this.add(this.calculate);
        this.outputPanel = new Panel();
        this.outputCards = new CardLayout();
        this.outputPanel.setLayout(this.outputCards);
        this.textArea = new TextArea();
        this.textArea.setEditable(false);
        this.outputPanel.add((Component)this.textArea, "Text");
        this.outputCards.first(this.outputPanel);
        Panel plotPanel = new Panel();
        plotPanel.setLayout(new BorderLayout());
        Panel buttonPanel = new Panel();
        buttonPanel.setLayout(new GridLayout(0, 1));
        Button fullButton = new Button("Full");
        fullButton.addActionListener(this);
        buttonPanel.add(fullButton);
        Button halfButton = new Button("Half");
        halfButton.addActionListener(this);
        buttonPanel.add(halfButton);
        Button quarterButton = new Button("Quarter");
        quarterButton.addActionListener(this);
        buttonPanel.add(quarterButton);
        plotPanel.add((Component)buttonPanel, "West");
        this.plotArea = new PolarPlot(plotPanel, 250);
        plotPanel.add(this.plotArea);
        this.outputPanel.add((Component)plotPanel, "Plot");
        constraints.weighty = 1.0;
        constraints.fill = 1;
        gridbag.setConstraints(this.outputPanel, constraints);
        this.add(this.outputPanel);
        this.findTauModel();
        if (this.getModel.getItemCount() > 0) {
            this.getModel.select(0);
            this.getModel.select("prem");
        }
        this.validate();
        this.newline = System.getProperty("line.separator");
    }

    public void loadTauModel(String modelName) throws IOException, InvalidClassException {
        try {
            InputStream modelStream = this.getClass().getResourceAsStream("/StdModels/" + modelName + ".taup");
            if (modelStream != null) {
                this.textArea.append("loading " + modelName + "...");
                this.tMod = TauModel.readModelFromStream(modelStream);
                this.modelName = modelName;
                this.modelField.setText(modelName);
                this.textArea.append("Got it.\n");
            } else {
                this.textArea.append("Couldn't find model, InputStream is null.\n");
            }
        }
        catch (ClassNotFoundException exptn) {
            System.out.println("itemStateChanged: caught ClassNotFoundException:" + exptn.getMessage());
        }
    }

    public void findTauModel() {
        try {
            if (this.getParameter("ARCHIVE") != null) {
                URL jarURL = new URL(this.getCodeBase() + this.getParameter("ARCHIVE"));
                ZipInputStream jarStream = new ZipInputStream(jarURL.openStream());
                ZipEntry jarEntry = jarStream.getNextEntry();
                while (jarEntry != null) {
                    if (jarEntry.getName().startsWith("StdModels") && jarEntry.getName().endsWith(".taup")) {
                        this.getModel.addItem(jarEntry.getName().substring(jarEntry.getName().lastIndexOf(47) + 1, jarEntry.getName().length() - 5));
                    }
                    this.textArea.append(jarEntry.getName() + "\n");
                    System.out.println("jar entry name is " + jarEntry.getName());
                    jarEntry = jarStream.getNextEntry();
                }
                jarStream.close();
                this.textArea.append("Got models from jar.\n");
            } else {
                InputStream manifestStream = this.getClass().getResourceAsStream("/StdModels/");
                if (manifestStream != null) {
                    StreamTokenizer manifest = new StreamTokenizer(manifestStream);
                    manifest.ordinaryChars(46, 46);
                    manifest.wordChars(46, 46);
                    manifest.ordinaryChars(48, 57);
                    manifest.wordChars(48, 57);
                    while (true) {
                        if (manifest.nextToken() == -1) break;
                        if (manifest.ttype != -3 || !manifest.sval.endsWith(".taup")) continue;
                        this.getModel.addItem(manifest.sval.substring(0, manifest.sval.length() - 5));
                    }
                    this.textArea.append("Got models from local directory.\n");
                } else {
                    this.textArea.append("Error: Couldn't find models.\n");
                }
                manifestStream.close();
            }
        }
        catch (IOException exptn) {
            System.out.println("findTauModel: caught IOException:" + exptn.getMessage() + "\ngetCodeBase=" + this.getCodeBase() + "\ngetParameter(archive)=" + this.getParameter("archive"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTool(String toolName, TauModel newTauModel) {
        try {
            this.textArea.append("tool change to " + this.toolChoice.getSelectedItem());
            Class<?> toolClass = Class.forName("edu.sc.seis.TauP." + toolName);
            if (this.tool == null || !this.tool.getClass().equals(toolClass)) {
                TauP_Time tempTool;
                Class[] argClasses = new Class[]{Class.forName("edu.sc.seis.TauP.TauModel")};
                Object[] argObjects = new Object[]{newTauModel};
                Constructor<?> toolConstructor = toolClass.getConstructor(argClasses);
                this.tool = tempTool = (TauP_Time)toolConstructor.newInstance(argObjects);
                this.tMod = newTauModel;
                this.textArea.append(" successful.");
            } else {
                this.textArea.append(" already done.");
            }
        }
        catch (ClassNotFoundException ex) {
            this.textArea.append(" failed. ClassNotFoundException:\n" + ex.getMessage());
            return;
        }
        catch (InstantiationException ex) {
            this.textArea.append(" failed. InstantiationException:\n" + ex.getMessage());
            return;
        }
        catch (IllegalAccessException ex) {
            this.textArea.append(" failed. IllegalAccessException:\n" + ex.getMessage());
            return;
        }
        catch (InvocationTargetException ex) {
            this.textArea.append(" failed. InvocationTargetException:\n" + ex.getTargetException().getMessage());
            ex.printStackTrace();
            ex.getTargetException().printStackTrace();
            return;
        }
        catch (NoSuchMethodException ex) {
            this.textArea.append(" failed. NoSuchMethodException:\n" + ex.getMessage());
            return;
        }
        finally {
            this.textArea.append("\n");
        }
    }

    public void makePlotActive() {
        this.outputCards.show(this.outputPanel, "Plot");
        this.textOrPlot.setLabel("Text");
    }

    public void makeTextActive() {
        this.outputCards.show(this.outputPanel, "Text");
        this.textOrPlot.setLabel("Plot");
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        try {
            if (event.getItemSelectable() == this.getModel) {
                this.loadTauModel(this.getModel.getSelectedItem());
                if (this.tool == null) {
                    this.loadTool(this.toolChoice.getSelectedItem(), this.tMod);
                } else {
                    this.tool.setTauModel(this.tMod);
                }
                this.phases = this.phasesField.getText();
                this.tool.parsePhaseList(this.phases);
                this.tool.depthCorrect(this.depth);
            } else if (event.getItemSelectable() == this.toolChoice) {
                if (this.tMod == null) {
                    this.loadTauModel(this.getModel.getSelectedItem());
                }
                this.loadTool(this.toolChoice.getSelectedItem(), this.tMod);
                this.phases = this.phasesField.getText();
                this.tool.parsePhaseList(this.phases);
                this.tool.depthCorrect(this.depth);
            }
        }
        catch (TauModelException e) {
            this.textArea.append("\n\ndepthCorrection failed, TauModelException: " + e.getMessage());
        }
        catch (IOException e) {
            this.textArea.append("\n\ndepthCorrection failed, IOException: " + e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        String target = e.getActionCommand();
        if (target == "Calculate") {
            try {
                if (this.tMod == null) {
                    this.loadTauModel(this.getModel.getSelectedItem());
                    if (this.tool != null) {
                        this.tool.setTauModel(this.tMod);
                        this.phases = this.phasesField.getText();
                        this.tool.parsePhaseList(this.phases);
                        this.tool.recalcPhases();
                    }
                }
                if (this.tool == null) {
                    this.loadTool(this.toolChoice.getSelectedItem(), this.tMod);
                    this.phases = this.phasesField.getText();
                    this.tool.parsePhaseList(this.phases);
                    this.tool.depthCorrect(this.depth);
                }
                if (this.phases != this.phasesField.getText()) {
                    this.phases = this.phasesField.getText();
                    this.tool.clearPhaseNames();
                    this.tool.parsePhaseList(this.phases);
                    this.tool.recalcPhases();
                }
                this.depth = Double.valueOf(this.depthField.getText());
                this.tool.depthCorrect(this.depth);
                this.distance = Double.valueOf(this.distanceField.getText());
                this.tool.calculate(this.distance);
                if (this.textOrPlot.getLabel().equals("Plot")) {
                    StringWriter result = new StringWriter();
                    this.tool.printResult(new PrintWriter(result));
                    this.textArea.append(result.toString());
                    this.textArea.append("Done!\n");
                    return;
                }
                if (this.tool.getClass().getName().equals("edu.sc.seis.TauP.TauP_Time")) {
                    this.outputCards.show(this.outputPanel, "Text");
                    this.textOrPlot.setLabel("Plot");
                    this.validate();
                    StringWriter result = new StringWriter();
                    this.tool.printResult(new PrintWriter(result));
                    this.textArea.append(result.toString());
                    this.textArea.append("Done!\n");
                    return;
                }
                if (this.tool.getClass().getName().equals("edu.sc.seis.TauP.TauP_Pierce")) {
                    double[] disconDepths = this.tool.getDisconDepths();
                    double[] disconRadius = new double[disconDepths.length];
                    for (int i = 0; i < disconDepths.length; ++i) {
                        disconRadius[i] = this.tool.getTauModel().getRadiusOfEarth() - disconDepths[i];
                    }
                    this.plotArea.setCircles(disconRadius);
                    List<Arrival> arrivals = this.tool.getArrivals();
                    this.plotArea.clearSegments();
                    for (Arrival arrival : arrivals) {
                        if (arrival.pierce == null) continue;
                        this.plotArea.appendSegment(arrival.pierce);
                    }
                    this.plotArea.repaint();
                    return;
                }
                if (this.tool.getClass().getName().equals("edu.sc.seis.TauP.TauP_Path")) {
                    double[] disconDepths = this.tool.getDisconDepths();
                    double[] disconRadius = new double[disconDepths.length];
                    for (int i = 0; i < disconDepths.length; ++i) {
                        disconRadius[i] = this.tool.getTauModel().getRadiusOfEarth() - disconDepths[i];
                    }
                    this.plotArea.setCircles(disconRadius);
                    List<Arrival> arrivals = this.tool.getArrivals();
                    this.plotArea.clearSegments();
                    for (Arrival arrival : arrivals) {
                        if (arrival.path == null) continue;
                        this.plotArea.appendSegment(arrival.path);
                    }
                    this.plotArea.repaint();
                    return;
                }
                if (!this.tool.getClass().getName().equals("edu.sc.seis.TauP.TauP_Curve")) return;
            }
            catch (TauModelException exptn) {
                System.out.println("actionPerformed: caught TauModelException:" + exptn.getMessage());
                exptn.printStackTrace();
                return;
            }
            catch (IOException exptn) {
                System.out.println("actionPerformed: caught IOException:" + exptn.getMessage());
                exptn.printStackTrace();
            }
            return;
        }
        if (target == "depthField") {
            try {
                this.depth = Double.valueOf(this.depthField.getText());
                this.tool.depthCorrect(this.depth);
                return;
            }
            catch (TauModelException exptn) {
                System.out.println("actionPerformed: caught TauModelException:" + exptn.getMessage());
                exptn.printStackTrace();
            }
            return;
        } else if (target == "Clear") {
            this.textArea.setText("");
            return;
        } else if (target == "Plot") {
            this.makePlotActive();
            return;
        } else if (target == "Text") {
            this.makeTextActive();
            return;
        } else if (target == "Full") {
            this.plotArea.setDisplayMode((short)0);
            return;
        } else if (target == "Half") {
            this.plotArea.setDisplayMode((short)1);
            return;
        } else {
            if (target != "Quarter") return;
            this.plotArea.setDisplayMode((short)2);
        }
        {
            // empty if block
        }
    }
}

