/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.CriticalDepth;
import edu.sc.seis.TauP.DepthRange;
import edu.sc.seis.TauP.NoSuchLayerException;
import edu.sc.seis.TauP.NoSuchMatPropException;
import edu.sc.seis.TauP.SlownessLayer;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.SphericalSModel;
import edu.sc.seis.TauP.SplitLayerInfo;
import edu.sc.seis.TauP.TimeDist;
import edu.sc.seis.TauP.VelocityLayer;
import edu.sc.seis.TauP.VelocityModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class SlownessModel
implements Serializable {
    public static transient boolean DEBUG = false;
    public static transient boolean verbose = false;
    protected double radiusOfEarth = 6371.0;
    protected VelocityModel vMod;
    protected List<CriticalDepth> criticalDepths = new ArrayList<CriticalDepth>();
    protected List<DepthRange> highSlownessLayerDepthsP = new ArrayList<DepthRange>();
    protected List<DepthRange> highSlownessLayerDepthsS = new ArrayList<DepthRange>();
    protected List<DepthRange> fluidLayerDepths = new ArrayList<DepthRange>();
    protected static int vectorLength = 256;
    protected List<SlownessLayer> PLayers = new ArrayList<SlownessLayer>(vectorLength);
    protected List<SlownessLayer> SLayers = new ArrayList<SlownessLayer>(vectorLength);
    protected double minDeltaP = 0.1;
    protected double maxDeltaP = 11.0;
    protected double maxDepthInterval = 115.0;
    protected double maxRangeInterval = 200.0 / this.radiusOfEarth;
    protected double maxInterpError = 0.5;
    protected boolean allowInnerCoreS = true;
    public static final double DEFAULT_SLOWNESS_TOLERANCE = 1.0E-16;
    protected double slownessTolerance = 1.0E-16;
    public static final boolean PWAVE = true;
    public static final boolean SWAVE = false;

    public SlownessModel(VelocityModel vMod, double minDeltaP, double maxDeltaP, double maxDepthInterval, double maxRangeInterval, double maxInterpError, boolean allowInnerCoreS, double slownessTolerance) throws NoSuchMatPropException, NoSuchLayerException, SlownessModelException {
        this.vMod = vMod;
        this.minDeltaP = minDeltaP;
        this.maxDeltaP = maxDeltaP;
        this.maxDepthInterval = maxDepthInterval;
        this.maxRangeInterval = maxRangeInterval;
        this.maxInterpError = maxInterpError;
        this.allowInnerCoreS = allowInnerCoreS;
        this.slownessTolerance = slownessTolerance;
        this.createSample();
    }

    public SlownessModel(double radiusOfEarth, VelocityModel vMod, List<CriticalDepth> criticalDepth, List<DepthRange> highSlownessLayerDepthsP, List<DepthRange> highSlownessLayerDepthsS, List<DepthRange> fluidLayerDepths, List<SlownessLayer> pLayers, List<SlownessLayer> sLayers, double minDeltaP, double maxDeltaP, double maxDepthInterval, double maxRangeInterval, double maxInterpError, boolean allowInnerCoreS, double slownessTolerance) {
        this.radiusOfEarth = radiusOfEarth;
        this.vMod = vMod;
        this.criticalDepths = criticalDepth;
        this.highSlownessLayerDepthsP = highSlownessLayerDepthsP;
        this.highSlownessLayerDepthsS = highSlownessLayerDepthsS;
        this.fluidLayerDepths = fluidLayerDepths;
        this.PLayers = pLayers;
        this.SLayers = sLayers;
        this.minDeltaP = minDeltaP;
        this.maxDeltaP = maxDeltaP;
        this.maxDepthInterval = maxDepthInterval;
        this.maxRangeInterval = maxRangeInterval;
        this.maxInterpError = maxInterpError;
        this.allowInnerCoreS = allowInnerCoreS;
        this.slownessTolerance = slownessTolerance;
    }

    public void setRadiusOfEarth(double radiusOfEarth) {
        this.radiusOfEarth = radiusOfEarth;
    }

    public void setMinDeltaP(double minDeltaP) {
        this.minDeltaP = minDeltaP;
    }

    public void setMaxDeltaP(double maxDeltaP) {
        this.maxDeltaP = maxDeltaP;
    }

    public void setMaxDepthInterval(double maxDepthInterval) {
        this.maxDepthInterval = maxDepthInterval;
    }

    public void setMaxRangeInterval(double maxRangeInterval) {
        this.maxRangeInterval = maxRangeInterval * Math.PI / 180.0;
    }

    public void setMaxInterpError(double maxInterpError) {
        this.maxInterpError = maxInterpError;
    }

    public void setAllowInnerCoreS(boolean allowInnerCoreS) {
        this.allowInnerCoreS = allowInnerCoreS;
    }

    public void setSlownessTolerance(double slownessTolerance) {
        this.slownessTolerance = slownessTolerance;
    }

    public VelocityModel getVelocityModel() {
        return this.vMod;
    }

    public final double getRadiusOfEarth() {
        return this.radiusOfEarth;
    }

    public final double getMinDeltaP() {
        return this.minDeltaP;
    }

    public final double getMaxDeltaP() {
        return this.maxDeltaP;
    }

    public final double getMaxDepthInterval() {
        return this.maxDepthInterval;
    }

    public final double getMaxRangeInterval() {
        return 180.0 * this.maxRangeInterval / Math.PI;
    }

    public final double getMaxInterpError() {
        return this.maxInterpError;
    }

    public final boolean isAllowInnerCoreS() {
        return this.allowInnerCoreS;
    }

    public final double getSlownessTolerance() {
        return this.slownessTolerance;
    }

    public final int getNumCriticalDepths() {
        return this.criticalDepths.size();
    }

    public final CriticalDepth getCriticalDepth(int i) {
        return this.criticalDepths.get(i);
    }

    public final int getNumLayers(boolean isPWave) {
        if (isPWave) {
            return this.PLayers.size();
        }
        return this.SLayers.size();
    }

    public double getMinTurnRayParam(double depth, boolean isPWave) throws NoSuchLayerException, SlownessModelException {
        double minPSoFar = Double.MAX_VALUE;
        List<SlownessLayer> layers = isPWave ? this.PLayers : this.SLayers;
        if (this.depthInHighSlowness(depth, Double.MAX_VALUE, isPWave)) {
            for (int i = 0; i < layers.size(); ++i) {
                SlownessLayer sLayer = this.getSlownessLayer(i, isPWave);
                if (sLayer.getBotDepth() == depth) {
                    minPSoFar = Math.min(minPSoFar, sLayer.getBotP());
                    return minPSoFar;
                }
                if (sLayer.getBotDepth() > depth) {
                    minPSoFar = Math.min(minPSoFar, sLayer.evaluateAt_bullen(depth, this.getRadiusOfEarth()));
                    return minPSoFar;
                }
                minPSoFar = Math.min(minPSoFar, sLayer.getBotP());
            }
        } else {
            SlownessLayer sLayer = this.getSlownessLayer(this.layerNumberAbove(depth, isPWave), isPWave);
            minPSoFar = depth == sLayer.getBotDepth() ? sLayer.getBotP() : sLayer.evaluateAt_bullen(depth, this.getRadiusOfEarth());
        }
        return minPSoFar;
    }

    public double getMinRayParam(double depth, boolean isPWave) throws NoSuchLayerException, SlownessModelException {
        double minPSoFar = this.getMinTurnRayParam(depth, isPWave);
        int i = this.layerNumberAbove(depth, isPWave);
        int j = this.layerNumberBelow(depth, isPWave);
        SlownessLayer sLayerAbove = this.getSlownessLayer(i, isPWave);
        SlownessLayer sLayerBelow = this.getSlownessLayer(j, isPWave);
        if (sLayerAbove.getBotDepth() == depth) {
            minPSoFar = Math.min(Math.min(minPSoFar, sLayerAbove.getBotP()), sLayerBelow.getTopP());
        }
        return minPSoFar;
    }

    public DepthRange[] getHighSlowness(boolean isPWave) {
        List<DepthRange> highSlownessLayerDepths = isPWave ? this.highSlownessLayerDepthsP : this.highSlownessLayerDepthsS;
        DepthRange[] hsz = new DepthRange[highSlownessLayerDepths.size()];
        for (int i = 0; i < highSlownessLayerDepths.size(); ++i) {
            hsz[i] = (DepthRange)highSlownessLayerDepths.get(i).clone();
        }
        return hsz;
    }

    protected SlownessLayer getSlownessLayer(int layerNum, boolean isPWave) {
        if (isPWave) {
            return this.PLayers.get(layerNum);
        }
        return this.SLayers.get(layerNum);
    }

    protected List<SlownessLayer> getAllSlownessLayers(boolean isPWave) {
        if (isPWave) {
            return this.PLayers;
        }
        return this.SLayers;
    }

    public abstract double toSlowness(double var1, double var3) throws SlownessModelException;

    public abstract double toVelocity(double var1, double var3) throws SlownessModelException;

    public abstract TimeDist layerTimeDist(double var1, int var3, boolean var4) throws SlownessModelException;

    public abstract SlownessLayer toSlownessLayer(VelocityLayer var1, boolean var2) throws SlownessModelException;

    public abstract double interpolate(double var1, double var3, double var5, double var7) throws SlownessModelException;

    public TimeDist approxDistance(int slownessTurnLayer, double p, boolean isPWave) throws NoSuchLayerException, SlownessModelException {
        if (slownessTurnLayer >= this.getNumLayers(isPWave)) {
            throw new SlownessModelException("Can't calculate a distance when slownessTurnLayer >= getNumLayers(" + isPWave + ")\n" + " slownessTurnLayer=" + slownessTurnLayer + " getNumLayers()=" + this.getNumLayers(isPWave));
        }
        if (p < 0.0) {
            throw new SlownessModelException("approxDistance: Ray parameter is negative!!!" + p + " slownessTurnLayer=" + slownessTurnLayer);
        }
        TimeDist td = new TimeDist(p);
        for (int layerNum = 0; layerNum <= slownessTurnLayer; ++layerNum) {
            td.add(this.layerTimeDist(p, layerNum, isPWave));
        }
        td.distRadian *= 2.0;
        td.time *= 2.0;
        return td;
    }

    public boolean depthInHighSlowness(double depth, double rayParam, boolean isPWave) {
        DepthRange highSZoneDepth = new DepthRange();
        return this.depthInHighSlowness(depth, rayParam, highSZoneDepth, isPWave);
    }

    public boolean depthInHighSlowness(double depth, double rayParam, DepthRange highSZoneDepth, boolean isPWave) {
        List<DepthRange> highSlownessLayerDepths = isPWave ? this.highSlownessLayerDepthsP : this.highSlownessLayerDepthsS;
        for (int i = 0; i < highSlownessLayerDepths.size(); ++i) {
            DepthRange tempRange = highSlownessLayerDepths.get(i);
            if (!(tempRange.topDepth <= depth) || !(depth <= tempRange.botDepth)) continue;
            highSZoneDepth.topDepth = tempRange.topDepth;
            highSZoneDepth.botDepth = tempRange.botDepth;
            highSZoneDepth.rayParam = tempRange.rayParam;
            if (!(rayParam > tempRange.rayParam) && (rayParam != tempRange.rayParam || depth != tempRange.topDepth)) continue;
            return true;
        }
        return false;
    }

    public boolean depthInFluid(double depth) {
        DepthRange fluidZoneDepth = new DepthRange();
        return this.depthInFluid(depth, fluidZoneDepth);
    }

    public boolean depthInFluid(double depth, DepthRange fluidZoneDepth) {
        for (int i = 0; i < this.fluidLayerDepths.size(); ++i) {
            DepthRange tempRange = this.fluidLayerDepths.get(i);
            if (!(tempRange.topDepth <= depth) || !(depth < tempRange.botDepth)) continue;
            fluidZoneDepth.topDepth = tempRange.topDepth;
            fluidZoneDepth.botDepth = tempRange.botDepth;
            return true;
        }
        return false;
    }

    public SplitLayerInfo splitLayer(double depth, boolean isPWave) throws SlownessModelException, NoSuchLayerException {
        List<SlownessLayer> outSLayers;
        List<SlownessLayer> outPLayers;
        int layerNum = this.layerNumberAbove(depth, isPWave);
        SlownessLayer sLayer = this.getSlownessLayer(layerNum, isPWave);
        if (sLayer.getTopDepth() == depth || sLayer.getBotDepth() == depth) {
            return new SplitLayerInfo(this, false, false, 0.0);
        }
        if (Math.abs(sLayer.getTopDepth() - depth) < 1.0E-6) {
            List<SlownessLayer> outSLayers2;
            List<SlownessLayer> outPLayers2;
            List<SlownessLayer> allLayers = this.getAllSlownessLayers(isPWave);
            ArrayList<SlownessLayer> outLayers = new ArrayList<SlownessLayer>(allLayers.size());
            outLayers.addAll(allLayers);
            outLayers.set(layerNum, new SlownessLayer(sLayer.getTopP(), depth, sLayer.getBotP(), sLayer.getBotDepth()));
            sLayer = this.getSlownessLayer(layerNum - 1, isPWave);
            outLayers.set(layerNum - 1, new SlownessLayer(sLayer.getTopP(), sLayer.getTopDepth(), sLayer.getBotP(), depth));
            if (isPWave) {
                outPLayers2 = outLayers;
                outSLayers2 = this.SLayers;
            } else {
                outPLayers2 = this.PLayers;
                outSLayers2 = outLayers;
            }
            SphericalSModel out = new SphericalSModel(this.radiusOfEarth, this.vMod, this.criticalDepths, this.highSlownessLayerDepthsP, this.highSlownessLayerDepthsS, this.fluidLayerDepths, outPLayers2, outSLayers2, this.minDeltaP, this.maxDeltaP, this.maxDepthInterval, this.maxRangeInterval, this.maxInterpError, this.allowInnerCoreS, this.slownessTolerance);
            return new SplitLayerInfo(out, false, true, sLayer.getBotP());
        }
        if (Math.abs(depth - sLayer.getBotDepth()) < 1.0E-6) {
            List<SlownessLayer> outSLayers3;
            List<SlownessLayer> outPLayers3;
            List<SlownessLayer> allLayers = this.getAllSlownessLayers(isPWave);
            ArrayList<SlownessLayer> outLayers = new ArrayList<SlownessLayer>(allLayers.size());
            outLayers.addAll(allLayers);
            outLayers.set(layerNum, new SlownessLayer(sLayer.getTopP(), sLayer.getTopDepth(), sLayer.getBotP(), depth));
            sLayer = this.getSlownessLayer(layerNum + 1, isPWave);
            outLayers.set(layerNum + 1, new SlownessLayer(sLayer.getTopP(), depth, sLayer.getBotP(), sLayer.getBotDepth()));
            if (isPWave) {
                outPLayers3 = outLayers;
                outSLayers3 = this.SLayers;
            } else {
                outPLayers3 = this.PLayers;
                outSLayers3 = outLayers;
            }
            SphericalSModel out = new SphericalSModel(this.radiusOfEarth, this.vMod, this.criticalDepths, this.highSlownessLayerDepthsP, this.highSlownessLayerDepthsS, this.fluidLayerDepths, outPLayers3, outSLayers3, this.minDeltaP, this.maxDeltaP, this.maxDepthInterval, this.maxRangeInterval, this.maxInterpError, this.allowInnerCoreS, this.slownessTolerance);
            return new SplitLayerInfo(out, false, true, sLayer.getBotP());
        }
        double p = sLayer.evaluateAt_bullen(depth, this.radiusOfEarth);
        SlownessLayer topLayer = new SlownessLayer(sLayer.getTopP(), sLayer.getTopDepth(), p, depth);
        SlownessLayer botLayer = new SlownessLayer(p, depth, sLayer.getBotP(), sLayer.getBotDepth());
        List<SlownessLayer> allLayers = this.getAllSlownessLayers(isPWave);
        ArrayList<SlownessLayer> outLayers = new ArrayList<SlownessLayer>(allLayers.size());
        outLayers.addAll(allLayers);
        outLayers.remove(layerNum);
        outLayers.add(layerNum, botLayer);
        outLayers.add(layerNum, topLayer);
        ArrayList<CriticalDepth> outCriticalDepths = new ArrayList<CriticalDepth>();
        outCriticalDepths.addAll(this.criticalDepths);
        this.fixCriticalDepths(outCriticalDepths, layerNum, isPWave);
        if (isPWave) {
            outPLayers = outLayers;
            outSLayers = this.fixOtherLayers(this.SLayers, p, sLayer, topLayer, botLayer, outCriticalDepths, !isPWave);
        } else {
            outPLayers = this.fixOtherLayers(this.PLayers, p, sLayer, topLayer, botLayer, outCriticalDepths, !isPWave);
            outSLayers = outLayers;
        }
        SphericalSModel out = new SphericalSModel(this.radiusOfEarth, this.vMod, outCriticalDepths, this.highSlownessLayerDepthsP, this.highSlownessLayerDepthsS, this.fluidLayerDepths, outPLayers, outSLayers, this.minDeltaP, this.maxDeltaP, this.maxDepthInterval, this.maxRangeInterval, this.maxInterpError, this.allowInnerCoreS, this.slownessTolerance);
        return new SplitLayerInfo(out, true, false, p);
    }

    private void fixCriticalDepths(List<CriticalDepth> criticalDepths, int layerNum, boolean isPWave) {
        for (int i = 0; i < criticalDepths.size(); ++i) {
            CriticalDepth cd = criticalDepths.get(i);
            if (cd.getLayerNum(isPWave) <= layerNum) continue;
            if (isPWave) {
                criticalDepths.set(i, new CriticalDepth(cd.getDepth(), cd.getVelLayerNum(), cd.getPLayerNum() + 1, cd.getSLayerNum()));
                continue;
            }
            criticalDepths.set(i, new CriticalDepth(cd.getDepth(), cd.getVelLayerNum(), cd.getPLayerNum(), cd.getSLayerNum() + 1));
        }
    }

    private List<SlownessLayer> fixOtherLayers(List<SlownessLayer> otherLayers, double p, SlownessLayer changedLayer, SlownessLayer newTopLayer, SlownessLayer newBotLayer, List<CriticalDepth> criticalDepths, boolean isPWave) throws SlownessModelException {
        ArrayList<SlownessLayer> out = new ArrayList<SlownessLayer>();
        out.addAll(otherLayers);
        int otherIndex = otherLayers.indexOf(changedLayer);
        if (otherIndex != -1) {
            out.remove(otherIndex);
            out.add(otherIndex, newBotLayer);
            out.add(otherIndex, newTopLayer);
        }
        for (int otherLayerNum = 0; otherLayerNum < out.size(); ++otherLayerNum) {
            SlownessLayer sLayer = (SlownessLayer)out.get(otherLayerNum);
            if (!((sLayer.getTopP() - p) * (p - sLayer.getBotP()) > 0.0)) continue;
            SlownessLayer topLayer = new SlownessLayer(sLayer.getTopP(), sLayer.getTopDepth(), p, sLayer.bullenDepthFor(p, this.radiusOfEarth));
            SlownessLayer botLayer = new SlownessLayer(p, topLayer.getBotDepth(), sLayer.getBotP(), sLayer.getBotDepth());
            out.remove(otherLayerNum);
            out.add(otherLayerNum, botLayer);
            out.add(otherLayerNum, topLayer);
            this.fixCriticalDepths(criticalDepths, otherLayerNum, !isPWave);
            ++otherLayerNum;
        }
        return out;
    }

    protected void findCriticalPoints() throws SlownessModelException {
        int layerNum;
        double minPSoFar = Double.MAX_VALUE;
        double minSSoFar = Double.MAX_VALUE;
        DepthRange highSlownessZoneP = new DepthRange();
        DepthRange highSlownessZoneS = new DepthRange();
        boolean inHighSlownessZoneP = false;
        boolean inHighSlownessZoneS = false;
        DepthRange fluidZone = new DepthRange();
        boolean inFluidZone = false;
        boolean belowOuterCore = false;
        this.highSlownessLayerDepthsP.clear();
        this.highSlownessLayerDepthsS.clear();
        this.criticalDepths.clear();
        this.fluidLayerDepths.clear();
        VelocityLayer currVLayer = this.vMod.getVelocityLayer(0);
        currVLayer = new VelocityLayer(0, currVLayer.getTopDepth(), currVLayer.getTopDepth(), currVLayer.getTopPVelocity(), currVLayer.getTopPVelocity(), currVLayer.getTopSVelocity(), currVLayer.getTopSVelocity(), currVLayer.getTopDensity(), currVLayer.getTopDensity(), currVLayer.getTopQp(), currVLayer.getTopQp(), currVLayer.getTopQs(), currVLayer.getTopQs());
        SlownessLayer currSLayer = this.toSlownessLayer(currVLayer, false);
        SlownessLayer currPLayer = this.toSlownessLayer(currVLayer, true);
        this.criticalDepths.add(new CriticalDepth(0.0, 0, 0, 0));
        if (!inFluidZone && currVLayer.getTopSVelocity() == 0.0) {
            inFluidZone = true;
            fluidZone = new DepthRange();
            fluidZone.topDepth = currVLayer.getTopDepth();
            currSLayer = currPLayer;
        }
        if (minSSoFar > currSLayer.getTopP()) {
            minSSoFar = currSLayer.getTopP();
        }
        if (minPSoFar > currPLayer.getTopP()) {
            minPSoFar = currPLayer.getTopP();
        }
        for (layerNum = 0; layerNum < this.vMod.getNumLayers(); ++layerNum) {
            VelocityLayer prevVLayer = currVLayer;
            SlownessLayer prevSLayer = currSLayer;
            SlownessLayer prevPLayer = currPLayer;
            currVLayer = this.vMod.getVelocityLayerClone(layerNum);
            if (!inFluidZone && currVLayer.getTopSVelocity() == 0.0) {
                inFluidZone = true;
                fluidZone = new DepthRange();
                fluidZone.topDepth = currVLayer.getTopDepth();
            }
            if (inFluidZone && currVLayer.getTopSVelocity() != 0.0) {
                if (prevVLayer.getBotDepth() > this.vMod.getIocbDepth()) {
                    belowOuterCore = true;
                }
                inFluidZone = false;
                fluidZone.botDepth = prevVLayer.getBotDepth();
                this.fluidLayerDepths.add(fluidZone);
            }
            currPLayer = this.toSlownessLayer(currVLayer, true);
            currSLayer = inFluidZone || belowOuterCore && !this.allowInnerCoreS ? currPLayer : this.toSlownessLayer(currVLayer, false);
            if (prevSLayer.getBotP() != currSLayer.getTopP() || prevPLayer.getBotP() != currPLayer.getTopP()) {
                this.criticalDepths.add(new CriticalDepth(currSLayer.getTopDepth(), layerNum, -1, -1));
                if (DEBUG) {
                    System.out.println("first order discontinuity, depth=" + currSLayer.getTopDepth());
                    System.out.println(prevSLayer + "\n" + currSLayer);
                    System.out.println(prevPLayer + "\n" + currPLayer);
                }
                if (inHighSlownessZoneS && currSLayer.getTopP() < minSSoFar) {
                    if (DEBUG) {
                        System.out.println("top of current layer is the bottom of a high slowness zone.");
                    }
                    highSlownessZoneS.botDepth = currSLayer.getTopDepth();
                    this.highSlownessLayerDepthsS.add(highSlownessZoneS);
                    inHighSlownessZoneS = false;
                }
                if (inHighSlownessZoneP && currPLayer.getTopP() < minPSoFar) {
                    if (DEBUG) {
                        System.out.println("top of current layer is the bottom of a high slowness zone.");
                    }
                    highSlownessZoneP.botDepth = currSLayer.getTopDepth();
                    this.highSlownessLayerDepthsP.add(highSlownessZoneP);
                    inHighSlownessZoneP = false;
                }
                if (minPSoFar > currPLayer.getTopP()) {
                    minPSoFar = currPLayer.getTopP();
                }
                if (minSSoFar > currSLayer.getTopP()) {
                    minSSoFar = currSLayer.getTopP();
                }
                if (!inHighSlownessZoneS && (prevSLayer.getBotP() < currSLayer.getTopP() || currSLayer.getTopP() < currSLayer.getBotP())) {
                    if (DEBUG) {
                        System.out.println("Found S high slowness at first order discontinuity, layer = " + layerNum);
                    }
                    inHighSlownessZoneS = true;
                    highSlownessZoneS = new DepthRange();
                    highSlownessZoneS.topDepth = currSLayer.getTopDepth();
                    highSlownessZoneS.rayParam = minSSoFar;
                }
                if (!inHighSlownessZoneP && (prevPLayer.getBotP() < currPLayer.getTopP() || currPLayer.getTopP() < currPLayer.getBotP())) {
                    if (DEBUG) {
                        System.out.println("Found P high slowness at first order discontinuity, layer = " + layerNum);
                    }
                    inHighSlownessZoneP = true;
                    highSlownessZoneP = new DepthRange();
                    highSlownessZoneP.topDepth = currPLayer.getTopDepth();
                    highSlownessZoneP.rayParam = minPSoFar;
                }
            } else if ((prevSLayer.getTopP() - prevSLayer.getBotP()) * (prevSLayer.getBotP() - currSLayer.getBotP()) < 0.0 || (prevPLayer.getTopP() - prevPLayer.getBotP()) * (prevPLayer.getBotP() - currPLayer.getBotP()) < 0.0) {
                this.criticalDepths.add(new CriticalDepth(currSLayer.getTopDepth(), layerNum, -1, -1));
                if (DEBUG) {
                    System.out.println("local slowness extrema, depth=" + currSLayer.getTopDepth());
                }
                if (!inHighSlownessZoneP && currPLayer.getTopP() < currPLayer.getBotP()) {
                    if (DEBUG) {
                        System.out.println("start of a P high slowness zone, local slowness extrema, minPSoFar=" + minPSoFar);
                    }
                    inHighSlownessZoneP = true;
                    highSlownessZoneP = new DepthRange();
                    highSlownessZoneP.topDepth = currPLayer.getTopDepth();
                    highSlownessZoneP.rayParam = minPSoFar;
                }
                if (!inHighSlownessZoneS && currSLayer.getTopP() < currSLayer.getBotP()) {
                    if (DEBUG) {
                        System.out.println("start of a S high slowness zone, local slowness extrema, minSSoFar=" + minSSoFar);
                    }
                    inHighSlownessZoneS = true;
                    highSlownessZoneS = new DepthRange();
                    highSlownessZoneS.topDepth = currSLayer.getTopDepth();
                    highSlownessZoneS.rayParam = minSSoFar;
                }
            }
            if (inHighSlownessZoneP && currPLayer.getBotP() < minPSoFar) {
                if (DEBUG) {
                    System.out.println("layer contains the bottom of a P high slowness zone. minPSoFar=" + minPSoFar + " " + currPLayer);
                }
                highSlownessZoneP.botDepth = this.findDepth(minPSoFar, layerNum, layerNum, true);
                this.highSlownessLayerDepthsP.add(highSlownessZoneP);
                inHighSlownessZoneP = false;
            }
            if (inHighSlownessZoneS && currSLayer.getBotP() < minSSoFar) {
                if (DEBUG) {
                    System.out.println("layer contains the bottom of a S high slowness zone. minSSoFar=" + minSSoFar + " " + currSLayer);
                }
                highSlownessZoneS.botDepth = this.findDepth(minSSoFar, layerNum, layerNum, currSLayer == currPLayer);
                this.highSlownessLayerDepthsS.add(highSlownessZoneS);
                inHighSlownessZoneS = false;
            }
            if (minPSoFar > currPLayer.getBotP()) {
                minPSoFar = currPLayer.getBotP();
            }
            if (minPSoFar > currPLayer.getTopP()) {
                minPSoFar = currPLayer.getTopP();
            }
            if (minSSoFar > currSLayer.getBotP()) {
                minSSoFar = currSLayer.getBotP();
            }
            if (minSSoFar > currSLayer.getTopP()) {
                minSSoFar = currSLayer.getTopP();
            }
            if (DEBUG && inHighSlownessZoneS) {
                System.out.println("In S high slowness zone, layerNum = " + layerNum + " minSSoFar=" + minSSoFar);
            }
            if (!DEBUG || !inHighSlownessZoneP) continue;
            System.out.println("In P high slowness zone, layerNum = " + layerNum + " minPSoFar=" + minPSoFar);
        }
        this.criticalDepths.add(new CriticalDepth(this.getRadiusOfEarth(), this.vMod.getNumLayers(), -1, -1));
        if (inHighSlownessZoneS) {
            highSlownessZoneS.botDepth = currVLayer.getBotDepth();
            this.highSlownessLayerDepthsS.add(highSlownessZoneS);
        }
        if (inHighSlownessZoneP) {
            highSlownessZoneP.botDepth = currVLayer.getBotDepth();
            this.highSlownessLayerDepthsP.add(highSlownessZoneP);
        }
        if (inFluidZone) {
            fluidZone.botDepth = currVLayer.getBotDepth();
            this.fluidLayerDepths.add(fluidZone);
        }
        if (DEBUG && this.criticalDepths.size() != 0) {
            String desc = "**** Critical Velocity Layers ************************\n";
            int botCriticalLayerNum = this.criticalDepths.get(0).getVelLayerNum() - 1;
            for (int criticalNum = 1; criticalNum < this.criticalDepths.size(); ++criticalNum) {
                int topCriticalLayerNum = botCriticalLayerNum + 1;
                botCriticalLayerNum = this.criticalDepths.get(criticalNum).getVelLayerNum() - 1;
                desc = desc + " " + topCriticalLayerNum + "," + botCriticalLayerNum;
            }
            System.out.println(desc);
        }
        if (DEBUG && this.highSlownessLayerDepthsP.size() != 0) {
            for (layerNum = 0; layerNum < this.highSlownessLayerDepthsP.size(); ++layerNum) {
                System.out.println(this.highSlownessLayerDepthsP.get(layerNum));
            }
        }
        if (DEBUG && this.highSlownessLayerDepthsS.size() != 0) {
            for (layerNum = 0; layerNum < this.highSlownessLayerDepthsS.size(); ++layerNum) {
                System.out.println(this.highSlownessLayerDepthsS.get(layerNum));
            }
        }
        if (!this.validate()) {
            throw new SlownessModelException("Validation Failed!");
        }
    }

    public double findDepth(double rayParam, boolean isPWave) throws SlownessModelException {
        return this.findDepth(rayParam, 0, this.vMod.getNumLayers() - 1, isPWave);
    }

    public double findDepth(double rayParam, double topDepth, double botDepth, boolean isPWave) throws SlownessModelException {
        try {
            int topLayerNum = this.vMod.layerNumberBelow(topDepth);
            if (this.vMod.getVelocityLayer(topLayerNum).getBotDepth() == topDepth) {
                ++topLayerNum;
            }
            int botLayerNum = this.vMod.layerNumberAbove(botDepth);
            return this.findDepth(rayParam, topLayerNum, botLayerNum, isPWave);
        }
        catch (NoSuchLayerException e) {
            throw new SlownessModelException(e.getMessage());
        }
    }

    public double findDepth(double p, int topCriticalLayer, int botCriticalLayer, boolean isPWave) throws SlownessModelException {
        VelocityLayer velLayer = null;
        double topP = Double.MAX_VALUE;
        double botP = Double.MAX_VALUE;
        char waveType = isPWave ? (char)'P' : 'S';
        try {
            if (topCriticalLayer > botCriticalLayer) {
                throw new SlownessModelException("findDepth: no layers to search!: topCriticalLayer = " + topCriticalLayer + "botCriticalLayer = " + botCriticalLayer);
            }
            for (int layerNum = topCriticalLayer; layerNum <= botCriticalLayer; ++layerNum) {
                velLayer = this.vMod.getVelocityLayer(layerNum);
                double topVelocity = velLayer.evaluateAtTop(waveType);
                double botVelocity = velLayer.evaluateAtBottom(waveType);
                topP = this.toSlowness(topVelocity, velLayer.getTopDepth());
                botP = this.toSlowness(botVelocity, velLayer.getBotDepth());
                if (Math.abs(topP - p) < this.slownessTolerance) {
                    return velLayer.getTopDepth();
                }
                if (Math.abs(p - botP) < this.slownessTolerance) {
                    return velLayer.getBotDepth();
                }
                if ((topP - p) * (p - botP) >= 0.0) {
                    double slope = (botVelocity - topVelocity) / (velLayer.getBotDepth() - velLayer.getTopDepth());
                    double depth = this.interpolate(p, topVelocity, velLayer.getTopDepth(), slope);
                    return depth;
                }
                if (layerNum == topCriticalLayer && Math.abs(p - topP) < this.slownessTolerance) {
                    return velLayer.getTopDepth();
                }
                if (layerNum >= this.vMod.getNumLayers() - 1) continue;
                velLayer = this.vMod.getVelocityLayer(layerNum + 1);
                topVelocity = velLayer.evaluateAtTop(waveType);
                if (!isPWave && this.depthInFluid(velLayer.getTopDepth())) {
                    topVelocity = velLayer.evaluateAtTop('P');
                }
                topP = this.toSlowness(topVelocity, velLayer.getTopDepth());
                if (!(botP >= p) || !(p >= topP)) continue;
                return velLayer.getTopDepth();
            }
            if (Math.abs(p - botP) < this.slownessTolerance) {
                System.out.println(" p is just outside the bottommost layer. This probably shouldn't be allowed to happen!\n");
                return velLayer.getBotDepth();
            }
        }
        catch (NoSuchMatPropException e) {
            e.printStackTrace();
        }
        throw new SlownessModelException("slowness p=" + p + " is not contained within the specified layers." + "\np=" + p + " topCriticalLayer=" + topCriticalLayer + " botCriticalLayer=" + botCriticalLayer + " isPWave=" + isPWave + " topP=" + topP + " botP=" + botP);
    }

    private void createSample() throws SlownessModelException, NoSuchMatPropException, NoSuchLayerException {
        if (!this.vMod.validate()) {
            throw new SlownessModelException("Error in velocity model!");
        }
        if (this.vMod.getNumLayers() == 0) {
            throw new SlownessModelException("velModel.getNumLayers()==0");
        }
        if (this.vMod.getVelocityLayer(0).getTopSVelocity() == 0.0) {
            throw new SlownessModelException("Unable to handle zero S velocity layers at surface. This should be fixed at some point, but is a limitation of TauP at this point.");
        }
        if (DEBUG) {
            System.out.println("start createSample");
        }
        this.setRadiusOfEarth(this.vMod.getRadiusOfEarth());
        if (DEBUG) {
            System.out.println("findCriticalPoints");
        }
        this.findCriticalPoints();
        if (DEBUG) {
            System.out.println("coarseSample");
        }
        this.coarseSample();
        boolean isOK = false;
        if (DEBUG) {
            isOK = this.validate();
            System.out.println("rayParamCheck");
        }
        this.rayParamIncCheck();
        if (DEBUG) {
            isOK &= this.validate();
            System.out.println("depthIncCheck");
        }
        this.depthIncCheck();
        if (DEBUG) {
            isOK &= this.validate();
            System.out.println("distanceCheck");
        }
        this.distanceCheck();
        if (DEBUG) {
            isOK &= this.validate();
            System.out.println("fixCriticalPoints");
        }
        this.fixCriticalPoints();
        if (DEBUG) {
            System.out.println("done createSample");
        }
    }

    protected void coarseSample() throws SlownessModelException, NoSuchLayerException, NoSuchMatPropException {
        int j;
        SlownessLayer highSLayer;
        int highZoneNum;
        this.PLayers.clear();
        this.SLayers.clear();
        VelocityLayer origVLayer = this.vMod.getVelocityLayer(0);
        origVLayer = new VelocityLayer(0, origVLayer.getTopDepth(), origVLayer.getTopDepth(), origVLayer.getTopPVelocity(), origVLayer.getTopPVelocity(), origVLayer.getTopSVelocity(), origVLayer.getTopSVelocity(), origVLayer.getTopDensity(), origVLayer.getTopDensity(), origVLayer.getTopQp(), origVLayer.getTopQp(), origVLayer.getTopQs(), origVLayer.getTopQs());
        for (int layerNum = 0; layerNum < this.vMod.getNumLayers(); ++layerNum) {
            SlownessLayer currSLayer;
            SlownessLayer currPLayer;
            VelocityLayer prevVLayer = origVLayer;
            origVLayer = this.vMod.getVelocityLayer(layerNum);
            if (prevVLayer.getBotPVelocity() != origVLayer.getTopPVelocity() || prevVLayer.getBotSVelocity() != origVLayer.getTopSVelocity() && (this.allowInnerCoreS || origVLayer.getTopDepth() < this.vMod.getIocbDepth())) {
                double topSVel = prevVLayer.getBotSVelocity() == 0.0 ? prevVLayer.getBotPVelocity() : prevVLayer.getBotSVelocity();
                double botSVel = origVLayer.getTopSVelocity() == 0.0 ? origVLayer.getTopPVelocity() : origVLayer.getTopSVelocity();
                VelocityLayer currVLayer = new VelocityLayer(layerNum, prevVLayer.getBotDepth(), prevVLayer.getBotDepth(), prevVLayer.getBotPVelocity(), origVLayer.getTopPVelocity(), topSVel, botSVel);
                currPLayer = this.toSlownessLayer(currVLayer, true);
                this.PLayers.add(currPLayer);
                currSLayer = prevVLayer.getBotSVelocity() == 0.0 && origVLayer.getTopSVelocity() == 0.0 || !this.allowInnerCoreS && currVLayer.getTopDepth() >= this.vMod.getIocbDepth() ? currPLayer : this.toSlownessLayer(currVLayer, false);
                this.SLayers.add(currSLayer);
            }
            currPLayer = this.toSlownessLayer(origVLayer, true);
            this.PLayers.add(currPLayer);
            currSLayer = this.depthInFluid(origVLayer.getTopDepth()) || !this.allowInnerCoreS && origVLayer.getTopDepth() >= this.vMod.getIocbDepth() ? currPLayer : this.toSlownessLayer(origVLayer, false);
            this.SLayers.add(currSLayer);
        }
        for (highZoneNum = 0; highZoneNum < this.highSlownessLayerDepthsS.size(); ++highZoneNum) {
            DepthRange highZone = this.highSlownessLayerDepthsS.get(highZoneNum);
            int SLayerNum = this.layerNumberAbove(highZone.botDepth, false);
            highSLayer = this.getSlownessLayer(SLayerNum, false);
            while (highSLayer.getTopDepth() == highSLayer.getBotDepth() && (highSLayer.getTopP() - highZone.rayParam) * (highZone.rayParam - highSLayer.getBotP()) < 0.0) {
                highSLayer = this.getSlownessLayer(++SLayerNum, false);
            }
            if (highZone.rayParam == highSLayer.getBotP()) continue;
            this.addSlowness(highZone.rayParam, false);
        }
        for (highZoneNum = 0; highZoneNum < this.highSlownessLayerDepthsP.size(); ++highZoneNum) {
            DepthRange highZone = this.highSlownessLayerDepthsP.get(highZoneNum);
            int SLayerNum = this.layerNumberAbove(highZone.botDepth, true);
            highSLayer = this.getSlownessLayer(SLayerNum, true);
            while (highSLayer.getTopDepth() == highSLayer.getBotDepth() && (highSLayer.getTopP() - highZone.rayParam) * (highZone.rayParam - highSLayer.getBotP()) < 0.0) {
                highSLayer = this.getSlownessLayer(++SLayerNum, true);
            }
            if (highZone.rayParam == highSLayer.getBotP()) continue;
            this.addSlowness(highZone.rayParam, true);
        }
        double botP = -1.0;
        double topP = -1.0;
        for (j = 0; j < this.PLayers.size(); ++j) {
            topP = this.PLayers.get(j).getTopP();
            if (topP != botP) {
                this.addSlowness(topP, false);
            }
            botP = this.PLayers.get(j).getBotP();
            this.addSlowness(botP, false);
        }
        botP = -1.0;
        for (j = 0; j < this.SLayers.size(); ++j) {
            topP = this.SLayers.get(j).getTopP();
            if (topP != botP) {
                this.addSlowness(topP, true);
            }
            botP = this.SLayers.get(j).getBotP();
            this.addSlowness(botP, true);
        }
    }

    protected void rayParamIncCheck() throws SlownessModelException, NoSuchLayerException {
        int rayNum;
        double deltaP;
        double numNewP;
        SlownessLayer sLayer;
        int j;
        for (j = 0; j < this.SLayers.size(); ++j) {
            sLayer = this.SLayers.get(j);
            if (!(Math.abs(sLayer.getTopP() - sLayer.getBotP()) > this.maxDeltaP)) continue;
            numNewP = Math.ceil(Math.abs(sLayer.getTopP() - sLayer.getBotP()) / this.maxDeltaP);
            deltaP = (sLayer.getTopP() - sLayer.getBotP()) / numNewP;
            rayNum = 1;
            while ((double)rayNum < numNewP) {
                this.addSlowness(sLayer.getTopP() + (double)rayNum * deltaP, true);
                this.addSlowness(sLayer.getTopP() + (double)rayNum * deltaP, false);
                ++rayNum;
            }
        }
        for (j = 0; j < this.PLayers.size(); ++j) {
            sLayer = this.PLayers.get(j);
            if (!(Math.abs(sLayer.getTopP() - sLayer.getBotP()) > this.maxDeltaP)) continue;
            numNewP = Math.ceil(Math.abs(sLayer.getTopP() - sLayer.getBotP()) / this.maxDeltaP);
            deltaP = (sLayer.getTopP() - sLayer.getBotP()) / numNewP;
            rayNum = 1;
            while ((double)rayNum < numNewP) {
                this.addSlowness(sLayer.getTopP() + (double)rayNum * deltaP, true);
                this.addSlowness(sLayer.getTopP() + (double)rayNum * deltaP, false);
                ++rayNum;
            }
        }
    }

    protected void depthIncCheck() throws SlownessModelException, NoSuchLayerException {
        try {
            double p;
            int depthNum;
            double deltaDepth;
            int numNewDepths;
            SlownessLayer sLayer;
            int j;
            for (j = 0; j < this.SLayers.size(); ++j) {
                sLayer = this.SLayers.get(j);
                if (!(sLayer.getBotDepth() - sLayer.getTopDepth() > this.maxDepthInterval)) continue;
                numNewDepths = (int)Math.ceil((sLayer.getBotDepth() - sLayer.getTopDepth()) / this.maxDepthInterval);
                deltaDepth = (sLayer.getBotDepth() - sLayer.getTopDepth()) / (double)numNewDepths;
                for (depthNum = 1; depthNum < numNewDepths; ++depthNum) {
                    double velocity = this.vMod.evaluateAbove(sLayer.getTopDepth() + (double)depthNum * deltaDepth, 'S');
                    if (velocity == 0.0 || !this.allowInnerCoreS && sLayer.getTopDepth() + (double)depthNum * deltaDepth >= this.vMod.getIocbDepth()) {
                        velocity = this.vMod.evaluateAbove(sLayer.getTopDepth() + (double)depthNum * deltaDepth, 'P');
                    }
                    p = this.toSlowness(velocity, sLayer.getTopDepth() + (double)depthNum * deltaDepth);
                    this.addSlowness(p, true);
                    this.addSlowness(p, false);
                }
            }
            for (j = 0; j < this.PLayers.size(); ++j) {
                sLayer = this.PLayers.get(j);
                if (!(sLayer.getBotDepth() - sLayer.getTopDepth() > this.maxDepthInterval)) continue;
                numNewDepths = (int)Math.ceil((sLayer.getBotDepth() - sLayer.getTopDepth()) / this.maxDepthInterval);
                deltaDepth = (sLayer.getBotDepth() - sLayer.getTopDepth()) / (double)numNewDepths;
                for (depthNum = 1; depthNum < numNewDepths; ++depthNum) {
                    p = this.toSlowness(this.vMod.evaluateAbove(sLayer.getTopDepth() + (double)depthNum * deltaDepth, 'P'), sLayer.getTopDepth() + (double)depthNum * deltaDepth);
                    this.addSlowness(p, true);
                    this.addSlowness(p, false);
                }
            }
        }
        catch (NoSuchMatPropException e) {
            throw new RuntimeException("can't happen", e);
        }
    }

    protected void distanceCheck() throws SlownessModelException, NoSuchMatPropException, NoSuchLayerException {
        for (int waveN = 0; waveN < 2; ++waveN) {
            boolean currWaveType = waveN != 0;
            TimeDist prevPrevTD = null;
            TimeDist prevTD = null;
            TimeDist currTD = null;
            boolean isCurrOK = false;
            boolean isPrevOK = false;
            int j = 0;
            SlownessLayer sLayer = this.getSlownessLayer(0, currWaveType);
            while (j < this.getNumLayers(currWaveType)) {
                SlownessLayer prevSLayer = sLayer;
                sLayer = this.getSlownessLayer(j, currWaveType);
                if (!this.depthInHighSlowness(sLayer.getBotDepth(), sLayer.getBotP(), currWaveType) && !this.depthInHighSlowness(sLayer.getTopDepth(), sLayer.getTopP(), currWaveType)) {
                    if (isCurrOK) {
                        prevPrevTD = isPrevOK ? prevTD : null;
                        prevTD = currTD;
                        isPrevOK = true;
                    } else {
                        prevTD = this.approxDistance(j - 1, sLayer.getTopP(), currWaveType);
                        isPrevOK = true;
                    }
                    currTD = this.approxDistance(j, sLayer.getBotP(), currWaveType);
                    isCurrOK = true;
                    if (Math.abs(prevTD.distRadian - currTD.distRadian) > this.maxRangeInterval && Math.abs(sLayer.getTopP() - sLayer.getBotP()) > 2.0 * this.minDeltaP) {
                        if (DEBUG) {
                            System.out.println(" " + j + "Dist jump too great: " + Math.abs(prevTD.distRadian - currTD.distRadian) + " > " + this.maxRangeInterval + "  adding slowness: " + (sLayer.getTopP() + sLayer.getBotP()) / 2.0);
                        }
                        this.addSlowness((sLayer.getTopP() + sLayer.getBotP()) / 2.0, true);
                        this.addSlowness((sLayer.getTopP() + sLayer.getBotP()) / 2.0, false);
                        currTD = prevTD;
                        prevTD = prevPrevTD;
                        continue;
                    }
                    double splitRayParam = (sLayer.getTopP() + sLayer.getBotP()) / 2.0;
                    TimeDist allButLayer = this.approxDistance(j - 1, splitRayParam, currWaveType);
                    SlownessLayer splitLayer = new SlownessLayer(sLayer.getTopP(), sLayer.getTopDepth(), splitRayParam, sLayer.bullenDepthFor(splitRayParam, this.getRadiusOfEarth()));
                    TimeDist justLayer = splitLayer.bullenRadialSlowness(splitRayParam, this.getRadiusOfEarth());
                    TimeDist splitTD = new TimeDist(splitRayParam, allButLayer.time + 2.0 * justLayer.time, allButLayer.distRadian + 2.0 * justLayer.distRadian);
                    if (Math.abs(currTD.time - ((splitTD.time - prevTD.time) * (currTD.distRadian - prevTD.distRadian) / (splitTD.distRadian - prevTD.distRadian) + prevTD.time)) > this.maxInterpError) {
                        if (DEBUG) {
                            System.out.print(" " + j + " add slowness " + Math.abs(currTD.time - ((splitTD.time - prevTD.time) * (currTD.distRadian - prevTD.distRadian) / (splitTD.distRadian - prevTD.distRadian) + prevTD.time)) + " > " + this.maxInterpError);
                        }
                        this.addSlowness((prevSLayer.getTopP() + prevSLayer.getBotP()) / 2.0, true);
                        this.addSlowness((prevSLayer.getTopP() + prevSLayer.getBotP()) / 2.0, false);
                        this.addSlowness((sLayer.getTopP() + sLayer.getBotP()) / 2.0, true);
                        this.addSlowness((sLayer.getTopP() + sLayer.getBotP()) / 2.0, false);
                        currTD = prevPrevTD;
                        isPrevOK = false;
                        if (j > 0) {
                            sLayer = this.getSlownessLayer(--j - 1 >= 0 ? j - 1 : 0, currWaveType);
                            continue;
                        }
                        isPrevOK = false;
                        isCurrOK = false;
                        continue;
                    }
                    if (!DEBUG || ++j % 10 != 0) continue;
                    System.out.println(j);
                    continue;
                }
                prevPrevTD = null;
                prevTD = null;
                currTD = null;
                isCurrOK = false;
                isPrevOK = false;
                if (!DEBUG || ++j % 100 != 0) continue;
                System.out.print(" " + j);
            }
            if (!DEBUG) continue;
            System.out.println("\nNumber of " + (currWaveType ? (char)'P' : 'S') + " slowness layers: " + j);
        }
    }

    protected void addSlowness(double p, boolean isPWave) throws SlownessModelException, NoSuchLayerException {
        List<SlownessLayer> otherLayers;
        List<SlownessLayer> layers;
        if (isPWave) {
            layers = this.PLayers;
            otherLayers = this.SLayers;
        } else {
            layers = this.SLayers;
            otherLayers = this.PLayers;
        }
        for (int i = 0; i < layers.size(); ++i) {
            double botVelocity;
            double topVelocity;
            SlownessLayer sLayer = layers.get(i);
            try {
                if (sLayer.getTopDepth() != sLayer.getBotDepth()) {
                    topVelocity = this.vMod.evaluateBelow(sLayer.getTopDepth(), isPWave ? (char)'P' : 'S');
                    botVelocity = this.vMod.evaluateAbove(sLayer.getBotDepth(), isPWave ? (char)'P' : 'S');
                } else {
                    topVelocity = this.vMod.evaluateAbove(sLayer.getBotDepth(), isPWave ? (char)'P' : 'S');
                    botVelocity = this.vMod.evaluateBelow(sLayer.getTopDepth(), isPWave ? (char)'P' : 'S');
                }
            }
            catch (NoSuchMatPropException e) {
                throw new SlownessModelException("Caught NoSuchMatPropException: " + e.getMessage());
            }
            if (!isPWave) {
                if (!this.allowInnerCoreS && sLayer.getBotDepth() > this.vMod.getIocbDepth()) break;
                if (topVelocity == 0.0) continue;
            }
            if (!((sLayer.getTopP() - p) * (p - sLayer.getBotP()) > 0.0)) continue;
            double botDepth = sLayer.getBotDepth();
            if (sLayer.getBotDepth() != sLayer.getTopDepth()) {
                double slope = (botVelocity - topVelocity) / (sLayer.getBotDepth() - sLayer.getTopDepth());
                botDepth = this.interpolate(p, topVelocity, sLayer.getTopDepth(), slope);
            }
            SlownessLayer botLayer = new SlownessLayer(p, botDepth, sLayer.getBotP(), sLayer.getBotDepth());
            SlownessLayer topLayer = new SlownessLayer(sLayer.getTopP(), sLayer.getTopDepth(), p, botDepth);
            layers.remove(i);
            layers.add(i, botLayer);
            layers.add(i, topLayer);
            int otherIndex = otherLayers.indexOf(sLayer);
            if (otherIndex == -1) continue;
            otherLayers.remove(otherIndex);
            otherLayers.add(otherIndex, botLayer);
            otherLayers.add(otherIndex, topLayer);
        }
    }

    protected void fixCriticalPoints() throws NoSuchLayerException {
        for (int i = 0; i < this.criticalDepths.size(); ++i) {
            CriticalDepth cd = this.criticalDepths.get(i);
            cd.setPLayerNum(this.layerNumberBelow(cd.getDepth(), true));
            SlownessLayer sLayer = this.getSlownessLayer(cd.getPLayerNum(), true);
            if (cd.getPLayerNum() == this.PLayers.size() - 1 && sLayer.getBotDepth() == cd.getDepth()) {
                cd.setPLayerNum(cd.getPLayerNum() + 1);
            }
            cd.setSLayerNum(this.layerNumberBelow(cd.getDepth(), false));
            sLayer = this.getSlownessLayer(cd.getSLayerNum(), false);
            if (cd.getSLayerNum() != this.SLayers.size() - 1 || sLayer.getBotDepth() != cd.getDepth()) continue;
            cd.setSLayerNum(cd.getSLayerNum() + 1);
        }
    }

    public int layerNumForDepth(double depth, boolean isPWave) throws NoSuchLayerException {
        List<SlownessLayer> layers = isPWave ? this.PLayers : this.SLayers;
        if (depth < layers.get(0).getTopDepth() || layers.get(layers.size() - 1).getBotDepth() < depth) {
            throw new NoSuchLayerException(depth);
        }
        int tooSmallNum = 0;
        int tooLargeNum = layers.size() - 1;
        int currentNum = 0;
        do {
            SlownessLayer tempLayer;
            if (tooLargeNum - tooSmallNum < 3) {
                for (currentNum = tooSmallNum; currentNum <= tooLargeNum; ++currentNum) {
                    tempLayer = this.getSlownessLayer(currentNum, isPWave);
                    if (!tempLayer.containsDepth(depth)) continue;
                    return currentNum;
                }
            } else {
                currentNum = Math.round((float)(tooSmallNum + tooLargeNum) / 2.0f);
            }
            if ((tempLayer = this.getSlownessLayer(currentNum, isPWave)).getTopDepth() > depth) {
                tooLargeNum = currentNum - 1;
                continue;
            }
            if (tempLayer.getBotDepth() < depth) {
                tooSmallNum = currentNum + 1;
                continue;
            }
            return currentNum;
        } while (tooSmallNum <= tooLargeNum);
        throw new RuntimeException("tooSmallNum (" + tooSmallNum + ") >= tooLargeNum (" + tooLargeNum + ")");
    }

    public int layerNumberAbove(double depth, boolean isPWave) throws NoSuchLayerException {
        int foundLayerNum = this.layerNumForDepth(depth, isPWave);
        SlownessLayer tempLayer = this.getSlownessLayer(foundLayerNum, isPWave);
        while (tempLayer.getTopDepth() == depth && foundLayerNum > 0) {
            tempLayer = this.getSlownessLayer(--foundLayerNum, isPWave);
        }
        return foundLayerNum;
    }

    public int layerNumberBelow(double depth, boolean isPWave) throws NoSuchLayerException {
        int foundLayerNum = this.layerNumForDepth(depth, isPWave);
        List<SlownessLayer> layers = isPWave ? this.PLayers : this.SLayers;
        SlownessLayer tempLayer = this.getSlownessLayer(foundLayerNum, isPWave);
        while (tempLayer.getBotDepth() == depth && foundLayerNum < layers.size() - 1) {
            tempLayer = this.getSlownessLayer(++foundLayerNum, isPWave);
        }
        return foundLayerNum;
    }

    public boolean validate() throws SlownessModelException {
        double prevDepth;
        boolean isOK = true;
        if (this.radiusOfEarth <= 0.0) {
            throw new SlownessModelException("Radius of earth is not positive. radiusOfEarth = " + this.radiusOfEarth);
        }
        if (this.maxDepthInterval <= 0.0) {
            throw new SlownessModelException("maxDepthInterval is not positive. maxDepthInterval = " + this.maxDepthInterval);
        }
        List<DepthRange> highSlownessLayerDepths = this.highSlownessLayerDepthsP;
        boolean isPWave = true;
        for (int j = 0; j < 2; ++j) {
            highSlownessLayerDepths = isPWave ? this.highSlownessLayerDepthsP : this.highSlownessLayerDepthsS;
            prevDepth = -1.7976931348623157E308;
            for (int i = 0; i < highSlownessLayerDepths.size(); ++i) {
                DepthRange highSZoneDepth = highSlownessLayerDepths.get(i);
                if (highSZoneDepth.topDepth >= highSZoneDepth.botDepth) {
                    throw new SlownessModelException("High slowness zone has zero or negative thickness. Num " + i + " isPWave=" + isPWave + " top depth " + highSZoneDepth.topDepth + " bottom depth " + highSZoneDepth.botDepth);
                }
                if (highSZoneDepth.topDepth <= prevDepth) {
                    throw new SlownessModelException("High slowness zone overlaps previous zone. Num " + i + " isPWave=" + isPWave + " top depth " + highSZoneDepth.topDepth + " bottom depth " + highSZoneDepth.botDepth);
                }
                prevDepth = highSZoneDepth.botDepth;
            }
            isPWave = false;
        }
        prevDepth = -1.7976931348623157E308;
        for (int i = 0; i < this.fluidLayerDepths.size(); ++i) {
            DepthRange fluidZone = this.fluidLayerDepths.get(i);
            if (fluidZone.topDepth >= fluidZone.botDepth) {
                throw new SlownessModelException("Fluid zone has zero or negative thickness. Num " + i + " top depth " + fluidZone.topDepth + " bottom depth " + fluidZone.botDepth);
            }
            if (fluidZone.topDepth <= prevDepth) {
                throw new SlownessModelException("Fluid zone overlaps previous zone. Num " + i + " top depth " + fluidZone.topDepth + " bottom depth " + fluidZone.botDepth);
            }
            prevDepth = fluidZone.botDepth;
        }
        isPWave = true;
        for (int j = 0; j < 2; ++j) {
            double prevBotP;
            prevDepth = 0.0;
            SlownessLayer sLayer = null;
            if (this.getNumLayers(isPWave) > 0) {
                sLayer = this.getSlownessLayer(0, isPWave);
                prevBotP = sLayer.getTopP();
            } else {
                prevBotP = -1.0;
            }
            SlownessLayer prevSLayer = null;
            for (int i = 0; i < this.getNumLayers(isPWave); ++i) {
                sLayer = this.getSlownessLayer(i, isPWave);
                isOK &= sLayer.validate();
                if (sLayer.getTopDepth() > prevDepth) {
                    throw new SlownessModelException("Gap of " + (sLayer.getTopDepth() - prevDepth) + " between slowness layers. Num " + i + " isPWave=" + isPWave + "  top " + prevSLayer + " bottom " + sLayer);
                }
                if (sLayer.getTopDepth() < prevDepth) {
                    throw new SlownessModelException("Slowness layer overlaps previous layer by " + (prevDepth - sLayer.getTopDepth()) + ". Num " + i + " isPWave=" + isPWave + " top depth " + sLayer.getTopDepth() + " bottom depth " + sLayer.getBotDepth());
                }
                if (sLayer.getTopP() != prevBotP) {
                    throw new SlownessModelException("Slowness layer gap/overlaps previous layer in slowness . Num " + i + " isPWave=" + isPWave + " prevBotP= " + prevBotP + " prevSLayer= " + prevSLayer + " sLayer= " + sLayer);
                }
                if (Double.isNaN(sLayer.getTopDepth())) {
                    throw new SlownessModelException("Top depth is NaN, layerNum=" + i + " waveType=" + (isPWave ? (char)'P' : 'S'));
                }
                if (Double.isNaN(sLayer.getBotDepth())) {
                    throw new SlownessModelException("Top depth is NaN, layerNum=" + i + " waveType=" + (isPWave ? (char)'P' : 'S'));
                }
                prevSLayer = sLayer;
                prevBotP = sLayer.getBotP();
                prevDepth = sLayer.getBotDepth();
            }
            isPWave = false;
        }
        return isOK;
    }

    public String toString() {
        int i;
        String desc = "";
        desc = "radiusOfEarth=" + this.radiusOfEarth + "\n maxDeltaP=" + this.maxDeltaP + "\n minDeltaP=" + this.minDeltaP + "\n maxDepthInterval=" + this.maxDepthInterval + "\n maxRangeInterval=" + this.maxRangeInterval + "\n allowInnerCoreS=" + this.allowInnerCoreS + "\n slownessTolerance=" + this.slownessTolerance + "\n getNumLayers('P')=" + this.getNumLayers(true) + "\n getNumLayers('S')=" + this.getNumLayers(false) + "\n fluidLayerDepths.size()=" + this.fluidLayerDepths.size() + "\n highSlownessLayerDepthsP.size()=" + this.highSlownessLayerDepthsP.size() + "\n highSlownessLayerDepthsS.size()=" + this.highSlownessLayerDepthsS.size() + "\n criticalDepths.size()=" + this.criticalDepths.size() + "\n";
        if (this.criticalDepths.size() != 0) {
            desc = desc + "**** Critical Depth Layers ************************\n";
            int botCriticalLayerNum = this.criticalDepths.get(0).getVelLayerNum() - 1;
            for (int criticalNum = 1; criticalNum < this.criticalDepths.size(); ++criticalNum) {
                int topCriticalLayerNum = botCriticalLayerNum + 1;
                botCriticalLayerNum = this.criticalDepths.get(criticalNum).getVelLayerNum() - 1;
                desc = desc + " " + topCriticalLayerNum + "," + botCriticalLayerNum;
            }
        }
        desc = desc + "\n";
        if (this.fluidLayerDepths.size() != 0) {
            desc = desc + "\n**** Fluid Layer Depths ************************\n";
            for (i = 0; i < this.fluidLayerDepths.size(); ++i) {
                desc = desc + this.fluidLayerDepths.get((int)i).topDepth + "," + this.fluidLayerDepths.get((int)i).botDepth + " ";
            }
        }
        desc = desc + "\n";
        if (this.highSlownessLayerDepthsP.size() != 0) {
            desc = desc + "\n**** P High Slowness Layer Depths ****************\n";
            for (i = 0; i < this.highSlownessLayerDepthsP.size(); ++i) {
                desc = desc + this.highSlownessLayerDepthsP.get((int)i).topDepth + "," + this.highSlownessLayerDepthsP.get((int)i).botDepth + " ";
            }
        }
        desc = desc + "\n";
        if (this.highSlownessLayerDepthsS.size() != 0) {
            desc = desc + "\n**** S High Slowness Layer Depths ****************\n";
            for (i = 0; i < this.highSlownessLayerDepthsS.size(); ++i) {
                desc = desc + this.highSlownessLayerDepthsS.get((int)i).topDepth + "," + this.highSlownessLayerDepthsS.get((int)i).botDepth + " ";
            }
        }
        desc = desc + "\n";
        desc = desc + "\n**** P Layers ****************\n";
        for (SlownessLayer l : this.PLayers) {
            desc = desc + l.toString() + "\n";
        }
        return desc;
    }
}

