/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.DepthRange;
import edu.sc.seis.TauP.NoSuchLayerException;
import edu.sc.seis.TauP.NoSuchMatPropException;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.TauBranch;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauModelLoader;
import edu.sc.seis.TauP.TauP_Time;
import edu.sc.seis.TauP.TimeDist;
import edu.sc.seis.TauP.VelocityModel;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SeismicPhase
implements Serializable,
Cloneable {
    public transient boolean DEBUG = TauP_Time.DEBUG;
    public transient boolean verbose = false;
    public static transient boolean expert = TauP_Time.expert;
    protected TauModel tMod;
    public static final int TURN = 0;
    public static final int REFLECTTOP = 1;
    public static final int REFLECTBOT = 2;
    public static final int TRANSUP = 3;
    public static final int TRANSDOWN = 4;
    protected static double maxRefraction = 20.0;
    protected static double maxDiffraction = 60.0;
    protected double sourceDepth;
    protected double[] dist = new double[0];
    protected double[] time = new double[0];
    protected double[] rayParams = new double[0];
    protected double minRayParam;
    protected double maxRayParam;
    protected int maxRayParamIndex = -1;
    protected int minRayParamIndex = -1;
    protected double minDistance = 0.0;
    protected double maxDistance = Double.MAX_VALUE;
    protected ArrayList<Integer> branchSeq = new ArrayList();
    protected String name;
    protected String puristName;
    protected ArrayList<String> legs = new ArrayList();
    protected transient int currBranch;
    protected transient int endAction;
    protected ArrayList<Integer> legAction = new ArrayList();
    protected ArrayList<Boolean> downGoing = new ArrayList();
    protected ArrayList<Boolean> waveType = new ArrayList();
    public static final boolean PWAVE = true;
    public static final boolean SWAVE = false;
    private String validationFailMessage = "";

    public SeismicPhase(String name, String modelName, double depth) throws TauModelException {
        this(name, TauModelLoader.load(modelName).depthCorrect(depth));
    }

    public SeismicPhase(String name, TauModel tMod) throws TauModelException {
        this.name = name;
        this.sourceDepth = tMod.getSourceDepth();
        this.tMod = tMod;
        this.legs = SeismicPhase.legPuller(name);
        this.createPuristName(tMod);
        this.parseName(tMod);
        this.sumBranches(tMod);
    }

    public Arrival getEarliestArrival(double degrees) {
        double soonest = 9.99999999E8;
        Arrival soonestArrival = null;
        List<Arrival> arrivals = this.calcTime(degrees);
        for (Arrival a : arrivals) {
            if (!(a.getTime() < soonest)) continue;
            soonestArrival = a;
            soonest = a.getTime();
        }
        return soonestArrival;
    }

    public TauModel getTauModel() {
        return this.tMod;
    }

    public double getMinDistanceDeg() {
        return this.getMinDistance() * 180.0 / Math.PI;
    }

    public double getMinDistance() {
        return this.minDistance;
    }

    public double getMaxDistanceDeg() {
        return this.getMaxDistance() * 180.0 / Math.PI;
    }

    public double getMaxDistance() {
        return this.maxDistance;
    }

    public double getMaxRayParam() {
        return this.maxRayParam;
    }

    public double getMinRayParam() {
        return this.minRayParam;
    }

    public int getMaxRayParamIndex() {
        return this.maxRayParamIndex;
    }

    public int getMinRayParamIndex() {
        return this.minRayParamIndex;
    }

    public static double getMaxRefraction() {
        return maxRefraction;
    }

    public static void setMaxRefraction(double max) {
        maxRefraction = max;
    }

    public static double getMaxDiffraction() {
        return maxDiffraction;
    }

    public static void setMaxDiffraction(double max) {
        maxDiffraction = max;
    }

    public String getName() {
        return this.name;
    }

    public String getPuristName() {
        return this.name;
    }

    public List<String> getLegs() {
        return Collections.unmodifiableList(this.legs);
    }

    public double[] getRayParams() {
        return (double[])this.rayParams.clone();
    }

    public double[] getDist() {
        return (double[])this.dist.clone();
    }

    public double[] getTime() {
        return (double[])this.time.clone();
    }

    public double[] getTau() {
        double[] tau = new double[this.dist.length];
        for (int i = 0; i < this.dist.length; ++i) {
            tau[i] = this.time[i] - this.rayParams[i] * this.dist[i];
        }
        return tau;
    }

    public boolean[] getDownGoing() {
        Boolean[] b = this.downGoing.toArray(new Boolean[0]);
        boolean[] out = new boolean[b.length];
        for (int i = 0; i < b.length; ++i) {
            out[i] = b[i];
        }
        return out;
    }

    public boolean[] getWaveType() {
        Boolean[] b = this.waveType.toArray(new Boolean[0]);
        boolean[] out = new boolean[b.length];
        for (int i = 0; i < b.length; ++i) {
            out[i] = b[i];
        }
        return out;
    }

    public int[] getLegAction() {
        Integer[] b = this.legAction.toArray(new Integer[0]);
        int[] out = new int[b.length];
        for (int i = 0; i < b.length; ++i) {
            out[i] = b[i];
        }
        return out;
    }

    public boolean hasArrivals() {
        return this.dist != null && this.dist.length != 0;
    }

    public List<Arrival> calcTime(double deg) {
        double tempDeg = deg;
        if (tempDeg < 0.0) {
            tempDeg *= -1.0;
        }
        while (tempDeg > 360.0) {
            tempDeg -= 360.0;
        }
        if (tempDeg > 180.0) {
            tempDeg = 360.0 - tempDeg;
        }
        double radDist = tempDeg * Math.PI / 180.0;
        ArrayList<Arrival> arrivals = new ArrayList<Arrival>();
        int n = 0;
        while ((double)n * 2.0 * Math.PI + radDist <= this.maxDistance) {
            int rayNum;
            double searchDist = (double)n * 2.0 * Math.PI + radDist;
            for (rayNum = 0; rayNum < this.dist.length - 1; ++rayNum) {
                if (searchDist == this.dist[rayNum + 1] && rayNum + 1 != this.dist.length - 1 || !((this.dist[rayNum] - searchDist) * (searchDist - this.dist[rayNum + 1]) >= 0.0) || this.rayParams[rayNum] == this.rayParams[rayNum + 1] && this.rayParams.length > 2) continue;
                if (this.DEBUG) {
                    System.err.println("SeismicPhase " + this.name + ", found arrival:\n" + "dist " + (float)(57.29577951308232 * this.dist[rayNum]) + " " + (float)(57.29577951308232 * searchDist) + " " + (float)(57.29577951308232 * this.dist[rayNum + 1]));
                }
                arrivals.add(this.linearInterpArrival(searchDist, rayNum, this.name, this.puristName, this.sourceDepth));
            }
            searchDist = (double)(n + 1) * 2.0 * Math.PI - radDist;
            if (tempDeg != 180.0) {
                for (rayNum = 0; rayNum < this.dist.length - 1; ++rayNum) {
                    if (searchDist == this.dist[rayNum + 1] && rayNum + 1 != this.dist.length - 1 || !((this.dist[rayNum] - searchDist) * (searchDist - this.dist[rayNum + 1]) >= 0.0) || this.rayParams[rayNum] == this.rayParams[rayNum + 1] && this.rayParams.length > 2) continue;
                    if (this.DEBUG) {
                        System.err.println("SeismicPhase " + this.name + ", found arrival:\n" + "dist " + (float)(57.29577951308232 * this.dist[rayNum]) + " " + (float)(57.29577951308232 * searchDist) + " " + (float)(57.29577951308232 * this.dist[rayNum + 1]));
                    }
                    arrivals.add(this.linearInterpArrival(searchDist, rayNum, this.name, this.puristName, this.sourceDepth));
                }
            }
            ++n;
        }
        Collections.sort(arrivals, new Comparator<Arrival>(){

            @Override
            public int compare(Arrival o1, Arrival o2) {
                return Double.compare(o1.getTime(), o2.getTime());
            }
        });
        return arrivals;
    }

    private Arrival linearInterpArrival(double searchDist, int rayNum, String name, String puristName, double sourceDepth) {
        double arrivalTime = (searchDist - this.dist[rayNum]) / (this.dist[rayNum + 1] - this.dist[rayNum]) * (this.time[rayNum + 1] - this.time[rayNum]) + this.time[rayNum];
        double arrivalRayParam = (searchDist - this.dist[rayNum + 1]) * (this.rayParams[rayNum] - this.rayParams[rayNum + 1]) / (this.dist[rayNum] - this.dist[rayNum + 1]) + this.rayParams[rayNum + 1];
        double takeoffAngle = -1.0;
        double incidentAngle = -1.0;
        if (name.endsWith("kmps")) {
            takeoffAngle = 0.0;
            incidentAngle = 0.0;
        } else {
            VelocityModel vMod = this.getTauModel().getVelocityModel();
            try {
                double takeoffVelocity = this.getDownGoing()[0] ? vMod.evaluateBelow(sourceDepth, name.charAt(0)) : -1.0 * vMod.evaluateAbove(sourceDepth, name.charAt(0));
                takeoffAngle = 57.29577951308232 * Math.asin(takeoffVelocity * arrivalRayParam / (this.getTauModel().getRadiusOfEarth() - sourceDepth));
                char lastLeg = this.getLegs().get(this.getLegs().size() - 2).charAt(0);
                incidentAngle = 57.29577951308232 * Math.asin(vMod.evaluateBelow(0.0, lastLeg) * arrivalRayParam / this.getTauModel().getRadiusOfEarth());
            }
            catch (NoSuchLayerException e) {
                throw new RuntimeException("Should not happen", e);
            }
            catch (NoSuchMatPropException e) {
                throw new RuntimeException("Should not happen", e);
            }
        }
        return new Arrival(this, arrivalTime, searchDist, arrivalRayParam, rayNum, name, puristName, sourceDepth, takeoffAngle, incidentAngle);
    }

    protected void phaseConversion(TauModel tMod, int fromBranch, int endAction, boolean isPtoS) throws TauModelException {
        if (endAction == 0) {
            throw new TauModelException("Illegal endAction: endAction=" + endAction + "\nphase conversion are not allowed at turn points.");
        }
        if (endAction == 1) {
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(fromBranch, isPtoS).getMaxRayParam());
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(fromBranch, !isPtoS).getMaxRayParam());
        } else if (endAction == 2) {
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(fromBranch, isPtoS).getMinTurnRayParam());
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(fromBranch, !isPtoS).getMinTurnRayParam());
        } else if (endAction == 3) {
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(fromBranch, isPtoS).getMaxRayParam());
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(fromBranch - 1, !isPtoS).getMinTurnRayParam());
        } else if (endAction == 4) {
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(fromBranch, isPtoS).getMinRayParam());
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(fromBranch + 1, !isPtoS).getMaxRayParam());
        } else {
            throw new TauModelException("Illegal endAction: endAction=" + endAction);
        }
    }

    protected void addToBranch(TauModel tMod, int startBranch, int endBranch, boolean isPWave, int endAction) throws TauModelException {
        boolean isDownGoing;
        int endOffset;
        this.endAction = endAction;
        if (this.DEBUG) {
            System.out.print("start=" + startBranch + " end=" + endBranch + " endOffset=");
            if (endAction == 0) {
                System.out.println("TURN");
            } else if (endAction == 1) {
                System.out.println("REFLECTTOP");
            } else if (endAction == 2) {
                System.out.println("REFLECTBOT");
            } else if (endAction == 3) {
                System.out.println("TRANSUP");
            } else if (endAction == 4) {
                System.out.println("TRANSDOWN");
            } else {
                System.out.println(endAction);
            }
        }
        if (endAction == 0) {
            endOffset = 0;
            isDownGoing = true;
            this.minRayParam = Math.max(this.minRayParam, tMod.getTauBranch(endBranch, isPWave).getMinTurnRayParam());
        } else if (endAction == 1) {
            endOffset = 0;
            isDownGoing = false;
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(endBranch, isPWave).getMaxRayParam());
        } else if (endAction == 2) {
            endOffset = 0;
            isDownGoing = true;
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(endBranch, isPWave).getMinTurnRayParam());
        } else if (endAction == 3) {
            endOffset = -1;
            isDownGoing = false;
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(endBranch, isPWave).getMaxRayParam());
        } else if (endAction == 4) {
            endOffset = 1;
            isDownGoing = true;
            this.maxRayParam = Math.min(this.maxRayParam, tMod.getTauBranch(endBranch, isPWave).getMinRayParam());
        } else {
            throw new TauModelException("Illegal endAction: endAction=" + endAction);
        }
        if (isDownGoing) {
            int i;
            for (i = startBranch; i <= endBranch; ++i) {
                this.branchSeq.add(new Integer(i));
                this.downGoing.add(new Boolean(isDownGoing));
                this.waveType.add(new Boolean(isPWave));
                this.legAction.add(new Integer(endAction));
            }
            if (this.DEBUG) {
                for (i = startBranch; i <= endBranch; ++i) {
                    System.out.println("i=" + i + " isDownGoing=" + isDownGoing + " isPWave=" + isPWave + " startBranch=" + startBranch + " endBranch=" + endBranch + " " + endAction);
                }
            }
        } else {
            int i;
            for (i = startBranch; i >= endBranch; --i) {
                this.branchSeq.add(new Integer(i));
                this.downGoing.add(new Boolean(isDownGoing));
                this.waveType.add(new Boolean(isPWave));
                this.legAction.add(new Integer(endAction));
            }
            if (this.DEBUG) {
                for (i = startBranch; i >= endBranch; --i) {
                    System.out.println("i=" + i + " isDownGoing=" + isDownGoing + " isPWave=" + isPWave + " startBranch=" + startBranch + " endBranch=" + endBranch + " " + endAction);
                }
            }
        }
        this.currBranch = endBranch + endOffset;
    }

    public int closestBranchToDepth(TauModel tMod, String depthString) {
        if (depthString.equals("m")) {
            return tMod.getMohoBranch();
        }
        if (depthString.equals("c")) {
            return tMod.getCmbBranch();
        }
        if (depthString.equals("i")) {
            return tMod.getIocbBranch();
        }
        int disconBranch = -1;
        double disconMax = Double.MAX_VALUE;
        double disconDepth = Double.valueOf(depthString);
        for (int i = 0; i < tMod.getNumBranches(); ++i) {
            TauBranch tBranch = tMod.getTauBranch(i, true);
            if (!(Math.abs(disconDepth - tBranch.getTopDepth()) < disconMax) || tMod.isNoDisconDepth(tBranch.getTopDepth())) continue;
            disconBranch = i;
            disconMax = Math.abs(disconDepth - tBranch.getTopDepth());
        }
        return disconBranch;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseName(TauModel tMod) throws TauModelException {
        double sdep;
        boolean isPWave;
        String currLeg;
        String nextLeg = currLeg = this.legs.get(0);
        this.branchSeq.clear();
        boolean isPWavePrev = isPWave = true;
        if (this.legs.size() == 2 && currLeg.endsWith("kmps")) {
            return;
        }
        if (this.name.indexOf(74) != -1 && !tMod.getSlownessModel().isAllowInnerCoreS()) {
            throw new TauModelException("'J' phases were not created for this model: " + this.name);
        }
        if (currLeg.equals("p") || currLeg.startsWith("P") || currLeg.equals("K") || currLeg.equals("k")) {
            isPWavePrev = isPWave = true;
        } else if (currLeg.equals("s") || currLeg.startsWith("S") || currLeg.equals("J")) {
            isPWavePrev = isPWave = false;
        }
        if ((currLeg.startsWith("s") || currLeg.startsWith("S")) && (sdep = tMod.getSourceDepth()) > tMod.getCmbDepth() && sdep < tMod.getIocbDepth()) {
            this.minRayParam = -1.0;
            this.maxRayParam = -1.0;
            return;
        }
        if (currLeg.startsWith("P") || currLeg.startsWith("S") || expert && (currLeg.startsWith("K") || currLeg.startsWith("I"))) {
            this.currBranch = tMod.getSourceBranch();
            this.endAction = 2;
        } else {
            if (!currLeg.equals("p") && !currLeg.equals("s") && (!expert || !currLeg.startsWith("k"))) throw new TauModelException("First phase not recognized: " + currLeg + " must be one of P, Pg, Pn, Pdiff, p or the S equivalents");
            this.endAction = 1;
            if (tMod.getSourceBranch() != 0) {
                this.currBranch = tMod.getSourceBranch() - 1;
            } else {
                this.maxRayParam = -1.0;
                this.minRayParam = -1.0;
                return;
            }
        }
        this.maxRayParam = tMod.getSourceBranch() != 0 ? Math.max(tMod.getTauBranch(tMod.getSourceBranch() - 1, isPWave).getMinTurnRayParam(), tMod.getTauBranch(tMod.getSourceBranch(), isPWave).getMaxRayParam()) : tMod.getTauBranch(tMod.getSourceBranch(), isPWave).getMaxRayParam();
        this.minRayParam = 0.0;
        int disconBranch = 0;
        double nextLegDepth = 0.0;
        boolean isNextLegDepth = false;
        this.endAction = 4;
        currLeg = "START";
        for (int legNum = 0; legNum < this.legs.size() - 1; ++legNum) {
            String prevLeg = currLeg;
            currLeg = nextLeg;
            nextLeg = this.legs.get(legNum + 1);
            if (this.DEBUG) {
                System.out.println(legNum + "  " + prevLeg + "  " + currLeg + "  " + nextLeg);
            }
            boolean isLegDepth = isNextLegDepth;
            try {
                nextLegDepth = new Double(nextLeg);
                isNextLegDepth = true;
            }
            catch (NumberFormatException e) {
                nextLegDepth = -1.0;
                isNextLegDepth = false;
            }
            isPWavePrev = isPWave;
            if (currLeg.equals("p") || currLeg.startsWith("P") || currLeg.equals("k") || currLeg.equals("I")) {
                isPWave = true;
            } else if (currLeg.equals("s") || currLeg.startsWith("S") || currLeg.equals("J")) {
                isPWave = false;
            } else if (currLeg.equals("K")) {
                // empty if block
            }
            if (this.branchSeq.size() > 0 && isPWavePrev != isPWave) {
                this.phaseConversion(tMod, this.branchSeq.get(this.branchSeq.size() - 1), this.endAction, isPWavePrev);
            }
            if (currLeg.equals("p") || currLeg.equals("s") || currLeg.equals("k")) {
                if (nextLeg.startsWith("v")) {
                    throw new TauModelException("p and s must always be up going  and cannot come immediately before a top-side reflection. currLeg=" + currLeg + " nextLeg=" + nextLeg);
                }
                if (nextLeg.startsWith("^")) {
                    disconBranch = this.closestBranchToDepth(tMod, nextLeg.substring(1));
                    if (this.currBranch < disconBranch) throw new TauModelException("Phase not recognized: " + currLeg + " followed by " + nextLeg + " when currBranch=" + this.currBranch + " > disconBranch=" + disconBranch);
                    this.addToBranch(tMod, this.currBranch, disconBranch, isPWave, 1);
                    continue;
                }
                if (nextLeg.equals("m") && this.currBranch >= tMod.getMohoBranch()) {
                    this.addToBranch(tMod, this.currBranch, tMod.getMohoBranch(), isPWave, 3);
                    continue;
                }
                if (nextLeg.startsWith("P") || nextLeg.startsWith("S") || nextLeg.equals("K") || nextLeg.equals("END")) {
                    disconBranch = nextLeg.equals("K") ? tMod.getCmbBranch() : 0;
                    this.addToBranch(tMod, this.currBranch, disconBranch, isPWave, currLeg.equals("k") & !nextLeg.equals("K") ? 3 : 1);
                    continue;
                }
                if (!isNextLegDepth) throw new TauModelException("Phase not recognized: " + currLeg + " followed by " + nextLeg);
                disconBranch = this.closestBranchToDepth(tMod, nextLeg);
                this.addToBranch(tMod, this.currBranch, disconBranch, isPWave, 3);
                continue;
            }
            if (currLeg.equals("P") || currLeg.equals("S")) {
                if (nextLeg.equals("P") || nextLeg.equals("S") || nextLeg.equals("Pn") || nextLeg.equals("Sn") || nextLeg.equals("END")) {
                    if (this.endAction == 4 || this.endAction == 1) {
                        this.addToBranch(tMod, this.currBranch, tMod.getCmbBranch() - 1, isPWave, 0);
                    }
                    this.addToBranch(tMod, this.currBranch, 0, isPWave, 1);
                    continue;
                }
                if (nextLeg.startsWith("v")) {
                    disconBranch = this.closestBranchToDepth(tMod, nextLeg.substring(1));
                    if (this.currBranch > disconBranch - 1) throw new TauModelException("Phase not recognized: " + currLeg + " followed by " + nextLeg + " when currBranch=" + this.currBranch + " < disconBranch=" + disconBranch);
                    this.addToBranch(tMod, this.currBranch, disconBranch - 1, isPWave, 2);
                    continue;
                }
                if (nextLeg.startsWith("^")) {
                    disconBranch = this.closestBranchToDepth(tMod, nextLeg.substring(1));
                    if (prevLeg.equals("K")) {
                        this.addToBranch(tMod, this.currBranch, disconBranch, isPWave, 1);
                        continue;
                    }
                    if (prevLeg.startsWith("^") || prevLeg.equals("P") || prevLeg.equals("S") || prevLeg.equals("p") || prevLeg.equals("s") || prevLeg.equals("START")) {
                        this.addToBranch(tMod, this.currBranch, tMod.getCmbBranch() - 1, isPWave, 0);
                        this.addToBranch(tMod, this.currBranch, disconBranch, isPWave, 1);
                        continue;
                    }
                    if (!(prevLeg.startsWith("v") && disconBranch < this.closestBranchToDepth(tMod, prevLeg.substring(1)) || prevLeg.equals("m") && disconBranch < tMod.getMohoBranch()) && (!prevLeg.equals("c") || disconBranch >= tMod.getCmbBranch())) throw new TauModelException("Phase not recognized: " + currLeg + " followed by " + nextLeg + " when currBranch=" + this.currBranch + " > disconBranch=" + disconBranch);
                    this.addToBranch(tMod, this.currBranch, disconBranch, isPWave, 1);
                    continue;
                }
                if (nextLeg.equals("c")) {
                    this.addToBranch(tMod, this.currBranch, tMod.getCmbBranch() - 1, isPWave, 2);
                    continue;
                }
                if (nextLeg.equals("K")) {
                    this.addToBranch(tMod, this.currBranch, tMod.getCmbBranch() - 1, isPWave, 4);
                    continue;
                }
                if (!nextLeg.equals("m") && (!isNextLegDepth || !(nextLegDepth < tMod.getCmbDepth()))) throw new TauModelException("Phase not recognized: " + currLeg + " followed by " + nextLeg);
                disconBranch = this.closestBranchToDepth(tMod, nextLeg);
                if (this.DEBUG) {
                    System.out.println("DisconBranch=" + disconBranch + " for " + nextLeg);
                    System.out.println(tMod.getTauBranch(disconBranch, isPWave).getTopDepth());
                }
                if (this.endAction == 0 || this.endAction == 2 || this.endAction == 3) {
                    if (disconBranch > this.currBranch) {
                        throw new TauModelException("Phase not recognized: " + currLeg + " followed by " + nextLeg + " when currBranch=" + this.currBranch + " > disconBranch=" + disconBranch);
                    }
                    this.addToBranch(tMod, this.currBranch, disconBranch, isPWave, 3);
                    continue;
                }
                String nextNextLeg = this.legs.get(legNum + 2);
                if (nextNextLeg.equals("p") || nextNextLeg.equals("s")) {
                    this.addToBranch(tMod, this.currBranch, tMod.getCmbBranch() - 1, isPWave, 0);
                    this.addToBranch(tMod, this.currBranch, disconBranch, isPWave, 3);
                    continue;
                }
                if (!nextNextLeg.equals("P") && !nextNextLeg.equals("S")) throw new TauModelException("Phase not recognized: " + currLeg + " followed by " + nextLeg + " followed by " + nextNextLeg);
                if (disconBranch > this.currBranch) {
                    this.addToBranch(tMod, this.currBranch, disconBranch - 1, isPWave, 4);
                    continue;
                }
                this.maxRayParam = -1.0;
                if (!this.DEBUG) return;
                System.out.println("Cannot phase convert on the downgoing side if the discontinuity is above the phase leg starting point, " + currLeg + " " + nextLeg + " " + nextNextLeg + ", so this phase, " + this.getName() + " is illegal for this sourceDepth.");
                return;
            }
            if (currLeg.startsWith("P") || currLeg.startsWith("S")) {
                if (currLeg.equals("Pdiff") || currLeg.equals("Sdiff")) {
                    if (this.maxRayParam >= tMod.getTauBranch(tMod.getCmbBranch() - 1, isPWave).getMinTurnRayParam() && this.minRayParam <= tMod.getTauBranch(tMod.getCmbBranch() - 1, isPWave).getMinTurnRayParam()) {
                        this.addToBranch(tMod, this.currBranch, tMod.getCmbBranch() - 1, isPWave, 0);
                        this.maxRayParam = this.minRayParam;
                        if (!nextLeg.equals("END") && !nextLeg.startsWith("P") && !nextLeg.startsWith("S")) continue;
                        this.addToBranch(tMod, this.currBranch, 0, isPWave, 1);
                        continue;
                    }
                    this.maxRayParam = -1.0;
                    if (!this.DEBUG) return;
                    System.out.println("Cannot have the head wave " + currLeg + " within phase " + this.name + " for this sourceDepth and/or path.");
                    return;
                }
                if (!currLeg.equals("Pg") && !currLeg.equals("Sg") && !currLeg.equals("Pn") && !currLeg.equals("Sn")) throw new TauModelException("Phase not recognized: " + currLeg + " followed by " + nextLeg);
                if (this.currBranch >= tMod.getMohoBranch()) {
                    this.maxRayParam = -1.0;
                    if (!this.DEBUG) return;
                    System.out.println("(currBranch >= tMod.getMohoBranch() " + this.currBranch + " " + tMod.getMohoBranch() + " so there cannot be a " + currLeg + " phase for this sourceDepth and/or path.");
                    return;
                }
                if (currLeg.equals("Pg") || currLeg.equals("Sg")) {
                    this.addToBranch(tMod, this.currBranch, tMod.getMohoBranch() - 1, isPWave, 0);
                    this.addToBranch(tMod, this.currBranch, 0, isPWave, 1);
                    continue;
                }
                if (!currLeg.equals("Pn") && !currLeg.equals("Sn")) continue;
                if (this.maxRayParam >= tMod.getTauBranch(tMod.getMohoBranch(), isPWave).getMaxRayParam() && this.minRayParam <= tMod.getTauBranch(tMod.getMohoBranch(), isPWave).getMaxRayParam()) {
                    this.addToBranch(tMod, this.currBranch, tMod.getMohoBranch(), isPWave, 0);
                    this.addToBranch(tMod, this.currBranch, tMod.getMohoBranch(), isPWave, 3);
                    this.minRayParam = this.maxRayParam;
                    if (!nextLeg.equals("END") && !nextLeg.startsWith("P") && !nextLeg.startsWith("S")) continue;
                    this.addToBranch(tMod, this.currBranch, 0, isPWave, 1);
                    continue;
                }
                this.maxRayParam = -1.0;
                if (!this.DEBUG) return;
                System.out.println("Cannot have the head wave " + currLeg + " within phase " + this.name + " for this sourceDepth and/or path.");
                return;
            }
            if (currLeg.equals("K")) {
                if (nextLeg.equals("P") || nextLeg.equals("S")) {
                    if (prevLeg.equals("P") || prevLeg.equals("S") || prevLeg.equals("K") || prevLeg.equals("k") || prevLeg.equals("START")) {
                        this.addToBranch(tMod, this.currBranch, tMod.getIocbBranch() - 1, isPWave, 0);
                    }
                    this.addToBranch(tMod, this.currBranch, tMod.getCmbBranch(), isPWave, 3);
                    continue;
                }
                if (nextLeg.equals("K")) {
                    if (prevLeg.equals("P") || prevLeg.equals("S") || prevLeg.equals("K")) {
                        this.addToBranch(tMod, this.currBranch, tMod.getIocbBranch() - 1, isPWave, 0);
                    }
                    this.addToBranch(tMod, this.currBranch, tMod.getCmbBranch(), isPWave, 1);
                    continue;
                }
                if (nextLeg.equals("I") || nextLeg.equals("J")) {
                    this.addToBranch(tMod, this.currBranch, tMod.getIocbBranch() - 1, isPWave, 4);
                    continue;
                }
                if (!nextLeg.equals("i")) throw new TauModelException("Phase not recognized: " + currLeg + " followed by " + nextLeg);
                this.addToBranch(tMod, this.currBranch, tMod.getIocbBranch() - 1, isPWave, 2);
                continue;
            }
            if (currLeg.equals("I") || currLeg.equals("J")) {
                this.addToBranch(tMod, this.currBranch, tMod.getNumBranches() - 1, isPWave, 0);
                if (nextLeg.equals("I") || nextLeg.equals("J")) {
                    this.addToBranch(tMod, this.currBranch, tMod.getIocbBranch(), isPWave, 1);
                    continue;
                }
                if (!nextLeg.equals("K")) continue;
                this.addToBranch(tMod, this.currBranch, tMod.getIocbBranch(), isPWave, 3);
                continue;
            }
            if (currLeg.equals("m") || currLeg.equals("c") || currLeg.equals("i") || currLeg.startsWith("^") || currLeg.startsWith("v") || isLegDepth) continue;
            throw new TauModelException("Phase not recognized: " + currLeg + " followed by " + nextLeg);
        }
    }

    protected static ArrayList<String> legPuller(String name) throws TauModelException {
        int offset = 0;
        ArrayList<String> legs = new ArrayList<String>();
        if (name.endsWith("kmps")) {
            try {
                legs.add(name);
            }
            catch (NumberFormatException e) {
                throw new TauModelException("Invalid phase name:\n" + name);
            }
        } else {
            while (offset < name.length()) {
                String numString;
                if (name.charAt(offset) == 'K' || name.charAt(offset) == 'I' || name.charAt(offset) == 'k' || name.charAt(offset) == 'J' || name.charAt(offset) == 'p' || name.charAt(offset) == 's' || name.charAt(offset) == 'm' || name.charAt(offset) == 'c' || name.charAt(offset) == 'i') {
                    legs.add(name.substring(offset, offset + 1));
                    ++offset;
                    continue;
                }
                if (name.charAt(offset) == 'P' || name.charAt(offset) == 'S') {
                    if (offset + 1 == name.length() || name.charAt(offset + 1) == 'P' || name.charAt(offset + 1) == 'S' || name.charAt(offset + 1) == 'K' || name.charAt(offset + 1) == 'm' || name.charAt(offset + 1) == 'c' || name.charAt(offset + 1) == '^' || name.charAt(offset + 1) == 'v' || Character.isDigit(name.charAt(offset + 1))) {
                        legs.add(name.substring(offset, offset + 1));
                        ++offset;
                        continue;
                    }
                    if (name.charAt(offset + 1) == 'p' || name.charAt(offset + 1) == 's') {
                        throw new TauModelException("Invalid phase name:\n" + name.charAt(offset) + " cannot be followed by " + name.charAt(offset + 1) + " in " + name);
                    }
                    if (name.charAt(offset + 1) == 'g' || name.charAt(offset + 1) == 'b' || name.charAt(offset + 1) == 'n') {
                        legs.add(name.substring(offset, offset + 2));
                        offset += 2;
                        continue;
                    }
                    if (name.length() >= offset + 5 && (name.substring(offset, offset + 5).equals("Sdiff") || name.substring(offset, offset + 5).equals("Pdiff"))) {
                        legs.add(name.substring(offset, offset + 5));
                        offset += 5;
                        continue;
                    }
                    throw new TauModelException("Invalid phase name:\n" + name.substring(offset) + " in " + name);
                }
                if (name.charAt(offset) == '^' || name.charAt(offset) == 'v') {
                    if (name.charAt(offset + 1) == 'm' || name.charAt(offset + 1) == 'c' || name.charAt(offset + 1) == 'i') {
                        legs.add(name.substring(offset, offset + 2));
                        offset += 2;
                        continue;
                    }
                    if (Character.isDigit(name.charAt(offset + 1)) || name.charAt(offset + 1) == '.') {
                        numString = name.substring(offset, offset + 1);
                        ++offset;
                        while (Character.isDigit(name.charAt(offset)) || name.charAt(offset) == '.') {
                            numString = numString + name.substring(offset, offset + 1);
                            ++offset;
                        }
                        try {
                            legs.add(numString);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new TauModelException("Invalid phase name: " + numString + "\n" + e.getMessage() + " in " + name);
                        }
                    }
                    throw new TauModelException("Invalid phase name:\n" + name.substring(offset) + " in " + name);
                }
                if (Character.isDigit(name.charAt(offset)) || name.charAt(offset) == '.') {
                    numString = name.substring(offset, offset + 1);
                    ++offset;
                    while (Character.isDigit(name.charAt(offset)) || name.charAt(offset) == '.') {
                        numString = numString + name.substring(offset, offset + 1);
                        ++offset;
                    }
                    try {
                        legs.add(numString);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new TauModelException("Invalid phase name: " + numString + "\n" + e.getMessage() + " in " + name);
                    }
                }
                throw new TauModelException("Invalid phase name:\n" + name.substring(offset) + " in " + name);
            }
        }
        legs.add(new String("END"));
        String validationMsg = SeismicPhase.phaseValidate(legs);
        if (validationMsg != null) {
            throw new TauModelException("Phase failed validation: " + name + "  " + validationMsg);
        }
        return legs;
    }

    protected void createPuristName(TauModel tMod) {
        String currLeg = this.legs.get(0);
        if (this.legs.size() == 2 && currLeg.endsWith("kmps")) {
            this.puristName = this.name;
            return;
        }
        this.puristName = "";
        for (int legNum = 0; legNum < this.legs.size() - 1; ++legNum) {
            int intLegDepth;
            double legDepth;
            int disconBranch;
            currLeg = this.legs.get(legNum);
            if (currLeg.startsWith("v") || currLeg.startsWith("^")) {
                disconBranch = this.closestBranchToDepth(tMod, currLeg.substring(1));
                legDepth = tMod.getTauBranch(disconBranch, true).getTopDepth();
                this.puristName = this.puristName + currLeg.substring(0, 1);
                if (legDepth == Math.rint(legDepth)) {
                    intLegDepth = (int)legDepth;
                    this.puristName = this.puristName + intLegDepth;
                    continue;
                }
                this.puristName = this.puristName + legDepth;
                continue;
            }
            try {
                legDepth = new Double(currLeg);
                disconBranch = this.closestBranchToDepth(tMod, currLeg);
                legDepth = tMod.getTauBranch(disconBranch, true).getTopDepth();
                if (legDepth == Math.rint(legDepth)) {
                    intLegDepth = (int)legDepth;
                    this.puristName = this.puristName + intLegDepth;
                    continue;
                }
                this.puristName = this.puristName + legDepth;
                continue;
            }
            catch (NumberFormatException e) {
                this.puristName = this.puristName + currLeg;
            }
        }
    }

    protected void sumBranches(TauModel tMod) throws TauModelException {
        int j;
        int i;
        if (this.maxRayParam < 0.0 || this.minRayParam > this.maxRayParam) {
            this.rayParams = new double[0];
            this.minRayParam = -1.0;
            this.maxRayParam = -1.0;
            this.dist = new double[0];
            this.time = new double[0];
            this.maxDistance = -1.0;
            return;
        }
        if (this.name.endsWith("kmps")) {
            this.dist = new double[2];
            this.time = new double[2];
            this.rayParams = new double[2];
            this.dist[0] = 0.0;
            this.time[0] = 0.0;
            this.rayParams[0] = tMod.radiusOfEarth / Double.valueOf(this.name.substring(0, this.name.length() - 4));
            this.dist[1] = Math.PI * 2;
            this.time[1] = Math.PI * 2 * tMod.radiusOfEarth / Double.valueOf(this.name.substring(0, this.name.length() - 4));
            this.rayParams[1] = this.rayParams[0];
            this.minDistance = 0.0;
            this.maxDistance = Math.PI * 2;
            this.downGoing.add(true);
            return;
        }
        for (int i2 = 0; i2 < tMod.rayParams.length; ++i2) {
            if (tMod.rayParams[i2] >= this.minRayParam) {
                this.minRayParamIndex = i2;
            }
            if (!(tMod.rayParams[i2] >= this.maxRayParam)) continue;
            this.maxRayParamIndex = i2;
        }
        if (this.maxRayParamIndex == 0 && this.minRayParamIndex == tMod.rayParams.length - 1) {
            this.rayParams = new double[tMod.rayParams.length];
            System.arraycopy(tMod.rayParams, 0, this.rayParams, 0, tMod.rayParams.length);
        } else if (this.maxRayParamIndex == this.minRayParamIndex) {
            if (this.name.indexOf("Sdiff") != -1 || this.name.indexOf("Pdiff") != -1) {
                this.rayParams = new double[2];
                this.rayParams[0] = this.minRayParam;
                this.rayParams[1] = this.minRayParam;
            } else if (this.name.indexOf("Pn") != -1 || this.name.indexOf("Sn") != -1) {
                this.rayParams = new double[2];
                this.rayParams[0] = this.minRayParam;
                this.rayParams[1] = this.minRayParam;
            } else if (this.name.endsWith("kmps")) {
                this.rayParams = new double[2];
                this.rayParams[0] = 0.0;
                this.rayParams[1] = this.maxRayParam;
            } else {
                this.rayParams = new double[2];
                this.rayParams[0] = this.minRayParam;
                this.rayParams[1] = this.minRayParam;
            }
        } else {
            if (this.DEBUG) {
                System.out.println("maxRayParamIndex=" + this.maxRayParamIndex + " minRayParamIndex=" + this.minRayParamIndex + " tMod.rayParams.length=" + tMod.rayParams.length + " tMod.rayParams[0]=" + tMod.rayParams[0] + " maxRayParam=" + this.maxRayParam);
            }
            this.rayParams = new double[this.minRayParamIndex - this.maxRayParamIndex + 1];
            System.arraycopy(tMod.rayParams, this.maxRayParamIndex, this.rayParams, 0, this.minRayParamIndex - this.maxRayParamIndex + 1);
        }
        this.dist = new double[this.rayParams.length];
        this.time = new double[this.rayParams.length];
        int[][] timesBranches = new int[2][tMod.getNumBranches()];
        for (i = 0; i < timesBranches[0].length; ++i) {
            timesBranches[0][i] = 0;
            timesBranches[1][i] = 0;
        }
        for (i = 0; i < this.branchSeq.size(); ++i) {
            if (this.waveType.get(i).booleanValue()) {
                int[] nArray = timesBranches[0];
                int n = this.branchSeq.get(i);
                nArray[n] = nArray[n] + 1;
                continue;
            }
            int[] nArray = timesBranches[1];
            int n = this.branchSeq.get(i);
            nArray[n] = nArray[n] + 1;
        }
        for (j = 0; j < tMod.getNumBranches(); ++j) {
            int i3;
            if (timesBranches[0][j] != 0) {
                for (i3 = this.maxRayParamIndex; i3 < this.minRayParamIndex + 1; ++i3) {
                    int n = i3 - this.maxRayParamIndex;
                    this.dist[n] = this.dist[n] + (double)timesBranches[0][j] * tMod.getTauBranch(j, true).getDist(i3);
                    int n2 = i3 - this.maxRayParamIndex;
                    this.time[n2] = this.time[n2] + (double)timesBranches[0][j] * tMod.getTauBranch((int)j, (boolean)true).time[i3];
                }
            }
            if (timesBranches[1][j] == 0) continue;
            for (i3 = this.maxRayParamIndex; i3 < this.minRayParamIndex + 1; ++i3) {
                int n = i3 - this.maxRayParamIndex;
                this.dist[n] = this.dist[n] + (double)timesBranches[1][j] * tMod.getTauBranch(j, false).getDist(i3);
                int n3 = i3 - this.maxRayParamIndex;
                this.time[n3] = this.time[n3] + (double)timesBranches[1][j] * tMod.getTauBranch((int)j, (boolean)false).time[i3];
            }
        }
        if (this.name.indexOf("Sdiff") != -1 || this.name.indexOf("Pdiff") != -1) {
            if (tMod.getSlownessModel().depthInHighSlowness(tMod.cmbDepth - 1.0E-10, this.minRayParam, this.name.charAt(0) == 'P')) {
                this.minRayParam = -1.0;
                this.maxRayParam = -1.0;
                this.maxDistance = -1.0;
                this.dist = new double[0];
                this.time = new double[0];
                this.rayParams = new double[0];
                return;
            }
            this.dist[1] = this.dist[0] + SeismicPhase.getMaxDiffraction() * Math.PI / 180.0;
            this.time[1] = this.time[0] + SeismicPhase.getMaxDiffraction() * Math.PI / 180.0 * this.minRayParam;
        } else if (this.name.indexOf("Pn") != -1 || this.name.indexOf("Sn") != -1) {
            this.dist[1] = this.dist[0] + maxRefraction * Math.PI / 180.0;
            this.time[1] = this.time[0] + maxRefraction * Math.PI / 180.0 * this.minRayParam;
        } else if (this.maxRayParamIndex == this.minRayParamIndex) {
            this.dist[1] = this.dist[0];
            this.time[1] = this.time[0];
        }
        this.minDistance = Double.MAX_VALUE;
        this.maxDistance = 0.0;
        for (j = 0; j < this.dist.length; ++j) {
            if (this.dist[j] < this.minDistance) {
                this.minDistance = this.dist[j];
            }
            if (!(this.dist[j] > this.maxDistance)) continue;
            this.maxDistance = this.dist[j];
        }
        boolean foundOverlap = false;
        boolean isPWave = true;
        for (int dummy = 0; dummy < 2; ++dummy) {
            DepthRange[] hsz = tMod.getSlownessModel().getHighSlowness(isPWave);
            int hSZIndex = 0;
            int indexOffset = 0;
            for (int i4 = 0; i4 < hsz.length; ++i4) {
                int j2;
                if (!(this.maxRayParam > hsz[i4].rayParam) || !(hsz[i4].rayParam > this.minRayParam)) continue;
                int branchNum = tMod.findBranch(hsz[i4].topDepth);
                foundOverlap = false;
                for (int legNum = 0; legNum < this.branchSeq.size(); ++legNum) {
                    if (this.branchSeq.get(legNum) != branchNum || this.waveType.get(legNum) != isPWave || !this.downGoing.get(legNum).booleanValue() || this.branchSeq.get(legNum - 1) != branchNum - 1 || this.waveType.get(legNum - 1) != isPWave || !this.downGoing.get(legNum - 1).booleanValue()) continue;
                    foundOverlap = true;
                    break;
                }
                if (!foundOverlap) continue;
                double[] newdist = new double[this.dist.length + 1];
                double[] newtime = new double[this.time.length + 1];
                double[] newrayParams = new double[this.rayParams.length + 1];
                for (j2 = 0; j2 < this.rayParams.length; ++j2) {
                    if (this.rayParams[j2] != hsz[i4].rayParam) continue;
                    hSZIndex = j2;
                    break;
                }
                System.arraycopy(this.dist, 0, newdist, 0, hSZIndex);
                System.arraycopy(this.time, 0, newtime, 0, hSZIndex);
                System.arraycopy(this.rayParams, 0, newrayParams, 0, hSZIndex);
                newrayParams[hSZIndex] = hsz[i4].rayParam;
                newdist[hSZIndex] = 0.0;
                newtime[hSZIndex] = 0.0;
                for (j2 = 0; j2 < tMod.getNumBranches(); ++j2) {
                    if (timesBranches[0][j2] != 0 && tMod.getTauBranch(j2, true).getTopDepth() < hsz[i4].topDepth) {
                        int n = hSZIndex;
                        newdist[n] = newdist[n] + (double)timesBranches[0][j2] * tMod.getTauBranch((int)j2, (boolean)true).dist[this.maxRayParamIndex + hSZIndex - indexOffset];
                        int n4 = hSZIndex;
                        newtime[n4] = newtime[n4] + (double)timesBranches[0][j2] * tMod.getTauBranch((int)j2, (boolean)true).time[this.maxRayParamIndex + hSZIndex - indexOffset];
                    }
                    if (timesBranches[1][j2] == 0 || !(tMod.getTauBranch(j2, false).getTopDepth() < hsz[i4].topDepth)) continue;
                    int n = hSZIndex;
                    newdist[n] = newdist[n] + (double)timesBranches[1][j2] * tMod.getTauBranch((int)j2, (boolean)false).dist[this.maxRayParamIndex + hSZIndex - indexOffset];
                    int n5 = hSZIndex;
                    newtime[n5] = newtime[n5] + (double)timesBranches[1][j2] * tMod.getTauBranch((int)j2, (boolean)false).time[this.maxRayParamIndex + hSZIndex - indexOffset];
                }
                System.arraycopy(this.dist, hSZIndex, newdist, hSZIndex + 1, this.dist.length - hSZIndex);
                System.arraycopy(this.time, hSZIndex, newtime, hSZIndex + 1, this.time.length - hSZIndex);
                System.arraycopy(this.rayParams, hSZIndex, newrayParams, hSZIndex + 1, this.rayParams.length - hSZIndex);
                ++indexOffset;
                this.dist = newdist;
                this.time = newtime;
                this.rayParams = newrayParams;
            }
            isPWave = false;
        }
    }

    public List<Arrival> calcPierce(double deg) throws TauModelException {
        List<Arrival> arrivals = this.calcTime(deg);
        for (Arrival a : arrivals) {
            this.calcPierce(a);
        }
        return arrivals;
    }

    public Arrival calcPierce(Arrival currArrival) {
        double branchDist = 0.0;
        double branchTime = 0.0;
        double prevBranchTime = 0.0;
        List<TimeDist> pierce = new ArrayList<TimeDist>();
        int rayNum = 0;
        int i = 0;
        while (i < this.tMod.rayParams.length - 1 && this.tMod.rayParams[i] >= currArrival.getRayParam()) {
            rayNum = i++;
        }
        double rayParamA = this.rayParams[currArrival.getRayParamIndex()];
        double rayParamB = this.rayParams[currArrival.getRayParamIndex() + 1];
        double distA = this.dist[currArrival.getRayParamIndex()];
        double distB = this.dist[currArrival.getRayParamIndex() + 1];
        double distRatio = (currArrival.getDist() - distA) / (distB - distA);
        double distRayParam = distRatio * (rayParamB - rayParamA) + rayParamA;
        pierce.add(new TimeDist(distRayParam, 0.0, 0.0, this.tMod.getSourceDepth()));
        for (int i2 = 0; i2 < this.branchSeq.size(); ++i2) {
            double timeB;
            double timeA;
            double turnDepth;
            int branchNum = this.branchSeq.get(i2);
            boolean isPWave = this.waveType.get(i2);
            if (this.DEBUG) {
                System.out.println(i2 + " branchNum =" + branchNum + " downGoing=" + this.downGoing.get(i2) + "  isPWave=" + isPWave);
            }
            try {
                turnDepth = distRayParam > this.tMod.getTauBranch(branchNum, isPWave).getMaxRayParam() ? this.tMod.getTauBranch(branchNum, isPWave).getTopDepth() : (distRayParam <= this.tMod.getTauBranch(branchNum, isPWave).getMinRayParam() ? this.tMod.getTauBranch(branchNum, isPWave).getBotDepth() : (isPWave || this.tMod.getSlownessModel().depthInFluid((this.tMod.getTauBranch(branchNum, isPWave).getTopDepth() + this.tMod.getTauBranch(branchNum, isPWave).getBotDepth()) / 2.0) ? this.tMod.getSlownessModel().findDepth(distRayParam, this.tMod.getTauBranch(branchNum, isPWave).getTopDepth(), this.tMod.getTauBranch(branchNum, isPWave).getBotDepth(), true) : this.tMod.getSlownessModel().findDepth(distRayParam, this.tMod.getTauBranch(branchNum, isPWave).getTopDepth(), this.tMod.getTauBranch(branchNum, isPWave).getBotDepth(), isPWave)));
            }
            catch (SlownessModelException e) {
                throw new RuntimeException("SeismicPhase.calcPierce: Caught SlownessModelException. ", e);
            }
            if (this.name.indexOf("Pdiff") != -1 || this.name.indexOf("Pn") != -1 || this.name.indexOf("Sdiff") != -1 || this.name.indexOf("Sn") != -1) {
                distA = this.tMod.getTauBranch(branchNum, isPWave).getDist(rayNum);
                timeA = this.tMod.getTauBranch((int)branchNum, (boolean)isPWave).time[rayNum];
                distB = this.tMod.getTauBranch(branchNum, isPWave).getDist(rayNum);
                timeB = this.tMod.getTauBranch((int)branchNum, (boolean)isPWave).time[rayNum];
            } else {
                distA = this.tMod.getTauBranch(branchNum, isPWave).getDist(rayNum);
                timeA = this.tMod.getTauBranch((int)branchNum, (boolean)isPWave).time[rayNum];
                distB = this.tMod.getTauBranch(branchNum, isPWave).getDist(rayNum + 1);
                timeB = this.tMod.getTauBranch((int)branchNum, (boolean)isPWave).time[rayNum + 1];
            }
            branchDist += distRatio * (distB - distA) + distA;
            prevBranchTime = branchTime;
            branchTime += distRatio * (timeB - timeA) + timeA;
            double branchDepth = this.downGoing.get(i2) != false ? Math.min(this.tMod.getTauBranch(branchNum, isPWave).getBotDepth(), turnDepth) : Math.min(this.tMod.getTauBranch(branchNum, isPWave).getTopDepth(), turnDepth);
            if (!(Math.abs(prevBranchTime - branchTime) > 1.0E-10)) continue;
            pierce.add(new TimeDist(distRayParam, branchTime, branchDist, branchDepth));
            if (!this.DEBUG) continue;
            System.out.println(" branchTime=" + branchTime + " branchDist=" + branchDist + " branchDepth=" + branchDepth);
            System.out.println("incrementTime = " + distRatio * (timeB - timeA) + " timeB=" + timeB + " timeA=" + timeA);
        }
        if (this.name.indexOf("Pdiff") != -1 || this.name.indexOf("Pn") != -1 || this.name.indexOf("Sdiff") != -1 || this.name.indexOf("Sn") != -1) {
            pierce = this.handleHeadOrDiffractedWave(currArrival, pierce);
        } else if (this.name.indexOf("kmps") != -1) {
            pierce.add(new TimeDist(distRayParam, currArrival.getTime(), currArrival.getDist(), 0.0));
        }
        currArrival.pierce = pierce.toArray(new TimeDist[0]);
        return currArrival;
    }

    List<TimeDist> handleHeadOrDiffractedWave(Arrival currArrival, List<TimeDist> orig) {
        String[] phaseSegments = new String[]{"Pn", "Sn", "Pdiff", "Sdiff"};
        String phaseSeg = "";
        for (int i = 0; i < phaseSegments.length; ++i) {
            if (this.name.indexOf(phaseSegments[i]) == -1) continue;
            phaseSeg = phaseSegments[i];
            break;
        }
        if (phaseSeg.equals("")) {
            throw new RuntimeException("no head/diff segment in " + this.name);
        }
        double headDepth = phaseSeg.equals("Pn") || phaseSeg.equals("Sn") ? this.tMod.getMohoDepth() : this.tMod.getCmbDepth();
        boolean i = false;
        int numFound = 0;
        int indexInString = -1;
        while ((indexInString = this.name.indexOf(phaseSeg, indexInString + 1)) != -1) {
            ++numFound;
        }
        double refractDist = currArrival.getDist() - this.dist[0];
        double refractTime = refractDist * currArrival.getRayParam();
        ArrayList<TimeDist> out = new ArrayList<TimeDist>();
        int j = 0;
        for (TimeDist td : orig) {
            out.add(new TimeDist(td.p, td.time + (double)j * refractTime / (double)numFound, td.distRadian + (double)j * refractDist / (double)numFound, td.depth));
            if (td.depth != headDepth) continue;
            out.add(new TimeDist(td.p, td.time + (double)(++j) * refractTime / (double)numFound, td.distRadian + (double)j * refractDist / (double)numFound, td.depth));
        }
        return out;
    }

    public List<Arrival> calcPath(double deg) {
        List<Arrival> arrivals = this.calcTime(deg);
        for (Arrival a : arrivals) {
            this.calcPath(a);
        }
        return arrivals;
    }

    public Arrival calcPath(Arrival currArrival) {
        ArrayList<TimeDist[]> pathList = new ArrayList<TimeDist[]>();
        TimeDist[] tempTimeDist = new TimeDist[]{new TimeDist(currArrival.getRayParam(), 0.0, 0.0, this.tMod.getSourceDepth())};
        pathList.add(tempTimeDist);
        TimeDist prevTimeDist = tempTimeDist[0];
        for (int i = 0; i < this.branchSeq.size(); ++i) {
            int branchNum = this.branchSeq.get(i);
            boolean isPWave = this.waveType.get(i);
            if (this.DEBUG) {
                System.out.println("i=" + i + " branchNum=" + branchNum + " isPWave=" + isPWave + " downgoing=" + this.downGoing.get(i));
            }
            try {
                tempTimeDist = this.tMod.getTauBranch(branchNum, isPWave).path(currArrival.getRayParam(), this.downGoing.get(i), this.tMod.getSlownessModel());
            }
            catch (SlownessModelException e) {
                throw new RuntimeException("SeismicPhase.calcPath: Caught SlownessModelException. ", e);
            }
            if (tempTimeDist != null) {
                pathList.add(tempTimeDist);
                for (int j = 0; j < tempTimeDist.length; ++j) {
                    if (tempTimeDist[j].getDistDeg() < 0.0) {
                        throw new RuntimeException("Path is backtracking, no possible: " + j + " (" + tempTimeDist[j] + ")");
                    }
                    prevTimeDist = tempTimeDist[j];
                }
            }
            if (branchNum == this.tMod.cmbBranch - 1 && i < this.branchSeq.size() - 1 && this.branchSeq.get(i + 1) == this.tMod.cmbBranch - 1 && (this.name.indexOf("Pdiff") != -1 || this.name.indexOf("Sdiff") != -1)) {
                TimeDist[] diffTD = new TimeDist[]{new TimeDist(currArrival.getRayParam(), (currArrival.getDist() - this.dist[0]) * currArrival.getRayParam(), currArrival.getDist() - this.dist[0], this.tMod.cmbDepth)};
                pathList.add(diffTD);
                continue;
            }
            if (branchNum != this.tMod.mohoBranch - 1 || i >= this.branchSeq.size() - 1 || this.branchSeq.get(i + 1) != this.tMod.mohoBranch - 1 || this.name.indexOf("Pn") == -1 && this.name.indexOf("Sn") == -1) continue;
            int numFound = 0;
            int indexInString = -1;
            while ((indexInString = this.name.indexOf("Pn", indexInString + 1)) != -1) {
                ++numFound;
            }
            while ((indexInString = this.name.indexOf("Sn", indexInString + 1)) != -1) {
                ++numFound;
            }
            TimeDist[] headTD = new TimeDist[]{new TimeDist(currArrival.getRayParam(), (currArrival.getDist() - this.dist[0]) / (double)numFound * currArrival.getRayParam(), (currArrival.getDist() - this.dist[0]) / (double)numFound, this.tMod.mohoDepth)};
            pathList.add(headTD);
        }
        if (this.name.indexOf("kmps") != -1) {
            TimeDist[] headTD = new TimeDist[]{new TimeDist(currArrival.getRayParam(), currArrival.getDist() * currArrival.getRayParam(), currArrival.getDist(), 0.0)};
            pathList.add(headTD);
        }
        int arraySize = 0;
        for (int i = 0; i < pathList.size(); ++i) {
            arraySize += ((TimeDist[])pathList.get(i)).length;
        }
        currArrival.path = new TimeDist[arraySize];
        TimeDist cummulative = new TimeDist(currArrival.getRayParam(), 0.0, 0.0, currArrival.getSourceDepth());
        int numAdded = 0;
        for (int i = 0; i < pathList.size(); ++i) {
            TimeDist[] branchPath = (TimeDist[])pathList.get(i);
            for (int j = 0; j < branchPath.length; ++j) {
                cummulative.add(branchPath[j]);
                cummulative.depth = branchPath[j].depth;
                currArrival.path[numAdded] = (TimeDist)cummulative.clone();
                if (numAdded > 0 && currArrival.path[numAdded].getDistRadian() < currArrival.path[numAdded - 1].getDistRadian()) {
                    throw new RuntimeException("Backtracking ray, not possible: " + numAdded + " " + currArrival.path[numAdded - 1] + ") > (" + currArrival.path[numAdded] + ")");
                }
                ++numAdded;
            }
        }
        return currArrival;
    }

    public String getValidationFailMessage() {
        return this.validationFailMessage;
    }

    public static String phaseValidate(ArrayList<String> legs) {
        String currToken = legs.get(0);
        boolean prevIsReflect = false;
        if (legs.size() == 2 && (currToken.equals("Pdiff") || currToken.equals("Sdiff") || currToken.endsWith("kmps")) && legs.get(1).equals("END")) {
            return null;
        }
        if (!(currToken.equals("Pg") || currToken.equals("Pb") || currToken.equals("Pn") || currToken.equals("Pdiff") || currToken.equals("Sg") || currToken.equals("Sb") || currToken.equals("Sn") || currToken.equals("Sdiff") || currToken.equals("P") || currToken.equals("S") || currToken.equals("p") || currToken.equals("s") || expert && (currToken.equals("K") || currToken.equals("k") || currToken.equals("I")))) {
            String validationFailMessage = "First leg (" + currToken + ") must be one of Pg, Pb, Pn, Pdiff, Sg, Sb, Sn, Sdiff, P, S, p, s";
            if (expert) {
                validationFailMessage = validationFailMessage + ", K, k, I";
            }
            return validationFailMessage;
        }
        for (int i = 1; i < legs.size(); ++i) {
            String prevToken = currToken;
            currToken = legs.get(i);
            if (currToken.startsWith("^") || currToken.startsWith("v") || currToken.equals("m") || currToken.equals("c") || currToken.equals("i")) {
                if (prevIsReflect) {
                    return "Two reflections with no leg in between: " + prevToken + ", " + currToken;
                }
                prevIsReflect = true;
            } else {
                prevIsReflect = false;
            }
            if (prevToken.equals("END")) {
                return "Legs ended but more tokens exist: " + currToken;
            }
            if ((currToken.startsWith("P") || currToken.startsWith("S") || currToken.startsWith("p") || currToken.startsWith("s") || currToken.equals("m") || currToken.equals("c")) && (prevToken.equals("I") || prevToken.equals("J") || prevToken.equals("i"))) {
                return "Cannot have I,J,i followed by P,S,p,s,m,c: " + prevToken + ", " + currToken;
            }
            if ((prevToken.startsWith("P") || prevToken.startsWith("S") || prevToken.startsWith("p") || prevToken.startsWith("s") || prevToken.equals("m") || prevToken.equals("c")) && (currToken.equals("I") || currToken.equals("J") || currToken.equals("i"))) {
                return "Cannot have P,S,p,s,m,c followed by I,J,i: " + prevToken + ", " + currToken;
            }
            if (prevToken.equals("m") && currToken.equals("K")) {
                return "Cannot have m followed by K";
            }
            if (!currToken.equals("m") || !prevToken.equals("K")) continue;
            return "Cannot have K followed by m";
        }
        if (!currToken.equals("END")) {
            return "Last token must be END";
        }
        return null;
    }

    public static Arrival getEarliestArrival(List<SeismicPhase> phases, double degrees) {
        Arrival minArrival = null;
        for (SeismicPhase seismicPhase : phases) {
            seismicPhase.calcTime(degrees);
            Arrival currArrival = seismicPhase.getEarliestArrival(degrees);
            if (currArrival == null || minArrival != null && !(minArrival.getTime() > currArrival.getTime())) continue;
            minArrival = currArrival;
        }
        return minArrival;
    }

    public String toString() {
        int i;
        String desc = this.name + ": ";
        for (i = 0; i < this.legs.size(); ++i) {
            desc = desc + this.legs.get(i) + " ";
        }
        desc = desc + "\n";
        for (i = 0; i < this.branchSeq.size(); ++i) {
            desc = desc + this.branchSeq.get(i) + " ";
        }
        desc = desc + "\n";
        desc = desc + "minRayParam=" + this.minRayParam + " maxRayParam=" + this.maxRayParam;
        desc = desc + "\n";
        desc = desc + "minDistance=" + this.minDistance * 180.0 / Math.PI + " maxDistance=" + this.maxDistance * 180.0 / Math.PI;
        return desc;
    }

    public void dump() {
        for (int j = 0; j < this.dist.length; ++j) {
            System.out.println(j + "  " + this.dist[j] + "  " + this.rayParams[j]);
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length < 3) {
                System.out.println("Usage: SeismicPhase modelfile depth phasename [phasename ...]");
            }
            TauModel tMod = TauModel.readModel(args[0]);
            TauModel tModDepth = tMod.depthCorrect(Double.valueOf(args[1]));
            for (int i = 2; i < args.length; ++i) {
                System.out.println("-----");
                SeismicPhase sp = new SeismicPhase(args[i], tModDepth);
                System.out.println(sp);
                sp.dump();
            }
            System.out.println("-----");
        }
        catch (FileNotFoundException e) {
            System.out.println(e.getMessage());
        }
        catch (OptionalDataException e) {
            System.out.println(e.getMessage());
        }
        catch (StreamCorruptedException e) {
            System.out.println(e.getMessage());
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            System.out.println(e.getMessage());
        }
        catch (TauModelException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }
}

