/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.TauP_Path;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class PropertyLoader {
    protected static String jarFileName = "taup.jar";
    protected static String defaultPropFileName = "defaultProps";
    protected static String packageName = "/edu/sc/seis/TauP";
    protected static String userPropFileName = ".taup";

    public static Properties load() throws IOException {
        Properties defaultProps = new Properties();
        try {
            String classPath = System.getProperty("java.class.path");
            String pathEntry = "";
            int offset = 0;
            Class<?> c = null;
            try {
                c = Class.forName("edu.sc.seis.TauP.PropertyLoader");
            }
            catch (Exception ex) {
                // empty catch block
            }
            InputStream in = c.getResourceAsStream(packageName + "/" + defaultPropFileName);
            if (in != null) {
                defaultProps.load(in);
            } else {
                while (offset < classPath.length()) {
                    ZipFile zippy;
                    ZipEntry zipEntry;
                    File jarFile;
                    int pathSepIndex = classPath.indexOf(File.pathSeparatorChar, offset);
                    if (pathSepIndex != -1) {
                        pathEntry = classPath.substring(offset, pathSepIndex);
                        offset = pathSepIndex + 1;
                    } else {
                        pathEntry = classPath.substring(offset);
                        offset = classPath.length();
                    }
                    if (!pathEntry.endsWith(jarFileName) || !(jarFile = new File(pathEntry)).exists() || !jarFile.isFile() || !jarFile.getName().equals(jarFileName) || !jarFile.canRead() || (zipEntry = (zippy = new ZipFile(jarFile)).getEntry(defaultPropFileName)) == null) continue;
                    defaultProps.load(zippy.getInputStream(zipEntry));
                    zippy.close();
                    offset = classPath.length() + 1;
                }
            }
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        Properties applicationProps = new Properties(defaultProps);
        try {
            applicationProps.load(new FileInputStream(System.getProperty("user.home") + System.getProperty("file.separator") + ".taup"));
        }
        catch (FileNotFoundException ee) {
            // empty catch block
        }
        try {
            applicationProps.load(new FileInputStream(System.getProperty("user.dir") + System.getProperty("file.separator") + ".taup"));
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        String taupPath = "taup.model.path";
        Properties sysProps = System.getProperties();
        if (sysProps.containsKey(taupPath)) {
            if (applicationProps.containsKey(taupPath)) {
                applicationProps.put(taupPath, sysProps.getProperty(taupPath) + sysProps.getProperty("path.separator") + applicationProps.getProperty(taupPath));
            } else {
                applicationProps.put(taupPath, sysProps.getProperty(taupPath));
            }
        }
        if (applicationProps.containsKey("taup.maxRefraction")) {
            SeismicPhase.setMaxRefraction(Double.parseDouble(applicationProps.getProperty("taup.maxRefraction")));
        }
        if (applicationProps.containsKey("taup.maxDiffraction")) {
            SeismicPhase.setMaxDiffraction(Double.parseDouble(applicationProps.getProperty("taup.maxDiffraction")));
        }
        if (applicationProps.containsKey("taup.path.maxPathInc")) {
            TauP_Path.setMaxPathInc(Double.parseDouble(applicationProps.getProperty("taup.path.maxPathInc")));
        }
        return applicationProps;
    }

    public static void save(Properties props) throws IOException {
        PropertyLoader.save(props, ".taup");
    }

    public static void save(Properties props, String filename) throws IOException {
        FileOutputStream propFile = new FileOutputStream(filename);
        props.save(propFile, "---Properties for the TauP toolkit---");
        propFile.close();
    }

    public static void main(String[] args) {
        try {
            Properties props = PropertyLoader.load();
            props.put("Key", "Value and another value");
            PropertyLoader.save(props, "testProperties");
        }
        catch (IOException e) {
            System.out.println("Caught IOException: " + e.getMessage());
        }
    }
}

