/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.earthworm;

import gov.usgs.earthworm.Message;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.wave.Wave;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraceBuf
extends Message {
    public int pin;
    public int numSamples;
    public double startTime;
    public double endTime;
    public double samplingRate;
    public String station;
    public String network;
    public String channel;
    public String location;
    public String dataType;
    public String quality;
    public String pad;
    public int[] data;
    public static final short NULL_SHORT = 32639;
    public static final byte NULL_BYTE = 127;
    public double registrationOffset;
    public boolean isTraceBuf2 = false;

    public TraceBuf() {
    }

    public TraceBuf(byte[] b) throws IOException {
        this.processBytes(new DataInputStream(new ByteArrayInputStream(b)), false);
    }

    protected TraceBuf(byte[] b, int i, int seqLength, int seq) throws IOException {
        super(b, i, seqLength, seq);
    }

    public static TraceBuf createFromBytes(byte[] b, int i, int seqLength, int seq) throws IOException {
        TraceBuf tb = new TraceBuf(b, i, seqLength, seq);
        tb.processBytes(new DataInputStream(new ByteArrayInputStream(tb.bytes)), false);
        return tb;
    }

    public static TraceBuf createFromBytesAsTraceBuf2(byte[] b, int i, int seqLength, int seq) throws IOException {
        TraceBuf tb = new TraceBuf(b, i, seqLength, seq);
        tb.processBytes(new DataInputStream(new ByteArrayInputStream(tb.bytes)), true);
        return tb;
    }

    public TraceBuf(String code, Wave sw) {
        this.data = sw.buffer;
        this.samplingRate = sw.getSamplingRate();
        this.startTime = Util.j2KToEW((double)sw.getStartTime());
        this.endTime = Util.j2KToEW((double)sw.getEndTime()) - 1.0 / this.samplingRate;
        this.pin = -1;
        this.numSamples = this.data.length;
        this.dataType = "s4";
        this.quality = "";
        this.pad = "";
        String[] cc = code.split("\\$");
        this.station = cc[0];
        this.channel = cc[1];
        this.network = cc[2];
        this.location = null;
        if (cc.length >= 4) {
            this.isTraceBuf2 = true;
            this.location = cc[3];
        }
    }

    public void createBytes() {
        try {
            int i;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(baos);
            out.writeInt(this.pin);
            out.writeInt(this.numSamples);
            out.writeDouble(this.startTime);
            out.writeDouble(this.endTime);
            out.writeDouble(this.samplingRate);
            int p = 7 - this.station.length();
            out.writeBytes(this.station);
            for (i = 0; i < p; ++i) {
                out.write(0);
            }
            p = 9 - this.network.length();
            out.writeBytes(this.network);
            for (i = 0; i < p; ++i) {
                out.write(0);
            }
            p = 9 - this.channel.length();
            out.writeBytes(this.channel);
            for (i = 0; i < p; ++i) {
                out.write(0);
            }
            out.writeBytes("s4");
            for (i = 0; i < 5; ++i) {
                out.write(0);
            }
            for (i = 0; i < this.data.length; ++i) {
                out.writeInt(this.data[i]);
            }
            out.write(0);
            this.bytes = baos.toByteArray();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void processBytes(DataInputStream in, boolean traceBuf2) throws IOException {
        boolean swap;
        this.pin = in.readInt();
        this.numSamples = in.readInt();
        this.startTime = in.readDouble();
        this.endTime = in.readDouble();
        this.samplingRate = in.readDouble();
        byte[] buf = new byte[32];
        in.read(buf, 0, 32);
        this.station = Util.bytesToString((byte[])buf, (int)0, (int)7).trim();
        this.network = Util.bytesToString((byte[])buf, (int)7, (int)9).trim();
        if (!traceBuf2) {
            this.channel = Util.bytesToString((byte[])buf, (int)16, (int)9).trim();
            this.location = null;
        } else {
            this.isTraceBuf2 = true;
            this.channel = Util.bytesToString((byte[])buf, (int)16, (int)4).trim();
            this.location = Util.bytesToString((byte[])buf, (int)20, (int)3).trim();
            if (this.location.equals("--")) {
                this.location = null;
            }
        }
        this.dataType = Util.bytesToString((byte[])buf, (int)25, (int)3).trim();
        this.quality = Util.bytesToString((byte[])buf, (int)28, (int)2).trim();
        boolean bl = swap = this.dataType.charAt(0) == 'i';
        if (swap) {
            this.pin = Util.swap((int)this.pin);
            this.numSamples = Util.swap((int)this.numSamples);
            this.startTime = Util.swap((double)this.startTime);
            this.endTime = Util.swap((double)this.endTime);
            this.samplingRate = Util.swap((double)this.samplingRate);
        }
        boolean isShort = this.dataType.charAt(1) == '2';
        this.data = new int[this.numSamples];
        for (int i = 0; i < this.numSamples; ++i) {
            this.data[i] = isShort ? (int)(swap ? Util.swap((short)in.readShort()) : in.readShort()) : (swap ? Util.swap((int)in.readInt()) : in.readInt());
        }
    }

    public void register() {
        double n = this.startTime;
        double m = 1.0 / this.samplingRate;
        double dif = n % m;
        this.registrationOffset = dif >= m / 2.0 ? m - dif : -dif;
        this.startTime += this.registrationOffset;
    }

    public static Wave traceBufToWave(List<TraceBuf> tbs, boolean register) {
        if (tbs == null) {
            return null;
        }
        TraceBuf tp1 = tbs.get(0);
        TraceBuf tpn = tbs.get(tbs.size() - 1);
        double offset = 0.0;
        if (register) {
            tp1.register();
            offset = tp1.registrationOffset;
            tpn.register();
        }
        double samplingRate = tp1.samplingRate;
        double startTime = tp1.startTime;
        double endTime = tpn.startTime + (double)(tpn.numSamples * 1) / samplingRate;
        int bins = (int)Math.round((endTime - startTime) * samplingRate);
        int[] buffer = new int[bins];
        Arrays.fill(buffer, Wave.NO_DATA);
        double range = endTime - startTime;
        for (TraceBuf tp : tbs) {
            int si;
            if (Math.abs(tp.samplingRate - samplingRate) > 1.0E-5) continue;
            if (register) {
                tp.register();
            }
            if ((si = (int)Math.round((tp.startTime - startTime) / range * (double)bins)) < 0) {
                System.out.println("Error in traceBufToWave");
                System.out.println(tp);
                System.out.println("bins: " + bins);
                System.out.println("range: " + range);
                System.out.println("startTime: " + startTime);
                System.out.println("endTime: " + endTime);
                System.out.println("si: " + si);
                continue;
            }
            for (int j = 0; j < tp.numSamples; ++j) {
                buffer[si++] = tp.data[j];
            }
        }
        Wave wave = new Wave(buffer, startTime, samplingRate);
        wave.setRegistrationOffset(offset);
        return wave;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public double getStartTimeJ2K() {
        return this.startTime - 9.46728E8;
    }

    public double getEndTime() {
        return this.endTime + 1.0 / this.samplingRate;
    }

    public double getEndTimeJ2K() {
        return this.getEndTime() - 9.46728E8;
    }

    public Date getStartTimeDate() {
        return Util.j2KToDate((double)this.getStartTimeJ2K());
    }

    @Override
    public String toString() {
        return (this.isTraceBuf2 ? "TYPE_TRACEBUF2" : "TYPE_TRACEBUF") + ": " + this.station + " " + this.channel + " " + this.network + ", " + this.startTime + "->" + this.endTime + "," + this.dataType + " " + this.quality + " " + this.numSamples;
    }

    public String toLogString() {
        String loc = "--";
        if (this.isTraceBuf2 && this.location != null) {
            loc = this.location;
        }
        return String.format("TRACEBUF%s: %s %s %s %s, %d, %s, %.2f", this.isTraceBuf2 ? "2" : "", this.station, this.channel, this.network, loc, this.numSamples, this.dataType, this.startTime);
    }

    public String toWinstonString() {
        String code = this.station + "$" + this.channel + "$" + this.network;
        if (this.isTraceBuf2 && this.location != null) {
            return code + "$" + this.location;
        }
        return code;
    }

    public ByteBuffer toByteBuffer() {
        int i;
        ByteBuffer bb = ByteBuffer.allocate(64 + 4 * this.data.length);
        bb.putInt(this.pin);
        bb.putInt(this.numSamples);
        bb.putDouble(this.startTime);
        bb.putDouble(this.endTime);
        bb.putDouble(this.samplingRate);
        bb.put(this.station.getBytes());
        for (i = this.station.length(); i < 7; ++i) {
            bb.put((byte)0);
        }
        bb.put(this.network.getBytes());
        for (i = this.network.length(); i < 9; ++i) {
            bb.put((byte)0);
        }
        bb.put(this.channel.getBytes());
        for (i = this.channel.length(); i < 9; ++i) {
            bb.put((byte)0);
        }
        bb.put(this.dataType.getBytes());
        for (i = this.dataType.length(); i < 3; ++i) {
            bb.put((byte)0);
        }
        bb.put((byte)0);
        bb.put((byte)0);
        bb.put((byte)0);
        bb.put((byte)0);
        for (i = 0; i < this.data.length; ++i) {
            bb.putInt(this.data[i]);
        }
        bb.flip();
        return bb;
    }
}

