/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.earthworm;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.io.File;
import java.io.FileOutputStream;
import javax.imageio.ImageIO;

public class SgramToRaw {
    private int x = 51;
    private int y = 65;
    private int xSize = 599;
    private int ySize = 1439;
    private boolean leftToRight = true;
    private boolean upToDown = false;

    public void setup(int _x, int _y, int xs, int ys, boolean lr, boolean ud) {
        this.x = _x;
        this.y = _y;
        this.xSize = xs;
        this.ySize = ys;
        this.leftToRight = lr;
        this.upToDown = ud;
    }

    public synchronized void convert(String fn, String outfn) {
        try {
            BufferedImage img = ImageIO.read(new File(fn));
            Raster r = img.getData(new Rectangle(this.x, this.y, this.xSize, this.ySize));
            DataBufferByte dbb = (DataBufferByte)r.getDataBuffer();
            byte[] b = dbb.getData();
            byte[] bytes = new byte[b.length];
            int di = 0;
            if (this.leftToRight) {
                for (int sx = 0; sx < this.xSize; ++sx) {
                    int sy;
                    if (this.upToDown) {
                        for (sy = 0; sy < this.ySize; ++sy) {
                            bytes[di++] = b[sy * this.xSize + sx];
                        }
                        continue;
                    }
                    for (sy = this.ySize - 1; sy >= 0; --sy) {
                        bytes[di++] = b[sy * this.xSize + sx];
                    }
                }
            } else {
                for (int sx = this.xSize - 1; sx >= 0; --sx) {
                    int sy;
                    if (this.upToDown) {
                        for (sy = 0; sy < this.ySize; ++sy) {
                            bytes[di++] = b[sy * this.xSize + sx];
                        }
                        continue;
                    }
                    for (sy = this.ySize - 1; sy >= 0; --sy) {
                        bytes[di++] = b[sy * this.xSize + sx];
                    }
                }
            }
            FileOutputStream fos = new FileOutputStream(outfn);
            fos.write(bytes, 0, bytes.length);
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            boolean error = false;
            if (args.length == 2 || args.length == 8) {
                SgramToRaw sgtr = new SgramToRaw();
                if (args.length == 8) {
                    sgtr.setup(Integer.parseInt(args[2]), Integer.parseInt(args[3]), Integer.parseInt(args[4]), Integer.parseInt(args[5]), args[6].equals("1"), args[7].equals("1"));
                }
                if (args[0].equals("-f")) {
                    String fn = args[1];
                    String ofn = fn.substring(0, fn.length() - 3) + "dat";
                    sgtr.convert(fn, ofn);
                } else if (args[0].equals("-d")) {
                    String dn = args[1];
                    File[] files = new File(dn).listFiles();
                    for (int i = 0; i < files.length; ++i) {
                        String ifn = files[i].getPath();
                        if (!ifn.endsWith(".gif")) continue;
                        String ofn = ifn.substring(0, ifn.length() - 3) + "dat";
                        sgtr.convert(ifn, ofn);
                    }
                } else {
                    error = true;
                }
            } else {
                error = true;
            }
            if (error) {
                System.out.println("java gov.usgs.earthworm.SgramToRaw <-f|d> <filename|directory> [x y sx sy ud lr]");
                System.out.println("");
                System.out.println("-f -- convert one file");
                System.out.println("-d -- convert all .gif files in a directory");
                System.out.println("");
                System.out.println("If more options are specified they must all be specified:");
                System.out.println("   x: the x coordinate of the upper left corner");
                System.out.println("   y: the y coordinate of the upper left corner");
                System.out.println("  sx: the x size of the spectrogram");
                System.out.println("  sy: the y size of the spectrogram");
                System.out.println("  ud: whether to go up-to-down [1] or down-to-up [0]");
                System.out.println("  lr: whether to go left-to-right [1] or right-to-left [0]");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

