/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.earthworm;

import gov.usgs.earthworm.Message;
import gov.usgs.earthworm.MessageLogo;
import gov.usgs.earthworm.TraceBuf;
import java.io.IOException;

public class MessageFactory {
    public static Message createMessage(byte[] b, int i, boolean findSeq) throws IOException {
        String s;
        int seq = -1;
        int seqLength = 0;
        if (findSeq && (s = new String(b, 0, 6)).startsWith("SQ:")) {
            seq = Integer.parseInt(s.substring(3, 6).trim());
            seqLength = 6;
        }
        MessageLogo logo = new MessageLogo(b, seqLength);
        Message msg = null;
        switch (logo.type) {
            case 20: {
                msg = TraceBuf.createFromBytes(b, i, seqLength, seq);
                break;
            }
            case 19: {
                msg = TraceBuf.createFromBytesAsTraceBuf2(b, i, seqLength, seq);
                break;
            }
            case 3: {
                msg = new Message(b, i, seqLength, seq);
                break;
            }
            default: {
                msg = new Message(b, i, seqLength, seq);
            }
        }
        return msg;
    }

    public static Message createMessage(byte[] b, int i) throws IOException {
        return MessageFactory.createMessage(b, i, false);
    }
}

