/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.earthworm;

import gov.usgs.earthworm.MessageLogo;

public class Message {
    public MessageLogo logo;
    public int seq;
    public boolean sendAck;
    public byte[] bytes;

    public Message() {
    }

    public Message(byte[] b, int i) {
        this(b, i, false);
    }

    public Message(byte[] b, int i, boolean findSeq) {
        String s;
        int seqLength = 0;
        int logoLength = 9;
        if (findSeq && (s = new String(b, 0, 6)).startsWith("SQ:")) {
            this.seq = Integer.parseInt(s.substring(3, 5));
            seqLength = 6;
            this.sendAck = true;
        }
        this.logo = new MessageLogo(b, seqLength);
        int preambleLength = seqLength + logoLength;
        this.bytes = new byte[i - preambleLength];
        System.arraycopy(b, preambleLength, this.bytes, 0, this.bytes.length);
    }

    public Message(byte[] b, int i, int seqLength, int s) {
        int logoLength = 9;
        this.seq = s;
        this.logo = new MessageLogo(b, seqLength);
        int preambleLength = seqLength + logoLength;
        this.bytes = new byte[i - preambleLength];
        System.arraycopy(b, preambleLength, this.bytes, 0, this.bytes.length);
    }

    public String toString() {
        return this.logo.toString() + " length=" + this.bytes.length;
    }

    public String bytesToString() {
        return new String(this.bytes);
    }
}

