/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl.util.fft;

import com.nativelibs4java.opencl.CLBuffer;
import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLEvent;
import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.opencl.CLPlatform;
import com.nativelibs4java.opencl.CLQueue;
import com.nativelibs4java.opencl.JavaCL;
import com.nativelibs4java.opencl.util.fft.AbstractFFTPow2;
import com.nativelibs4java.opencl.util.fft.DoubleFFTProgram;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleFFTPow2
extends AbstractFFTPow2<Double, double[]> {
    final DoubleFFTProgram program;

    public DoubleFFTPow2(CLContext context) throws IOException, CLException {
        super(context, Double.class);
        this.program = new DoubleFFTProgram(context);
        this.program.getProgram().setFastRelaxedMath();
    }

    public DoubleFFTPow2() throws IOException {
        this(JavaCL.createBestContext((CLPlatform.DeviceFeature[])new CLPlatform.DeviceFeature[]{CLPlatform.DeviceFeature.DoubleSupport}));
    }

    @Override
    protected CLEvent cooleyTukeyFFTTwiddleFactors(CLQueue queue, int N, CLBuffer<Double> buf, CLEvent ... evts) throws CLException {
        return this.program.cooleyTukeyFFTTwiddleFactors(queue, N, buf, new int[]{N / 2}, null, evts);
    }

    @Override
    protected CLEvent cooleyTukeyFFTCopy(CLQueue queue, CLBuffer<Double> inBuf, CLBuffer<Double> outBuf, int length, CLBuffer<Integer> offsetsBuf, boolean inverse, CLEvent ... evts) throws CLException {
        return this.program.cooleyTukeyFFTCopy(queue, inBuf, outBuf, length, offsetsBuf, inverse ? 1.0 / (double)length : 1.0, new int[]{length}, null, evts);
    }

    @Override
    protected CLEvent cooleyTukeyFFT(CLQueue queue, CLBuffer<Double> Y, int N, CLBuffer<Double> twiddleFactors, int inverse, int[] dims, CLEvent ... evts) throws CLException {
        return this.program.cooleyTukeyFFT(queue, Y, N, twiddleFactors, inverse, dims, null, evts);
    }
}

