/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl.util;

import com.nativelibs4java.opencl.CLBuffer;
import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLEvent;
import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.opencl.CLMem;
import com.nativelibs4java.opencl.CLQueue;
import org.bridj.Pointer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Transformer<T, A> {
    public CLContext getContext();

    public A transform(CLQueue var1, A var2, boolean var3);

    public Pointer<T> transform(CLQueue var1, Pointer<T> var2, boolean var3);

    public CLEvent transform(CLQueue var1, CLBuffer<T> var2, CLBuffer<T> var3, boolean var4, CLEvent ... var5) throws CLException;

    public long computeOutputSize(long var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractTransformer<T, A>
    implements Transformer<T, A> {
        protected final Class<T> primitiveClass;
        protected final CLContext context;

        public AbstractTransformer(CLContext context, Class<T> primitiveClass) {
            this.primitiveClass = primitiveClass;
            this.context = context;
        }

        @Override
        public CLContext getContext() {
            return this.context;
        }

        @Override
        public long computeOutputSize(long inputSize) {
            return inputSize;
        }

        @Override
        public A transform(CLQueue queue, A input, boolean inverse) {
            return (A)this.transform(queue, Pointer.pointerToArray(input), inverse).getArray();
        }

        @Override
        public Pointer<T> transform(CLQueue queue, Pointer<T> in, boolean inverse) {
            long inputSize = (int)in.getValidElements();
            long length = inputSize / 2L;
            CLBuffer inBuf = this.context.createBuffer(CLMem.Usage.Input, in, true);
            CLBuffer outBuf = this.context.createBuffer(CLMem.Usage.Output, this.primitiveClass, this.computeOutputSize(inputSize));
            CLEvent dftEvt = this.transform(queue, inBuf, outBuf, inverse, new CLEvent[0]);
            inBuf.release();
            Pointer out = outBuf.read(queue, new CLEvent[]{dftEvt});
            outBuf.release();
            return out;
        }
    }
}

