/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl.util;

import com.nativelibs4java.opencl.CLBuffer;
import com.nativelibs4java.opencl.CLBuildException;
import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLDevice;
import com.nativelibs4java.opencl.CLEvent;
import com.nativelibs4java.opencl.CLMem;
import com.nativelibs4java.opencl.CLQueue;
import com.nativelibs4java.opencl.JavaCL;
import com.nativelibs4java.opencl.util.XORShiftRandom;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bridj.Pointer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelRandom {
    protected final XORShiftRandom randomProgram;
    protected final CLQueue queue;
    protected final CLContext context;
    protected final int parallelSize;
    protected final int[] globalWorkSizes;
    protected int consumedInts = 0;
    boolean preload;
    CLEvent preloadEvent;
    protected CLBuffer<Integer> seeds;
    protected CLBuffer<Integer> output;
    Pointer<Integer> lastData;
    boolean isDataFresh;
    static final int floatMask = 0xFFFFFF;
    static final double floatDivid = 1.6777216E7;
    private static final int intSignMask = Integer.MIN_VALUE;
    private static final int doubleMask = 0x7FFFFFF;
    private static final double doubleDivid = 9.007199254740992E15;

    public ParallelRandom() throws IOException {
        this(JavaCL.createBestContext().createDefaultQueue(new CLDevice.QueueProperties[0]), 32768, System.currentTimeMillis());
    }

    public ParallelRandom(CLQueue queue, int parallelSize, long seed) throws IOException {
        try {
            this.queue = queue;
            this.context = queue.getContext();
            this.randomProgram = new XORShiftRandom(this.context);
            this.parallelSize = parallelSize;
            int seedsNeededByWorkItem = 4;
            int maxUnits = queue.getDevice().getMaxComputeUnits();
            int unitsFactor = maxUnits < 10 ? 1 : 16;
            int scheduledWorkItems = maxUnits * unitsFactor;
            if (scheduledWorkItems > parallelSize / seedsNeededByWorkItem) {
                scheduledWorkItems = parallelSize / seedsNeededByWorkItem;
                scheduledWorkItems += parallelSize % seedsNeededByWorkItem;
            }
            this.globalWorkSizes = new int[]{scheduledWorkItems};
            this.randomProgram.getProgram().defineMacro("NUMBERS_COUNT", (Object)parallelSize);
            this.randomProgram.getProgram().defineMacro("WORK_ITEMS_COUNT", (Object)scheduledWorkItems);
            int nSeeds = seedsNeededByWorkItem * parallelSize;
            Pointer seedsBuf = Pointer.allocateInts((long)nSeeds).order(this.context.getKernelsDefaultByteOrder());
            this.initSeeds((Pointer<Integer>)seedsBuf, seed);
            this.seeds = this.context.createBuffer(CLMem.Usage.InputOutput, seedsBuf, true);
            this.output = this.context.createBuffer(CLMem.Usage.Output, Integer.class, (long)parallelSize);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(ParallelRandom.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException("Failed to initialized parallel random", ex);
        }
    }

    public int nextInt() {
        this.waitForData(1);
        return (Integer)this.lastData.get((long)this.consumedInts++);
    }

    public synchronized boolean isPreload() {
        return this.preload;
    }

    public synchronized void setPreload(boolean preload) throws CLBuildException {
        this.preload = preload;
        if (preload && this.preloadEvent == null) {
            if (this.lastData == null) {
                this.preloadEvent = this.randomProgram.gen_numbers(this.queue, this.seeds, this.output, this.globalWorkSizes, null, new CLEvent[0]);
            } else if (this.consumedInts > 0) {
                this.preload();
            }
        }
    }

    private synchronized CLEvent preload() throws CLBuildException {
        this.preloadEvent = this.randomProgram.gen_numbers(this.queue, this.seeds, this.output, this.globalWorkSizes, null, this.preloadEvent);
        return this.preloadEvent;
    }

    private synchronized void waitForData(int n) {
        try {
            if (this.lastData == null) {
                if (this.preloadEvent == null) {
                    this.preloadEvent = this.randomProgram.gen_numbers(this.queue, this.seeds, this.output, this.globalWorkSizes, null, new CLEvent[0]);
                }
                this.readLastOutputData();
            }
            if (this.consumedInts > this.parallelSize - n) {
                this.preload().waitFor();
                this.consumedInts = 0;
                this.readLastOutputData();
            }
            if (this.preload && this.preloadEvent == null) {
                this.preload();
            }
        }
        catch (CLBuildException ex) {
            throw new RuntimeException(ex);
        }
    }

    private synchronized void readLastOutputData() {
        if (this.lastData == null) {
            this.lastData = this.output.read(this.queue, new CLEvent[]{this.preloadEvent});
        } else {
            this.output.read(this.queue, this.lastData, true, new CLEvent[]{this.preloadEvent});
        }
        this.preloadEvent = null;
    }

    public long nextLong() {
        return (long)this.nextInt() << 32 | (long)this.nextInt();
    }

    public int nextInt(int n) {
        int val;
        int bits;
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        if ((n & -n) == n) {
            return (int)((long)n * (long)(this.nextInt() & Integer.MIN_VALUE) >> 31);
        }
        while ((bits = this.nextInt() & Integer.MIN_VALUE) - (val = bits % n) + (n - 1) < 0) {
        }
        return val;
    }

    public float nextFloat() {
        return (float)((double)(this.nextInt() & 0xFFFFFF) / 1.6777216E7);
    }

    public double nextDouble() {
        return (double)((long)(this.nextInt() & 0x7FFFFFF) << 27 | (long)(this.nextInt() & 0x7FFFFFF)) / 9.007199254740992E15;
    }

    public CLBuffer<Integer> getSeeds() {
        return this.seeds;
    }

    public CLQueue getQueue() {
        return this.queue;
    }

    public int getParallelSize() {
        return this.parallelSize;
    }

    public synchronized CLEvent doNext() {
        try {
            return this.randomProgram.gen_numbers(this.queue, this.seeds, this.output, this.globalWorkSizes, null, new CLEvent[0]);
        }
        catch (CLBuildException ex) {
            Logger.getLogger(ParallelRandom.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException("Failed to compile the random number generation routine", ex);
        }
    }

    public synchronized void next(Pointer<Integer> output) {
        CLEvent evt = this.doNext();
        this.output.read(this.queue, output, true, new CLEvent[]{evt});
    }

    public synchronized Pointer<Integer> next() {
        CLEvent evt = this.doNext();
        return this.output.read(this.queue, new CLEvent[]{evt});
    }

    private void initSeeds(final Pointer<Integer> seedsBuf, final long seed) throws InterruptedException {
        boolean parallelize;
        final long nSeeds = seedsBuf.getValidElements();
        long start = System.nanoTime();
        boolean bl = parallelize = nSeeds > 10000L;
        if (parallelize) {
            Random random = new Random(seed);
            long i = nSeeds;
            while (i-- != 0L) {
                seedsBuf.set(i, (Object)random.nextInt());
            }
        } else {
            final int nThreads = Runtime.getRuntime().availableProcessors();
            ExecutorService service = Executors.newFixedThreadPool(nThreads);
            int i = 0;
            while (i < nThreads) {
                final int iThread = i++;
                service.execute(new Runnable(){

                    public void run() {
                        long n = nSeeds / (long)nThreads;
                        long offset = n * (long)iThread;
                        Random random = new Random(seed + (long)iThread);
                        if (iThread == nThreads - 1) {
                            n += nSeeds - n * (long)nThreads;
                        }
                        long i = n;
                        while (i-- != 0L) {
                            seedsBuf.set(offset++, (Object)random.nextInt());
                        }
                    }
                });
            }
            service.shutdown();
            service.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        long time = System.nanoTime() - start;
        Logger.getLogger(ParallelRandom.class.getName()).log(Level.INFO, "Initialization of " + nSeeds + " seeds took " + time / 1000000L + " ms (" + (double)time / (double)nSeeds + " ns per seed)");
    }
}

