/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl.util;

import com.nativelibs4java.opencl.CLBuffer;
import com.nativelibs4java.opencl.CLBuildException;
import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLDevice;
import com.nativelibs4java.opencl.CLEvent;
import com.nativelibs4java.opencl.CLPlatform;
import com.nativelibs4java.opencl.CLQueue;
import com.nativelibs4java.opencl.JavaCL;
import com.nativelibs4java.opencl.util.LinearAlgebraKernels;
import com.nativelibs4java.opencl.util.OpenCLType;
import com.nativelibs4java.opencl.util.ReductionUtils;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinearAlgebraUtils {
    final LinearAlgebraKernels kernels;
    final CLQueue queue;
    ReductionUtils.Reductor<Double> addReductorDouble;
    ReductionUtils.Reductor<Float> addReductorFloat;

    public LinearAlgebraUtils(boolean doubleCapable) throws IOException, CLBuildException {
        this(JavaCL.createBestContext((CLPlatform.DeviceFeature[])new CLPlatform.DeviceFeature[]{doubleCapable ? CLPlatform.DeviceFeature.DoubleSupport : null}).createDefaultQueue(new CLDevice.QueueProperties[0]));
    }

    public LinearAlgebraUtils(CLQueue queue) throws IOException, CLBuildException {
        this.queue = queue;
        this.kernels = new LinearAlgebraKernels(queue.getContext());
    }

    public CLContext getContext() {
        return this.getQueue().getContext();
    }

    public CLQueue getQueue() {
        return this.queue;
    }

    public synchronized <T> CLEvent multiply(CLBuffer<T> a, int aRows, int aColumns, CLBuffer<T> b, int bRows, int bColumns, CLBuffer<T> out, CLEvent ... eventsToWaitFor) throws CLBuildException {
        if (a.getElementClass() == Double.class) {
            return this.multiplyDoubles(a, aRows, aColumns, b, bRows, bColumns, out, eventsToWaitFor);
        }
        if (a.getElementClass() == Float.class) {
            return this.multiplyFloats(a, aRows, aColumns, b, bRows, bColumns, out, eventsToWaitFor);
        }
        throw new UnsupportedOperationException();
    }

    public synchronized CLEvent multiplyDoubles(CLBuffer<Double> a, int aRows, int aColumns, CLBuffer<Double> b, int bRows, int bColumns, CLBuffer<Double> out, CLEvent ... eventsToWaitFor) throws CLBuildException {
        if (a == null || b == null || out == null) {
            throw new IllegalArgumentException("Null matrix");
        }
        if (aColumns != bRows || out.getElementCount() != (long)(aRows * bColumns)) {
            throw new IllegalArgumentException("Invalid matrix sizes : multiplying matrices of sizes (A, B) and (B, C) requires output of size (A, C)");
        }
        long outRows = aRows;
        long outColumns = bColumns;
        return this.kernels.mulMatDouble(this.queue, a, aColumns, b, bColumns, out, new int[]{(int)outRows, (int)outColumns}, null, eventsToWaitFor);
    }

    public synchronized CLEvent multiplyFloats(CLBuffer<Float> a, long aRows, long aColumns, CLBuffer<Float> b, long bRows, long bColumns, CLBuffer<Float> out, CLEvent ... eventsToWaitFor) throws CLBuildException {
        long outRows = aRows;
        long outColumns = bColumns;
        return this.kernels.mulMatFloat(this.queue, a, (int)aColumns, b, (int)bColumns, out, new int[]{(int)outRows, (int)outColumns}, null, eventsToWaitFor);
    }

    synchronized ReductionUtils.Reductor<Double> getAddReductorDouble() {
        if (this.addReductorDouble == null) {
            try {
                this.addReductorDouble = ReductionUtils.createReductor(this.getContext(), ReductionUtils.Operation.Add, OpenCLType.Double, 1);
            }
            catch (CLBuildException ex) {
                Logger.getLogger(LinearAlgebraUtils.class.getName()).log(Level.SEVERE, null, ex);
                throw new RuntimeException("Failed to create an addition reductor !", ex);
            }
        }
        return this.addReductorDouble;
    }

    public synchronized CLEvent transposeDouble(CLBuffer<Double> a, int aRows, int aColumns, CLBuffer<Double> out, CLEvent ... eventsToWaitFor) throws CLBuildException {
        return this.kernels.transposeDouble(this.queue, a, aRows, aColumns, out, new int[]{aColumns, aRows}, null, eventsToWaitFor);
    }

    synchronized ReductionUtils.Reductor<Float> getAddReductorFloat() {
        if (this.addReductorFloat == null) {
            try {
                this.addReductorFloat = ReductionUtils.createReductor(this.getContext(), ReductionUtils.Operation.Add, OpenCLType.Float, 1);
            }
            catch (CLBuildException ex) {
                Logger.getLogger(LinearAlgebraUtils.class.getName()).log(Level.SEVERE, null, ex);
                throw new RuntimeException("Failed to create an addition reductor !", ex);
            }
        }
        return this.addReductorFloat;
    }

    public synchronized <T> CLEvent transpose(CLBuffer<T> a, int aRows, int aColumns, CLBuffer<T> out, CLEvent ... eventsToWaitFor) throws CLBuildException {
        if (a.getElementClass() == Double.class) {
            return this.transposeDoubles(a, aRows, aColumns, out, eventsToWaitFor);
        }
        if (a.getElementClass() == Float.class) {
            return this.transposeFloats(a, aRows, aColumns, out, eventsToWaitFor);
        }
        throw new UnsupportedOperationException();
    }

    public synchronized CLEvent transposeFloats(CLBuffer<Float> a, int aRows, int aColumns, CLBuffer<Float> out, CLEvent ... eventsToWaitFor) throws CLBuildException {
        return this.kernels.transposeFloat(this.queue, a, aRows, aColumns, out, new int[]{aColumns, aRows}, null, eventsToWaitFor);
    }

    public synchronized CLEvent transposeDoubles(CLBuffer<Double> a, int aRows, int aColumns, CLBuffer<Double> out, CLEvent ... eventsToWaitFor) throws CLBuildException {
        return this.kernels.transposeDouble(this.queue, a, aRows, aColumns, out, new int[]{aColumns, aRows}, null, eventsToWaitFor);
    }
}

