/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.server;

import gov.usgs.net.Server;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Log;
import gov.usgs.util.Util;
import gov.usgs.vdx.server.ServerHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Set;
import java.util.logging.Level;

public class VDX
extends Server {
    protected String configFilename = "VDX.config";
    protected int numHandlers;
    private String driver;
    private String url;
    private String prefix;

    public VDX(String cf) {
        this.name = "VDX";
        this.logger = Log.getLogger((String)"gov.usgs.vdx");
        String[] version = Util.getVersion((String)"gov.usgs.vdx");
        if (version != null) {
            this.logger.info("Version: " + version[0] + " Built: " + version[1]);
        } else {
            this.logger.info("No version information available.");
        }
        if (cf != null) {
            this.configFilename = cf;
        }
        this.processConfigFile();
        for (int i = 0; i < this.numHandlers; ++i) {
            this.addCommandHandler(new ServerHandler(this));
        }
        this.startListening();
    }

    protected void fatalError(String msg) {
        this.logger.severe(msg);
        System.exit(1);
    }

    public void processConfigFile() {
        int l;
        ConfigFile cf = new ConfigFile(this.configFilename);
        if (!cf.wasSuccessfullyRead()) {
            this.fatalError(this.configFilename + ": could not read config file.");
        }
        if ((l = Util.stringToInt((String)cf.getString("vdx.logLevel"), (int)-1)) > 1) {
            this.logger.setLevel(Level.ALL);
        } else {
            this.logger.setLevel(Level.INFO);
        }
        this.logger.info("config: vdx.logLevel=" + l + ".");
        int p = Util.stringToInt((String)cf.getString("vdx.port"), (int)-1);
        if (p < 0 || p > 65535) {
            this.fatalError(this.configFilename + ": bad or missing 'vdx.port' setting.");
        }
        this.port = p;
        this.logger.info("config: vdx.port=" + this.port + ".");
        int h = Util.stringToInt((String)cf.getString("vdx.handlers"), (int)-1);
        if (h < 1 || h > 128) {
            this.fatalError(this.configFilename + ": bad or missing 'vdx.handlers' setting.");
        }
        this.numHandlers = h;
        this.logger.info("config: vdx.handlers=" + this.numHandlers + ".");
        this.driver = cf.getString("vdx.driver");
        if (this.driver == null) {
            this.fatalError(this.configFilename + ": bad or missing 'vdx.driver' setting.");
        }
        this.logger.info("config: vdx.driver=" + this.driver + ".");
        this.url = cf.getString("vdx.url");
        if (this.url == null) {
            this.fatalError(this.configFilename + ": bad or missing 'vdx.url' setting.");
        }
        this.logger.info("config: vdx.url=" + this.url + ".");
        this.prefix = cf.getString("vdx.prefix");
        if (this.prefix == null) {
            this.fatalError(this.configFilename + ": bad or missing 'vdx.prefix' setting.");
        }
        this.logger.info("config: vdx.prefix=" + this.prefix + ".");
        int m = Util.stringToInt((String)cf.getString("vdx.maxConnections"), (int)-1);
        if (m < 0) {
            this.fatalError(this.configFilename + ": bad or missing 'vdx.maxConnections' setting.");
        }
        this.maxConnections = m;
        this.logger.info("config: vdx.maxConnections=" + this.maxConnections + ".");
    }

    public String getDbDriver() {
        return this.driver;
    }

    public String getDbUrl() {
        return this.url;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public static void main(final String[] args) throws IOException {
        boolean acceptCommands;
        Set arguments = Util.toSet((Object[])args);
        Thread vdxThread = new Thread(new Runnable(){

            public void run() {
                String cf = null;
                if (args.length > 0 && !args[args.length - 1].startsWith("-")) {
                    cf = args[args.length - 1];
                }
                new VDX(cf);
            }
        });
        vdxThread.setName("VDX");
        vdxThread.start();
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        boolean bl = acceptCommands = !arguments.contains("--noinput") && !arguments.contains("-i");
        while (acceptCommands) {
            String s = in.readLine();
            if (s == null || !(s = s.toLowerCase().trim()).equals("q")) continue;
            System.exit(0);
        }
    }
}

