/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.server;

import gov.usgs.net.CommandHandler;
import gov.usgs.net.NetTools;
import gov.usgs.net.Server;
import gov.usgs.vdx.data.DataSourceHandler;
import gov.usgs.vdx.server.BaseCommand;
import gov.usgs.vdx.server.GetDataCommand;
import gov.usgs.vdx.server.MenuCommand;
import gov.usgs.vdx.server.VDX;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;

public class ServerHandler
extends CommandHandler {
    private static int instances = 0;
    private VDX vdx;
    private DataSourceHandler dataSourceHandler;
    private NetTools netTools;

    public ServerHandler(VDX s) {
        super((Server)s, "VDX/ServerHandler-" + instances++);
        this.vdx = s;
        this.netTools = new NetTools();
        this.dataSourceHandler = new DataSourceHandler(this.vdx.getDbDriver(), this.vdx.getDbUrl(), this.vdx.getPrefix());
        this.setupCommandHandlers();
    }

    protected void setupCommandHandlers() {
        this.addCommand("version", new BaseCommand(this, this.netTools){

            public void doCommand(Object info, SocketChannel channel) {
                this.parseParams((String)info);
                this.netTools.writeString("version=1.0.0\n", channel);
                ServerHandler.this.vdx.log(Level.FINE, "version", channel);
            }
        });
        this.addCommand("menu", new MenuCommand(this, this.netTools));
        this.addCommand("getdata", new GetDataCommand(this, this.netTools));
    }

    public DataSourceHandler getDataSourceHandler() {
        return this.dataSourceHandler;
    }

    public void log(Level level, String msg, SocketChannel channel) {
        this.vdx.log(level, msg, channel);
    }
}

