/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.server;

import gov.usgs.net.NetTools;
import gov.usgs.util.CodeTimer;
import gov.usgs.vdx.data.DataSource;
import gov.usgs.vdx.data.DataSourceDescriptor;
import gov.usgs.vdx.data.DataSourceHandler;
import gov.usgs.vdx.server.BaseCommand;
import gov.usgs.vdx.server.RequestResult;
import gov.usgs.vdx.server.ServerHandler;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;

public class GetDataCommand
extends BaseCommand {
    public GetDataCommand(ServerHandler sh, NetTools nt) {
        super(sh, nt);
    }

    public void doCommand(Object info, SocketChannel channel) {
        CodeTimer ct = new CodeTimer("send");
        this.parseParams((String)info);
        String source = (String)this.inParams.get("source");
        if (source == null) {
            this.sendError("source not specified", "getdata", channel);
            return;
        }
        DataSourceHandler dsh = this.handler.getDataSourceHandler();
        DataSourceDescriptor dsd = dsh.getDataSourceDescriptor((String)this.inParams.get("source"));
        DataSource ds = dsd.getDataSource();
        RequestResult result = ds.getData(this.inParams);
        dsd.putDataSource();
        if (result != null) {
            result.set("type", ds.getType());
            result.prepare();
            result.writeHeader(this.netTools, channel);
            result.writeBody(this.netTools, channel);
            ct.stop(false);
            this.handler.log(Level.FINE, String.format("%s (%1.2f ms): [%s]", this.inParams.get("source"), ct.getRunTimeMillis(), info), channel);
        } else {
            this.netTools.writeString("error: no data\n", channel);
            this.handler.log(Level.FINE, "[getdata] returned nothing", channel);
        }
    }
}

