/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.server;

import gov.usgs.net.Command;
import gov.usgs.net.NetTools;
import gov.usgs.util.Util;
import gov.usgs.vdx.server.ServerHandler;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.logging.Level;

public abstract class BaseCommand
implements Command {
    protected NetTools netTools;
    protected ServerHandler handler;
    protected Map<String, String> inParams;
    protected Map<String, String> outParams;

    public BaseCommand(ServerHandler sh, NetTools nt) {
        this.handler = sh;
        this.netTools = nt;
    }

    public void sendError(String msg, String cmd, SocketChannel channel) {
        this.netTools.writeString("error: " + msg + "\n", channel);
        this.handler.log(Level.FINE, String.format("[%s] error: %s", cmd, msg), channel);
    }

    public void parseParams(String cmd) {
        int ci = cmd.indexOf(":");
        if (ci == -1) {
            return;
        }
        String paramString = cmd.substring(ci + 1);
        this.inParams = Util.stringToMap((String)paramString);
    }
}

