/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.in.tilt;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import gov.usgs.pinnacle.Client;
import gov.usgs.pinnacle.StatusBlock;
import gov.usgs.util.Arguments;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Log;
import gov.usgs.util.ResourceReader;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.GenericDataMatrix;
import gov.usgs.vdx.data.tilt.SQLTiltDataSource;
import gov.usgs.vdx.db.VDXDatabase;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;

public class ImportPinnServer
extends Client {
    private static final String CONFIG_FILE = "PinnClient.config";
    private SQLTiltDataSource dataSource;
    private String channel;
    private Logger logger = Log.getLogger((String)"gov.usgs.vdx");

    public ImportPinnServer(String h, int p) {
        super(h, p);
    }

    public static ImportPinnServer createImportPinnServer(String fn) {
        if (fn == null) {
            fn = CONFIG_FILE;
        }
        ConfigFile cf = new ConfigFile(fn);
        String host = cf.getString("server.host");
        int port = Util.stringToInt((String)cf.getString("server.port"), (int)17000);
        ImportPinnServer ips = new ImportPinnServer(host, port);
        ips.channel = cf.getString("channel");
        String driver = cf.getString("vdx.driver");
        String url = cf.getString("vdx.url");
        String prefix = cf.getString("vdx.prefix");
        if (prefix == null) {
            throw new RuntimeException("can't find config parameter vdx.prefix");
        }
        String name = cf.getString("vdx.name");
        ips.dataSource = new SQLTiltDataSource();
        VDXDatabase database = new VDXDatabase(driver, url, prefix);
        if (!ips.dataSource.databaseExists() && ips.dataSource.createDatabase()) {
            ips.logger.info("created database.");
        }
        if (ips.dataSource.createChannel(ips.channel, ips.channel, Double.NaN, Double.NaN, Double.NaN, 0, 0.0)) {
            ips.logger.info("created channel.");
        }
        return ips;
    }

    public void handleStatusBlock(StatusBlock sb) {
        System.out.println(sb);
        DoubleMatrix2D dm = DoubleFactory2D.dense.make(1, 5);
        dm.setQuick(0, 0, sb.getJ2K());
        dm.setQuick(0, 1, sb.getXMillis());
        dm.setQuick(0, 2, sb.getYMillis());
        dm.setQuick(0, 3, sb.getTemperature());
        dm.setQuick(0, 4, sb.getVoltage());
        String[] columnNames = new String[]{"j2ksec", "xTilt", "yTilt", "holeTemp", "instVolt"};
        GenericDataMatrix gdm = new GenericDataMatrix(dm);
        gdm.setColumnNames(columnNames);
        this.dataSource.defaultInsertData(this.channel, gdm, this.dataSource.getTranslationsFlag(), this.dataSource.getRanksFlag(), 1);
    }

    public void importFile(String fn) {
        this.logger = Log.getLogger((String)"gov.usgs.vdx");
        try {
            ResourceReader rr = ResourceReader.getResourceReader((String)fn);
            if (rr == null) {
                return;
            }
            this.logger.info("importing: " + fn);
            String s = rr.nextLine();
            while (s != null) {
                if (s.substring(21, 24).equals("SB:")) {
                    StatusBlock sb = new StatusBlock(Util.hexToBytes((String)s.substring(25)));
                    this.handleStatusBlock(sb);
                }
                s = rr.nextLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] as) {
        String cf = null;
        HashSet flags = new HashSet();
        HashSet<String> keys = new HashSet<String>();
        keys.add("-c");
        Arguments args = new Arguments(as, flags, keys);
        if (args.contains("-c")) {
            cf = args.get("-c");
        }
        List unusedArgs = args.unused();
        ImportPinnServer ips = ImportPinnServer.createImportPinnServer(cf);
        if (unusedArgs.size() > 0) {
            for (String file : unusedArgs) {
                ips.importFile(file);
            }
        } else {
            ips.startListening();
        }
    }
}

