/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.in.generic.variable;

import gov.usgs.util.Arguments;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Log;
import gov.usgs.util.ResourceReader;
import gov.usgs.vdx.data.generic.variable.DataType;
import gov.usgs.vdx.data.generic.variable.SQLGenericVariableDataSource;
import gov.usgs.vdx.data.generic.variable.Station;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.TimeZone;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImportNWISArchive {
    private static final String CONFIG_FILE = "NWIS.config";
    private Logger logger;
    private Station st;
    private DataType dt;
    private SQLGenericVariableDataSource dataSource = new SQLGenericVariableDataSource();
    private ConfigFile params;

    public ImportNWISArchive(String cf) {
        this.params = new ConfigFile(cf);
    }

    public void importFile(String fn) {
        ArrayList dataTypes = new ArrayList();
        this.logger = Log.getLogger((String)"gov.usgs.vdx");
        try {
            ResourceReader rr = ResourceReader.getResourceReader((String)fn);
            if (rr == null) {
                return;
            }
            this.logger.info("importing: " + fn);
            boolean next = false;
            String s = rr.nextLine();
            Pattern commentP = Pattern.compile("^#.*$");
            Pattern stationPattern = Pattern.compile("^.*//STATION AGENCY=\"(\\w*)\\s*\" NUMBER=\"(\\d*).*$");
            Pattern codePattern = Pattern.compile("^.*//PARAMETER CODE=\"(\\d*)\\s*\".*$");
            Pattern namePattern = Pattern.compile("^.*//PARAMETER LNAME=\"([^\"]*)\".*$");
            int code = 0;
            String name = null;
            Matcher commentM = commentP.matcher(s);
            while (commentM.matches()) {
                Matcher nameMatcher;
                Matcher codeMatcher;
                Matcher stationMatcher = stationPattern.matcher(s);
                if (stationMatcher.matches()) {
                    String agency = stationMatcher.group(1).trim();
                    String number = stationMatcher.group(2).trim();
                }
                if ((codeMatcher = codePattern.matcher(s)).matches()) {
                    code = Integer.parseInt(codeMatcher.group(1).trim());
                }
                if ((nameMatcher = namePattern.matcher(s)).matches()) {
                    name = nameMatcher.group(1).trim();
                }
                if (this.dt == null && code > 0 && name != null) {
                    this.dt = new DataType(code, name);
                }
                s = rr.nextLine();
                commentM = commentP.matcher(s);
            }
            System.out.println("Found data type " + this.dt.getName());
            s = rr.nextLine();
            s = rr.nextLine();
            SimpleDateFormat dateIn = new SimpleDateFormat("yyyyMMdd HHmmss");
            dateIn.setTimeZone(TimeZone.getTimeZone(this.st.getTz()));
            Pattern dataPattern = Pattern.compile("^(\\d{8})\\s+(\\d{6})\\s+\\w{3}\\s+([\\d\\.]+)\\s+.*$");
            Matcher dataMatcher = dataPattern.matcher(s);
            while (s != null && dataMatcher.matches()) {
                System.out.println("Found data line " + s);
                Date date = dateIn.parse(dataMatcher.group(1) + " " + dataMatcher.group(2));
                this.dataSource.insertRecord(date, this.st, this.dt, Double.parseDouble(dataMatcher.group(3)), true);
                System.out.println("Found data " + dataMatcher.group(3));
                s = rr.nextLine();
                if (s == null) continue;
                dataMatcher = dataPattern.matcher(s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] as) {
        String cf = CONFIG_FILE;
        boolean period = true;
        HashSet flags = new HashSet();
        HashSet<String> keys = new HashSet<String>();
        keys.add("-c");
        keys.add("-h");
        Arguments args = new Arguments(as, flags, keys);
        if (args.contains("-h")) {
            System.err.println("java gov.usgs.vdx.data.generic.variable.ImportNWISArchive [-c configFile] file ...");
            System.exit(-1);
        }
        if (args.contains("-c")) {
            cf = args.get("-c");
        }
        ImportNWISArchive in = new ImportNWISArchive(cf);
        for (String file : args.unused()) {
            in.importFile(file);
        }
    }
}

