/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.in;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import gov.usgs.util.Arguments;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Time;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.SQLDataSource;
import gov.usgs.vdx.data.SQLNullDataSource;
import gov.usgs.vdx.data.rsam.SQLEWRSAMDataSource;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ImportBob {
    public int goodCount;
    public double[] t;
    public float[] d;
    private int year;
    private static final String CONFIG_FILE = "VDX.config";
    public ConfigFile params;
    Map<String, SQLDataSource> sources;

    public ImportBob(String cf, int y, String n, String t) {
        this.year = y;
        this.params = new ConfigFile(cf);
        this.params.put("vdx.name", n);
        if (this.params == null) {
            System.out.println("Can't parse config file " + cf);
        }
        this.params.put("type", t);
        this.sources = new HashMap<String, SQLDataSource>();
        this.sources.put("ewrsamEvents", new SQLEWRSAMDataSource("Events"));
        this.sources.put("ewrsamValues", new SQLEWRSAMDataSource("Values"));
        this.sources.put("null", new SQLNullDataSource());
    }

    public void process(String c, String f) {
        String type = this.params.getString("type");
        String name = this.params.getString("name");
        SQLDataSource sds = this.sources.get(type);
        if (sds == null) {
            System.out.println("I don't know what to do with type " + type);
            System.exit(-1);
        }
    }

    public DoubleMatrix2D parseFile(String fn) {
        DoubleMatrix2D data = null;
        try {
            DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(fn)));
            short absoluteRecordSize = Util.swap((short)dis.readShort());
            int samplesPerRecord = absoluteRecordSize / 4;
            double dt = 86400.0 / (double)samplesPerRecord;
            double time = Time.parse((String)"yyyyMMDD", (String)(this.year + "0101"));
            dis.readShort();
            dis.skip(absoluteRecordSize - 4);
            GregorianCalendar cal = new GregorianCalendar();
            boolean leapYear = cal.isLeapYear(this.year);
            int numRecords = 365;
            if (leapYear) {
                ++numRecords;
            }
            data = DoubleFactory2D.dense.make(numRecords * samplesPerRecord, 2);
            System.err.println("records: " + numRecords);
            System.err.println("record size: " + absoluteRecordSize);
            System.err.println("expected samples: " + numRecords * samplesPerRecord);
            System.err.println("expected filesize: " + absoluteRecordSize * (numRecords + 1));
            this.goodCount = 0;
            for (int i = 0; i < numRecords * samplesPerRecord; ++i) {
                float value = Float.intBitsToFloat(Util.swap((int)dis.readInt()));
                if (value != -998.0f) {
                    data.setQuick(this.goodCount, 0, time);
                    data.setQuick(this.goodCount++, 1, (double)value);
                }
                time += dt;
            }
            System.err.println("good count: " + this.goodCount);
            dis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    public static void main(String[] as) {
        String cf = CONFIG_FILE;
        String name = "";
        String type = "";
        int year = 1970;
        String channel = "";
        HashSet flags = new HashSet();
        HashSet<String> kvs = new HashSet<String>();
        kvs.add("-c");
        kvs.add("-h");
        kvs.add("-s");
        kvs.add("-y");
        kvs.add("-n");
        kvs.add("-t");
        Arguments args = new Arguments(as, flags, kvs);
        if (args.contains("-c")) {
            cf = args.get("-c");
        }
        if (args.contains("-n")) {
            name = args.get("-n");
        }
        if (args.contains("-s")) {
            channel = args.get("-s");
        }
        if (args.contains("-y")) {
            year = Integer.parseInt(args.get("-y"));
        }
        if (args.contains("-t")) {
            type = args.get("-t");
        }
        if (args.contains("-h") || type == null || type == "") {
            System.err.println("java gov.usgs.vdx.data.gps.ImportBob [-c configFile] -n <name> -s <station> -y <year> -t <type>");
            System.err.println("Known types: \n\tewrsamEvents \n\tewrsamValues \n\tnull");
            System.exit(-1);
        }
        List files = args.unused();
        ImportBob in = new ImportBob(cf, year, name, type);
        for (String f : files) {
            in.process(channel, f);
        }
    }
}

