/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.in;

import gov.usgs.vdx.in.IPConnection;
import java.io.IOException;
import java.net.UnknownHostException;
import java.text.DecimalFormat;

public class FreewaveIPConnection
extends IPConnection {
    private static final int WAIT4OK_TIMEOUT = 2;
    private long receiveTimeout;
    private boolean CCSAILMode;
    private DecimalFormat radioNumberFormatter = new DecimalFormat("#######");

    public FreewaveIPConnection(String i, int p, long rto) {
        super(i, p);
        this.receiveTimeout = rto;
    }

    public void connect(int repeaterEntry, int radioNumber, int timeout) throws Exception {
        try {
            this.open();
        }
        catch (UnknownHostException e) {
            throw new Exception("Unknown host: " + this.ip + ":" + this.port);
        }
        catch (IOException e) {
            throw new Exception("Couldn't open socket input/output streams");
        }
        this.setRepeater(repeaterEntry);
        this.call(radioNumber, timeout);
        this.CCSAILMode = true;
    }

    public void disconnect() {
        this.close();
        this.CCSAILMode = false;
    }

    private void call(int radioNumber, int establishConnectionTimeout) throws Exception {
        String cmd = "ATD" + this.radioNumberFormatter.format(radioNumber);
        this.writeString(cmd);
        this.wait4OK();
        this.wait4Connect(establishConnectionTimeout);
    }

    private void setRepeater(int repeaterEntry) throws Exception {
        String cmd = "ATXC" + (char)(48 + repeaterEntry);
        this.writeString(cmd);
        this.wait4OK();
    }

    private void wait4OK() throws Exception {
        String msg = this.getMsg(2000L);
        if (0 != msg.indexOf("OK")) {
            throw new Exception("'OK' expected but '" + msg + "' received");
        }
        int idx = msg.indexOf("CONNECT");
        if (-1 != idx) {
            this.putMsg(msg.substring(idx));
        }
    }

    private void wait4Connect(int establishConnectionTimeout) throws Exception {
        String msg = this.getMsg(-1 == establishConnectionTimeout ? -1L : (long)establishConnectionTimeout);
        if (0 != msg.indexOf("CONNECT")) {
            throw new Exception("'CONNECT' expected but '" + msg + "' received");
        }
    }

    protected String getMsg(long timeout) throws Exception {
        if (!this.open) {
            throw new Exception("Connection not open.");
        }
        long start = System.currentTimeMillis();
        long end = start + timeout;
        long now = start;
        long delay = 10L;
        if (timeout > 0L && timeout < delay) {
            delay = timeout;
        }
        StringBuffer sb = new StringBuffer();
        while (now < end || -1L == timeout) {
            if (!this.lockQueue && !this.msgQueue.isEmpty()) {
                sb.append(this.msgQueue.firstElement());
                this.msgQueue.removeElementAt(0);
                if (!this.CCSAILMode || '\u0003' == sb.charAt(sb.length() - 1)) {
                    return sb.toString();
                }
            }
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            now = System.currentTimeMillis();
        }
        String txt = "Timeout while waiting for data.";
        if (sb.length() > 0) {
            txt = txt + " Already received: ";
            txt = txt + sb.toString();
        }
        throw new Exception(txt);
    }

    protected boolean putMsg(String msg) {
        if (!this.open) {
            return false;
        }
        if (this.lockQueue) {
            try {
                Thread.sleep(this.receiveTimeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.lockQueue) {
                return false;
            }
        }
        this.lockQueue = true;
        this.msgQueue.insertElementAt(new String(msg), 0);
        this.lockQueue = false;
        return true;
    }
}

