/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.in;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

class CCSAILMessage {
    private String stationNrString;

    public CCSAILMessage(int stationNumber) throws Exception {
        if (stationNumber <= 0 || stationNumber >= 10000) {
            throw new Exception("Invalid station number");
        }
        DecimalFormat ccsailStationNrFormatter = new DecimalFormat("0000");
        this.stationNrString = ccsailStationNrFormatter.format(stationNumber);
    }

    public String make(String msg) {
        String completeStr = "#";
        completeStr = completeStr + this.stationNrString;
        completeStr = completeStr + "0000";
        completeStr = completeStr + msg;
        int checksum = this.calculateChecksum(completeStr, false);
        completeStr = completeStr + (char)(48 + checksum / 10);
        completeStr = completeStr + (char)(48 + checksum % 10);
        completeStr = completeStr + '\u0003';
        return completeStr;
    }

    public String makeDA(Date startDate, int samplesInRequest) throws Exception {
        String cmd = "DA";
        if (samplesInRequest < 1 || samplesInRequest > 9999) {
            throw new Exception("DA: number of values (" + samplesInRequest + ") not in range 1,...,9999");
        }
        SimpleDateFormat formater = new SimpleDateFormat("yyMMddHHmmss");
        formater.setTimeZone(TimeZone.getTimeZone("UTC"));
        cmd = cmd + formater.format(startDate);
        cmd = cmd + samplesInRequest;
        cmd = cmd + ",";
        return this.make(cmd);
    }

    public String makeDB(Date startDate, Date stopDate) {
        String cmd = "DB";
        SimpleDateFormat formater = new SimpleDateFormat("yyMMddHHmmss");
        formater.setTimeZone(TimeZone.getTimeZone("UTC"));
        cmd = cmd + formater.format(startDate);
        cmd = cmd + formater.format(stopDate);
        return this.make(cmd);
    }

    public String makeDL(int numberOfValues) throws Exception {
        if (numberOfValues < 1 || numberOfValues > 9999) {
            throw new Exception("DL: number of values (" + numberOfValues + ") not in range 1,...,9999");
        }
        String cmd = "DL";
        cmd = cmd + numberOfValues;
        cmd = cmd + ',';
        return this.make(cmd);
    }

    public String makeTM() {
        Calendar rightNow = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        SimpleDateFormat formater = new SimpleDateFormat("yyMMddHHmmss");
        formater.setTimeZone(TimeZone.getTimeZone("UTC"));
        String cmd = "TM";
        cmd = cmd + formater.format(rightNow.getTime());
        return this.make(cmd);
    }

    public String makeInvalid() {
        return this.make("TT");
    }

    public String makeSDO(boolean on, int outputNumber) throws Exception {
        if (outputNumber < 18 || outputNumber > 24) {
            throw new Exception("SDO: output number (" + outputNumber + ") not in range 18,...,24");
        }
        String cmd = "SDO";
        cmd = cmd + (on ? (char)'1' : '0');
        cmd = cmd + outputNumber;
        return this.make(cmd);
    }

    public String makeChangeTiltmeterGain(boolean high) {
        String cmd = "";
        try {
            cmd = this.makeSDO(high, 18);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cmd;
    }

    public String getMsg(String str, boolean ignoreWrongAddress) throws Exception {
        int checkSumCalc;
        int len = str.length();
        if (str.startsWith("\r\n")) {
            str = str.substring(2, len);
            len -= 2;
        }
        if (len < 12) {
            throw new Exception("Too short. Len = " + len);
        }
        if ('#' != str.charAt(0)) {
            throw new Exception("Wrong ATN: " + str.charAt(0));
        }
        if ('\u0003' != str.charAt(len - 1)) {
            throw new Exception("Wrong ETX: " + str.charAt(len - 1));
        }
        int checkSumIs = (str.charAt(len - 3) - 48) * 10;
        if ((checkSumIs += str.charAt(len - 2) - 48) != (checkSumCalc = this.calculateChecksum(str, true))) {
            throw new Exception("Wrong checksum: " + checkSumIs + " should be: " + checkSumCalc);
        }
        String token = str.substring(1, 5);
        if (!token.equals("0000") && !ignoreWrongAddress) {
            throw new Exception("Wrong ADR: " + token);
        }
        token = str.substring(5, 9);
        if (!token.equals(this.stationNrString) && !ignoreWrongAddress) {
            throw new Exception("Wrong RTN: " + token);
        }
        token = str.substring(9, len - 3);
        return token;
    }

    private boolean checkChecksum(String str) {
        boolean chkOk = false;
        int len = str.length();
        chkOk = len >= 4;
        if (chkOk && (chkOk = '\u0003' == str.charAt(len - 1) && '#' == str.charAt(0))) {
            int chkIs = (str.charAt(len - 3) - 48) * 10;
            chkOk = (chkIs += str.charAt(len - 2) - 48) == this.calculateChecksum(str, true);
        }
        return chkOk;
    }

    private int calculateChecksum(String str, boolean ignoreEnd) {
        int checksum = 0;
        char c = '\u0000';
        int len = str.length();
        if (ignoreEnd) {
            len -= 3;
        }
        for (int i = 1; i < len; ++i) {
            c = str.charAt(i);
            checksum += c;
        }
        return checksum %= 100;
    }
}

