/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data.wave.plot;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import gov.usgs.math.FFT;
import gov.usgs.plot.DefaultFrameDecorator;
import gov.usgs.plot.FrameDecorator;
import gov.usgs.plot.FrameRenderer;
import gov.usgs.plot.MatrixRenderer;
import gov.usgs.vdx.data.wave.SliceWave;
import java.awt.Color;

public class SpectraRenderer
extends MatrixRenderer {
    private SliceWave wave;
    private double minFreq;
    private double maxFreq;
    private boolean logFreq;
    private boolean logPower;
    private double maxPower;
    private boolean autoScale;
    private String channelTitle;
    protected FrameDecorator decorator;

    public void setFrameDecorator(FrameDecorator fd) {
        this.decorator = fd;
    }

    public void setWave(SliceWave sw) {
        this.wave = sw;
    }

    public void setTitle(String t) {
        this.channelTitle = t;
    }

    public double update(double oldMaxPower) {
        if (this.decorator == null) {
            this.decorator = new DefaultSpectraFrameDecorator();
        }
        this.decorator.update();
        double[] data = this.wave.fastFFT();
        FFT.fastToPowerFreq((double[])data, (double)this.wave.getSamplingRate(), (boolean)this.logPower, (boolean)this.logFreq);
        if (this.logFreq) {
            this.minFreq = this.minFreq == 0.0 ? data[6] : Math.log(this.minFreq) / FFT.LOG10;
            this.maxFreq = Math.log(this.maxFreq) / FFT.LOG10;
        }
        double maxp = -1.0E300;
        double minp = 1.0E300;
        int n = data.length / 4;
        for (int i = 2; i < n; ++i) {
            if (!(data[i * 2] >= this.minFreq) || !(data[i * 2] <= this.maxFreq)) continue;
            if (data[i * 2 + 1] > maxp) {
                maxp = data[i * 2 + 1];
            }
            if (!(data[i * 2 + 1] < minp)) continue;
            minp = data[i * 2 + 1];
        }
        DoubleMatrix2D dm = DoubleFactory2D.dense.make(n, 2);
        for (int i = 0; i < n; ++i) {
            dm.setQuick(i, 0, data[i * 2]);
            dm.setQuick(i, 1, data[i * 2 + 1]);
        }
        this.setData(dm);
        if (this.autoScale) {
            if (this.logPower) {
                maxp = Math.pow(10.0, maxp);
            }
            maxp = Math.max(maxp, oldMaxPower);
        } else {
            maxp = this.maxPower;
        }
        if (this.logPower) {
            maxp = Math.log(maxp) / Math.log(10.0);
        }
        this.setExtents(this.minFreq, this.maxFreq, 0.0, maxp);
        this.createDefaultLineRenderers();
        this.decorator.decorate((FrameRenderer)this);
        return maxp;
    }

    public boolean isAutoScale() {
        return this.autoScale;
    }

    public void setAutoScale(boolean autoScale) {
        this.autoScale = autoScale;
    }

    public boolean isLogFreq() {
        return this.logFreq;
    }

    public void setLogFreq(boolean logFreq) {
        this.logFreq = logFreq;
    }

    public boolean isLogPower() {
        return this.logPower;
    }

    public void setLogPower(boolean logPower) {
        this.logPower = logPower;
    }

    public double getMaxFreq() {
        return this.maxFreq;
    }

    public void setMaxFreq(double maxFreq) {
        this.maxFreq = maxFreq;
    }

    public double getMaxPower() {
        return this.maxPower;
    }

    public void setMaxPower(double maxPower) {
        this.maxPower = maxPower;
    }

    public double getMinFreq() {
        return this.minFreq;
    }

    public void setMinFreq(double minFreq) {
        this.minFreq = minFreq;
    }

    protected class DefaultSpectraFrameDecorator
    extends DefaultFrameDecorator {
        public DefaultSpectraFrameDecorator() {
            this.title = SpectraRenderer.this.channelTitle;
            this.titleBackground = Color.WHITE;
        }

        public void update() {
            this.xAxis = SpectraRenderer.this.logFreq ? DefaultFrameDecorator.XAxis.LOG : DefaultFrameDecorator.XAxis.LINEAR;
            this.yAxis = SpectraRenderer.this.logPower ? DefaultFrameDecorator.YAxis.LOG : DefaultFrameDecorator.YAxis.LINEAR;
            this.yAxisLabel = "Power";
        }
    }
}

