/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data.wave.plot;

import gov.usgs.plot.DefaultFrameDecorator;
import gov.usgs.plot.FrameDecorator;
import gov.usgs.plot.FrameRenderer;
import gov.usgs.vdx.data.wave.SliceWave;
import gov.usgs.vdx.data.wave.Wave;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class SliceWaveRenderer
extends FrameRenderer {
    private SliceWave wave;
    protected boolean autoScale = true;
    protected boolean removeBias = true;
    protected boolean drawSamples = false;
    protected double highlightX1;
    protected double highlightX2;
    protected double viewStartTime;
    protected double viewEndTime;
    protected boolean displayLabels = true;
    protected Color color = Color.BLUE;
    protected String yLabel = "Counts";
    protected String title;
    protected FrameDecorator decorator;

    public void setFrameDecorator(FrameDecorator fd) {
        this.decorator = fd;
    }

    public void setHighlight(double x1, double x2) {
        this.highlightX1 = x1;
        this.highlightX2 = x2;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public void setMaxY(double maxY) {
        this.maxY = maxY;
    }

    public double getMinY() {
        return this.minY;
    }

    public void setMinY(double minY) {
        this.minY = minY;
    }

    public boolean isAutoScale() {
        return this.autoScale;
    }

    public boolean isRemoveBias() {
        return this.removeBias;
    }

    public void setAutoScale(boolean b) {
        this.autoScale = b;
    }

    public void setYLimits(double min, double max) {
        this.minY = min;
        this.maxY = max;
    }

    public void setRemoveBias(boolean b) {
        this.removeBias = b;
    }

    public void setDrawSamples(boolean b) {
        this.drawSamples = b;
    }

    public void setWave(SliceWave w) {
        this.wave = w;
    }

    public void setViewTimes(double t1, double t2) {
        this.viewStartTime = t1;
        this.viewEndTime = t2;
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public void setDisplayLabels(boolean b) {
        this.displayLabels = b;
    }

    public void setYLabel(String s) {
        this.yLabel = s;
    }

    public void setTitle(String s) {
        this.title = s;
    }

    public void createDefaultFrameDecorator() {
        this.decorator = new DefaultWaveFrameDecorator();
    }

    public void update() {
        if (this.decorator == null) {
            this.createDefaultFrameDecorator();
        }
        if (this.decorator instanceof DefaultFrameDecorator) {
            ((DefaultFrameDecorator)this.decorator).yAxisLabel = this.yLabel;
        }
        this.setExtents(this.viewStartTime, this.viewEndTime, this.minY, this.maxY);
        this.decorator.decorate((FrameRenderer)this);
    }

    public void render(Graphics2D g) {
        Shape origClip = g.getClip();
        if (this.axis != null) {
            this.axis.render(g);
        }
        g.clip(new Rectangle(this.graphX + 1, this.graphY + 1, this.graphWidth - 1, this.graphHeight - 1));
        double st = this.wave.getStartTime();
        double step = 1.0 / this.wave.getSamplingRate();
        this.wave.reset();
        double bias = 0.0;
        if (this.removeBias) {
            bias = this.wave.mean();
        }
        g.setColor(this.color);
        double ns = (double)this.wave.samples() * (this.viewEndTime - this.viewStartTime) / (this.wave.getEndTime() - this.wave.getStartTime());
        double spp = ns / (double)this.graphWidth;
        Rectangle2D.Double box = new Rectangle2D.Double();
        if (spp < 50.0) {
            GeneralPath gp = new GeneralPath();
            double y = this.wave.next();
            gp.moveTo((float)this.getXPixel(st), (float)this.getYPixel(y - bias));
            float lastY = (float)this.getYPixel(y - bias);
            while (this.wave.hasNext()) {
                st += step;
                y = this.wave.next();
                if (y == (double)Wave.NO_DATA) {
                    gp.moveTo((float)this.getXPixel(st), lastY);
                    continue;
                }
                lastY = (float)this.getYPixel(y - bias);
                gp.lineTo((float)this.getXPixel(st), lastY);
                if (!this.drawSamples || !(1.0 / spp > 2.0)) continue;
                box.setRect((double)((float)this.getXPixel(st)) - 1.5, (double)lastY - 1.5, 3.0, 3.0);
                g.draw(box);
            }
            g.draw(gp);
        } else {
            int i;
            double[][] spans = new double[this.graphWidth + 1][];
            for (int i2 = 0; i2 < spans.length; ++i2) {
                spans[i2] = new double[]{1.0E300, -1.0E300};
            }
            double span = this.viewEndTime - this.viewStartTime;
            this.wave.reset();
            while (this.wave.hasNext()) {
                double y = this.wave.next();
                i = (int)((st - this.viewStartTime) / span * (double)this.graphWidth + 0.5);
                if (i >= 0 && i < spans.length && y != (double)Wave.NO_DATA) {
                    spans[i][0] = Math.min(y, spans[i][0]);
                    spans[i][1] = Math.max(y, spans[i][1]);
                }
                st += step;
            }
            Line2D.Double line = new Line2D.Double();
            double lastMinY = -1.0E300;
            double lastMaxY = 1.0E300;
            for (i = 0; i < spans.length; ++i) {
                double minY = this.getYPixel(spans[i][0] - bias);
                double maxY = this.getYPixel(spans[i][1] - bias);
                if (maxY < lastMinY) {
                    line.setLine(this.graphX + i - 1, lastMinY, this.graphX + i, maxY);
                    g.draw(line);
                } else if (minY > lastMaxY) {
                    line.setLine(this.graphX + i - 1, lastMaxY, this.graphX + i, minY);
                    g.draw(line);
                }
                line.setLine(this.graphX + i, minY, this.graphX + i, maxY);
                g.draw(line);
                lastMinY = minY;
                lastMaxY = maxY;
            }
        }
        g.setClip(origClip);
        if (this.axis != null) {
            this.axis.postRender(g);
        }
    }

    protected class DefaultWaveFrameDecorator
    extends DefaultFrameDecorator {
        public DefaultWaveFrameDecorator() {
            this.yAxisLabel = SliceWaveRenderer.this.yLabel;
            this.title = SliceWaveRenderer.this.title;
            this.titleBackground = Color.WHITE;
        }
    }
}

