/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data.wave;

import edu.iris.Fissures.seed.builder.ObjectBuilder;
import edu.iris.Fissures.seed.builder.SeedObjectBuilder;
import edu.iris.Fissures.seed.container.Blockette;
import edu.iris.Fissures.seed.container.Btime;
import edu.iris.Fissures.seed.container.SeedObjectContainer;
import edu.iris.Fissures.seed.container.Waveform;
import edu.iris.Fissures.seed.director.SeedImportDirector;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.wave.Wave;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Seed {
    public static Map<String, List<Wave>> readSeed(String fn) {
        HashMap<String, List<Wave>> map = new HashMap<String, List<Wave>>();
        try {
            Object object;
            DataInputStream ls = new DataInputStream(new BufferedInputStream(new FileInputStream(fn)));
            SeedImportDirector importDirector = new SeedImportDirector();
            SeedObjectBuilder objectBuilder = new SeedObjectBuilder();
            importDirector.assignBuilder((ObjectBuilder)objectBuilder);
            importDirector.construct((InputStream)ls);
            SeedObjectContainer container = (SeedObjectContainer)importDirector.getBuilder().getContainer();
            container.iterate();
            while ((object = container.getNext()) != null) {
                ArrayList<Wave> parts;
                Blockette b = (Blockette)object;
                if (b.getType() != 999) continue;
                String code = b.getFieldVal(4) + "$" + b.getFieldVal(6) + "$" + b.getFieldVal(7);
                String loc = (String)b.getFieldVal(5);
                if (loc.trim().length() > 0) {
                    code = code + "$" + loc;
                }
                if ((parts = (ArrayList<Wave>)map.get(code)) == null) {
                    parts = new ArrayList<Wave>();
                    map.put(code, parts);
                }
                if (b.getWaveform() == null) continue;
                Waveform wf = b.getWaveform();
                Wave sw = new Wave();
                sw.setSamplingRate(Seed.getSampleRate(((Integer)b.getFieldVal(10)).intValue(), ((Integer)b.getFieldVal(11)).intValue()));
                Btime bTime = (Btime)b.getFieldVal(8);
                sw.setStartTime(Util.dateToJ2K((Date)Seed.btimeToDate(bTime)));
                sw.buffer = wf.getDecodedIntegers();
                sw.register();
                parts.add(sw);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static Date btimeToDate(Btime bt) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.set(1, bt.getYear());
        cal.set(6, bt.getDayOfYear());
        cal.set(11, bt.getHour());
        cal.set(12, bt.getMinute());
        cal.set(13, bt.getSecond());
        cal.set(14, bt.getTenthMill() / 10);
        return cal.getTime();
    }

    public static float getSampleRate(double factor, double multiplier) {
        float sampleRate = 10000.0f;
        if (factor * multiplier != 0.0) {
            sampleRate = (float)(Math.pow(Math.abs(factor), factor / Math.abs(factor)) * Math.pow(Math.abs(multiplier), multiplier / Math.abs(multiplier)));
        }
        return sampleRate;
    }
}

