/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data.rsam;

import cern.colt.matrix.DoubleMatrix2D;
import gov.usgs.util.ConfigFile;
import gov.usgs.vdx.data.Channel;
import gov.usgs.vdx.data.Column;
import gov.usgs.vdx.data.DataSource;
import gov.usgs.vdx.data.GenericDataMatrix;
import gov.usgs.vdx.data.SQLDataSource;
import gov.usgs.vdx.data.rsam.RSAMData;
import gov.usgs.vdx.server.BinaryResult;
import gov.usgs.vdx.server.RequestResult;
import gov.usgs.vdx.server.TextResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLEWRSAMDataSource
extends SQLDataSource
implements DataSource {
    public static final String DATABASE_NAME = "ewrsam";
    public static final boolean channels = true;
    public static final boolean translations = false;
    public static final boolean channelTypes = false;
    public static final boolean ranks = false;
    public static final boolean columns = true;
    public static final boolean menuColumns = false;
    public static final Column[] DATA_COLUMNS = new Column[]{new Column(1, "rsam", "rsam", "", false, true)};
    private String tableSuffix;

    public SQLEWRSAMDataSource() {
    }

    public SQLEWRSAMDataSource(String s) {
        if (s.equals("Events")) {
            this.tableSuffix = "_events";
        } else if (s.equals("Values")) {
            this.tableSuffix = "_values";
        }
    }

    @Override
    public String getType() {
        return DATABASE_NAME;
    }

    @Override
    public boolean getChannelsFlag() {
        return true;
    }

    @Override
    public boolean getTranslationsFlag() {
        return false;
    }

    @Override
    public boolean getChannelTypesFlag() {
        return false;
    }

    @Override
    public boolean getRanksFlag() {
        return false;
    }

    @Override
    public boolean getColumnsFlag() {
        return true;
    }

    @Override
    public boolean getMenuColumnsFlag() {
        return false;
    }

    @Override
    public void initialize(ConfigFile params) {
        this.defaultInitialize(params);
        if (!this.databaseExists()) {
            this.createDatabase();
        }
    }

    @Override
    public void disconnect() {
        this.defaultDisconnect();
    }

    @Override
    public boolean databaseExists() {
        return this.defaultDatabaseExists();
    }

    @Override
    public boolean createDatabase() {
        this.defaultCreateDatabase(true, false, false, false, true, false);
        for (int i = 0; i < DATA_COLUMNS.length; ++i) {
            this.defaultInsertColumn(DATA_COLUMNS[i]);
        }
        return true;
    }

    public boolean createChannel(String channelCode, String channelName, double lon, double lat, double height) {
        this.defaultCreateChannel(channelCode, channelName, lon, lat, height, 0, true, false, false, true);
        this.defaultCreateChannel(channelCode + "_values", null, Double.NaN, Double.NaN, Double.NaN, 0, false, false, false, true);
        this.defaultCreateChannel(channelCode + "_events", null, Double.NaN, Double.NaN, Double.NaN, 0, false, false, false, true);
        return true;
    }

    @Override
    public RequestResult getData(Map<String, String> params) {
        String action = params.get("action");
        if (action == null) {
            return null;
        }
        if (action.equals("channels")) {
            return new TextResult(this.defaultGetChannels(false));
        }
        if (action.equals("data")) {
            String plotType;
            int p;
            double et;
            double st;
            int cid = Integer.parseInt(params.get("channel"));
            RSAMData data = this.getEWRSAMData(cid, st = Double.parseDouble(params.get("st")), et = Double.parseDouble(params.get("et")), p = Integer.parseInt(params.get("period")), plotType = params.get("plotType"));
            if (data != null) {
                return new BinaryResult(data);
            }
        } else if (action.equals("ewRsamMenu")) {
            return new TextResult(this.getTypes());
        }
        return null;
    }

    public List<String> getTypes() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            this.database.useDatabase(this.dbName);
            this.sql = "SHOW TABLES LIKE '%_events'";
            this.ps = this.database.getPreparedStatement(this.sql);
            this.rs = this.ps.executeQuery();
            if (this.rs.next()) {
                result.add("EVENTS");
            }
            this.sql = "SHOW TABLES LIKE '%_values'";
            this.ps = this.database.getPreparedStatement(this.sql);
            this.rs = this.ps.executeQuery();
            if (this.rs.next()) {
                result.add("VALUES");
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLEWRSAMDataSource.getTypes()", e);
        }
        return result;
    }

    public RSAMData getEWRSAMData(int cid, double st, double et, int p, String plotType) {
        ArrayList<Object> pts = new ArrayList<double[]>();
        RSAMData result = null;
        try {
            this.database.useDatabase(this.dbName);
            Channel ch = this.defaultGetChannel(cid, false);
            if (plotType.equals("VALUES")) {
                this.sql = "SELECT j2ksec + ? / 2, avg(rsam) ";
                this.sql = this.sql + "FROM   ?_values ";
                this.sql = this.sql + "WHERE  j2ksec >= ? and j2ksec <= ? ";
                this.sql = this.sql + "GROUP BY FLOOR(j2ksec / ?) ";
                this.ps = this.database.getPreparedStatement(this.sql);
                this.ps.setDouble(1, p);
                this.ps.setString(2, ch.getCode());
                this.ps.setDouble(3, st);
                this.ps.setDouble(4, et);
                this.ps.setDouble(5, p);
                this.rs = this.ps.executeQuery();
                pts = new ArrayList();
                while (this.rs.next()) {
                    double[] dataRow = new double[]{this.rs.getDouble(1), this.rs.getDouble(2)};
                    pts.add(dataRow);
                }
                this.rs.close();
            } else if (plotType.equals("EVENTS")) {
                this.sql = "SELECT j2ksec, rsam ";
                this.sql = this.sql + "FROM   ?_events ";
                this.sql = this.sql + "WHERE  j2ksec >= ? and j2ksec <= ? and rsam != 0";
                this.ps = this.database.getPreparedStatement(this.sql);
                this.ps.setString(1, ch.getCode());
                this.ps.setDouble(2, st);
                this.ps.setDouble(3, et);
                this.rs = this.ps.executeQuery();
                double count = 0.0;
                double[] dataRow = new double[]{st, count};
                pts.add(dataRow);
                while (this.rs.next()) {
                    double t = this.rs.getDouble(1);
                    double c = this.rs.getDouble(2);
                    int i = 0;
                    while ((double)i < c) {
                        dataRow = new double[]{t, count += 1.0};
                        pts.add(dataRow);
                        ++i;
                    }
                }
                this.rs.close();
                dataRow = new double[]{et, count};
                pts.add(dataRow);
            }
            if (pts.size() > 0) {
                result = new RSAMData(pts);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLEWRSAMDataSource.getEWRSAMData()", e);
        }
        return result;
    }

    public void insertData(String channelCode, GenericDataMatrix gdm, boolean translations, boolean ranks, int rid) {
        try {
            this.database.useDatabase(this.dbName);
            DoubleMatrix2D data = gdm.getData();
            this.sql = "REPLACE INTO ";
            this.sql = this.sql + channelCode + this.tableSuffix + " (j2ksec, rsam) VALUES (?,?)";
            this.ps = this.database.getPreparedStatement(this.sql);
            for (int i = 0; i < data.rows(); ++i) {
                if (i % 100 == 0) {
                    System.out.print(".");
                }
                this.ps.setDouble(1, data.getQuick(i, 0));
                this.ps.setDouble(2, data.getQuick(i, 1));
                this.ps.execute();
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "SQLEWRSAMDataSource.insertData()", e);
        }
    }
}

