/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data.hypo.plot;

import gov.usgs.plot.Jet;
import gov.usgs.plot.Renderer;
import gov.usgs.plot.SmartTick;
import gov.usgs.plot.Spectrum;
import gov.usgs.plot.Transformer;
import gov.usgs.vdx.data.hypo.Hypocenter;
import gov.usgs.vdx.data.hypo.HypocenterList;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.List;

public class HypocenterRenderer
implements Renderer {
    private HypocenterList data;
    private Transformer transformer;
    private Axes axes;
    private static NumberFormat numberFormat;
    private ColorOption colorOpt;
    private double minTime;
    private double maxTime;
    private static final Spectrum spectrum;
    private Renderer colorScaleRenderer;
    private Renderer magnitudeScaleRenderer;
    public static Ellipse2D.Float[] circles;
    public static final int[] circleScaleOffset;
    public static Color[] colors;
    public static double[] depths;

    public HypocenterRenderer(HypocenterList d, Transformer fr, Axes v) {
        this.data = d;
        this.transformer = fr;
        this.axes = v;
        if (numberFormat == null) {
            numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(0);
        }
        this.colorOpt = ColorOption.chooseAuto(v);
    }

    public void setColorTime(double min, double max) {
        this.colorOpt = ColorOption.TIME;
        this.minTime = min;
        this.maxTime = max;
    }

    public void setMonochrome() {
        this.colorOpt = ColorOption.MONOCHROME;
    }

    public void setColorDepth() {
        this.colorOpt = ColorOption.DEPTH;
    }

    public void setColorOption(ColorOption c) {
        this.colorOpt = c;
    }

    public void createMagnitudeScaleRenderer(final double xStart, final double yStart) {
        this.magnitudeScaleRenderer = new Renderer(){

            public void render(Graphics2D g) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setColor(Color.BLACK);
                g.setStroke(new BasicStroke(2.0f));
                g.drawString("Magnitude", (float)xStart - 4.0f, (float)yStart - 40.0f);
                g.setFont(new Font("Arial", 0, 10));
                for (int i = 0; i < circles.length - 2; ++i) {
                    g.translate(xStart - (double)HypocenterRenderer.circles[i].x + 8.0, (double)HypocenterRenderer.circles[i].y + yStart + (double)circleScaleOffset[i]);
                    g.setPaint(Color.WHITE);
                    g.fill(circles[i]);
                    g.setPaint(Color.BLACK);
                    g.draw(circles[i]);
                    g.translate(-(xStart - (double)HypocenterRenderer.circles[i].x + 8.0), -((double)HypocenterRenderer.circles[i].y + yStart + (double)circleScaleOffset[i]));
                    g.drawString("" + i, (float)xStart, (float)yStart + (float)circleScaleOffset[i]);
                }
            }
        };
    }

    public void createColorScaleRenderer(final double xStart, final double yStart) {
        this.colorScaleRenderer = new Renderer(){

            public void render(Graphics2D g) {
                int i;
                g.setStroke(new BasicStroke(1.0f));
                g.setFont(new Font("Arial", 0, 10));
                if (HypocenterRenderer.this.colorOpt == ColorOption.DEPTH || HypocenterRenderer.this.axes == Axes.TRIPLE_VIEW) {
                    Rectangle2D.Double rect = new Rectangle2D.Double();
                    float dy = 0.0f;
                    double yoff = 0.0;
                    double ty = (depths.length - 3) * 13;
                    for (i = 1; i < depths.length - 2; ++i) {
                        rect.setRect(xStart, yStart - ty + yoff + (double)dy, 10.0, 13.0);
                        g.drawString("" + Math.round(-depths[i]), (float)xStart + 13.0f, (float)(yStart - ty + 4.0 + (double)dy + yoff));
                        g.setPaint(colors[i]);
                        g.fill(rect);
                        g.setPaint(Color.BLACK);
                        g.draw(rect);
                        yoff += 13.0;
                    }
                    g.drawString("" + Math.round(-depths[depths.length - 2]), (float)xStart + 13.0f, (float)(yStart - ty + yoff + 4.0 + (double)dy));
                    g.drawString("Depth (km)", (float)xStart, (float)(yStart - ty - 9.0 + (double)dy));
                }
                if (HypocenterRenderer.this.colorOpt == ColorOption.TIME || HypocenterRenderer.this.axes == Axes.TRIPLE_VIEW) {
                    spectrum.renderScale(g, xStart, yStart - 80.0, 10.0, 80.0, true, true);
                    Object[] t = SmartTick.autoTimeTick((double)HypocenterRenderer.this.minTime, (double)HypocenterRenderer.this.maxTime, (int)6);
                    double[] ticks = (double[])t[0];
                    String[] labels = (String[])t[1];
                    double dt = HypocenterRenderer.this.maxTime - HypocenterRenderer.this.minTime;
                    Line2D.Double line = new Line2D.Double();
                    for (i = 0; i < ticks.length; ++i) {
                        double yl = (ticks[i] - HypocenterRenderer.this.minTime) / dt * 80.0;
                        line.setLine(xStart + 10.0, yStart - 80.0 + yl, xStart + 13.0, yStart - 80.0 + yl);
                        g.draw(line);
                        g.drawString(labels[i], (float)xStart + 16.0f, (float)(yl + yStart - 80.0 + 3.0));
                    }
                }
            }
        };
    }

    public Renderer getScaleRenderer(final double xStart, final double yStart, boolean triple) {
        return new Renderer(){

            public void render(Graphics2D g) {
                Object aa = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                Stroke oldStroke = g.getStroke();
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setColor(Color.BLACK);
                g.setStroke(new BasicStroke(2.0f));
                g.drawString("Magnitude", (float)xStart - 4.0f, (float)yStart - 40.0f);
                Font origFont = g.getFont();
                g.setFont(new Font("Arial", 0, 10));
                for (int i = 0; i < circles.length; ++i) {
                    g.translate(xStart + (double)circleScaleOffset[i], (double)HypocenterRenderer.circles[i].y + yStart);
                    g.setPaint(Color.WHITE);
                    g.fill(circles[i]);
                    g.setPaint(Color.BLACK);
                    g.draw(circles[i]);
                    g.translate((double)(-circleScaleOffset[i]) - xStart, -((double)HypocenterRenderer.circles[i].y + yStart));
                    g.drawString("" + i, (float)xStart + (float)circleScaleOffset[i] - 3.0f, 15.0f + (float)yStart);
                }
                Rectangle2D.Double rect = new Rectangle2D.Double();
                double xoff = 190.0 + xStart;
                double yoff = yStart - 65.0;
                g.setStroke(new BasicStroke(1.0f));
                if (HypocenterRenderer.this.colorOpt == ColorOption.DEPTH || HypocenterRenderer.this.axes == Axes.TRIPLE_VIEW) {
                    float dy = 0.0f;
                    if (HypocenterRenderer.this.axes == Axes.TRIPLE_VIEW) {
                        dy = -60.0f;
                    }
                    for (int i = 1; i < depths.length - 2; ++i) {
                        rect.setRect(xoff - 15.0, yoff + (double)dy, 10.0, 13.0);
                        g.drawString("" + Math.round(-depths[i]), (float)xoff, (float)yoff + 4.0f + dy);
                        g.setPaint(colors[i]);
                        g.fill(rect);
                        g.setPaint(Color.BLACK);
                        g.draw(rect);
                        yoff += 13.0;
                    }
                    g.drawString("" + Math.round(-depths[depths.length - 2]), (float)xoff, (float)yoff + 4.0f + dy);
                    g.drawString("Depth (km)", (float)xStart + 160.0f, (float)yStart + 15.0f + dy);
                }
                xoff = 190.0 + xStart;
                yoff = yStart - 65.0;
                if (HypocenterRenderer.this.colorOpt == ColorOption.TIME || HypocenterRenderer.this.axes == Axes.TRIPLE_VIEW) {
                    if (HypocenterRenderer.this.axes == Axes.TRIPLE_VIEW) {
                        yoff += 45.0;
                    }
                    spectrum.renderScale(g, xoff - 15.0, yoff, 10.0, 80.0, true, true);
                    Object[] t = SmartTick.autoTimeTick((double)HypocenterRenderer.this.minTime, (double)HypocenterRenderer.this.maxTime, (int)6);
                    double[] ticks = (double[])t[0];
                    String[] labels = (String[])t[1];
                    double dt = HypocenterRenderer.this.maxTime - HypocenterRenderer.this.minTime;
                    Line2D.Double line = new Line2D.Double();
                    for (int i = 0; i < ticks.length; ++i) {
                        double yl = (ticks[i] - HypocenterRenderer.this.minTime) / dt * 80.0;
                        line.setLine(xoff - 5.0, yoff + yl, xoff - 3.0, yoff + yl);
                        g.draw(line);
                        g.drawString(labels[i], (float)xoff, (float)(yl + yoff + 3.0));
                    }
                }
                g.setFont(origFont);
                g.setStroke(new BasicStroke(2.0f));
                if (HypocenterRenderer.this.axes == Axes.TRIPLE_VIEW) {
                    g.drawString("Top color scale for map view,", (float)xStart, (float)yStart + 35.0f);
                    g.drawString("bottom for depth views.", (float)xStart, (float)yStart + 50.0f);
                }
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aa);
                g.setStroke(oldStroke);
            }
        };
    }

    public void render(Graphics2D g) {
        Color origColor = g.getColor();
        AffineTransform origAT = g.getTransform();
        Stroke origStroke = g.getStroke();
        Font origFont = g.getFont();
        Object aa = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setStroke(new BasicStroke(2.0f));
        double xt = 0.0;
        double yt = 0.0;
        Color color = null;
        double dt = this.maxTime - this.minTime;
        List<Hypocenter> hcs = this.data.getHypocenters();
        for (int i = 0; i < hcs.size(); ++i) {
            int ci;
            Hypocenter hc = hcs.get(i);
            if (hc.prefmag == -99.99) continue;
            switch (this.axes) {
                case MAP_VIEW: 
                case TRIPLE_VIEW: {
                    xt = this.transformer.getXPixel(hc.lon);
                    yt = this.transformer.getYPixel(hc.lat);
                    break;
                }
                case LON_DEPTH: {
                    xt = this.transformer.getXPixel(hc.lon);
                    yt = this.transformer.getYPixel(hc.depth);
                    break;
                }
                case LAT_DEPTH: {
                    xt = this.transformer.getXPixel(hc.lat);
                    yt = this.transformer.getYPixel(hc.depth);
                    break;
                }
                case DEPTH_TIME: {
                    xt = this.transformer.getXPixel(hc.j2ksec);
                    yt = this.transformer.getYPixel(hc.depth);
                }
            }
            g.translate(xt, yt);
            block6 : switch (this.colorOpt) {
                case DEPTH: {
                    for (int j = 0; j < depths.length - 1; ++j) {
                        if (!(hc.depth <= depths[j]) || !(hc.depth > depths[j + 1])) continue;
                        color = colors[j];
                        break block6;
                    }
                    break;
                }
                case TIME: {
                    ci = (int)((hc.j2ksec - this.minTime) / dt * ((double)HypocenterRenderer.spectrum.colors.length - 1.0));
                    color = HypocenterRenderer.spectrum.colors[ci];
                    break;
                }
                case MONOCHROME: {
                    color = Color.BLUE;
                }
            }
            g.setColor(color);
            ci = (int)Math.floor(hc.prefmag);
            if (ci < 0) {
                ci = 0;
            }
            g.draw(circles[ci]);
            g.translate(-xt, -yt);
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aa);
        g.setColor(origColor);
        g.setTransform(origAT);
        if (this.colorScaleRenderer != null) {
            this.colorScaleRenderer.render(g);
        }
        if (this.magnitudeScaleRenderer != null) {
            this.magnitudeScaleRenderer.render(g);
        }
        g.setStroke(origStroke);
        g.setFont(origFont);
    }

    static {
        spectrum = Jet.getInstance();
        circles = new Ellipse2D.Float[]{new Ellipse2D.Float(-1.5f, -1.5f, 3.0f, 3.0f), new Ellipse2D.Float(-3.0f, -3.0f, 6.0f, 6.0f), new Ellipse2D.Float(-5.5f, -5.5f, 11.0f, 11.0f), new Ellipse2D.Float(-9.0f, -9.0f, 18.0f, 18.0f), new Ellipse2D.Float(-13.5f, -13.5f, 27.0f, 27.0f), new Ellipse2D.Float(-19.0f, -19.0f, 38.0f, 38.0f), new Ellipse2D.Float(-25.5f, -25.5f, 51.0f, 51.0f), new Ellipse2D.Float(-34.0f, -34.0f, 68.0f, 68.0f)};
        circleScaleOffset = new int[]{1, 8, 17, 28, 44, 64, 90, 120};
        colors = new Color[]{Color.BLACK, Color.GREEN, Color.RED, new Color(1.0f, 0.91f, 0.0f), Color.BLUE, new Color(0.8f, 0.0f, 1.0f), Color.BLACK};
        depths = new double[]{10000.0, 0.0, -5.0, -10.0, -20.0, -40.0, -70.0, -10000.0};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ColorOption {
        DEPTH,
        TIME,
        MONOCHROME;


        public static ColorOption fromString(String c) {
            if (c == null) {
                return null;
            }
            switch (c.charAt(0)) {
                case 'D': {
                    return DEPTH;
                }
                case 'T': {
                    return TIME;
                }
                case 'M': {
                    return MONOCHROME;
                }
            }
            return null;
        }

        public static ColorOption chooseAuto(Axes ax) {
            if (ax == null) {
                return null;
            }
            switch (ax) {
                case MAP_VIEW: {
                    return DEPTH;
                }
                case LON_DEPTH: 
                case LAT_DEPTH: {
                    return TIME;
                }
            }
            return MONOCHROME;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Axes {
        MAP_VIEW,
        LON_DEPTH,
        LAT_DEPTH,
        DEPTH_TIME,
        TRIPLE_VIEW;


        public static Axes fromString(String c) {
            if (c == null) {
                return null;
            }
            switch (c.charAt(0)) {
                case 'M': {
                    return MAP_VIEW;
                }
                case 'E': {
                    return LON_DEPTH;
                }
                case 'N': {
                    return LAT_DEPTH;
                }
                case 'D': {
                    return DEPTH_TIME;
                }
                case '3': {
                    return TRIPLE_VIEW;
                }
            }
            return null;
        }
    }
}

