/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data.hypo;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import gov.usgs.proj.Projection;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.BinaryDataSet;
import gov.usgs.vdx.data.hypo.Hypocenter;
import hep.aida.IAxis;
import hep.aida.ref.FixedAxis;
import hep.aida.ref.Histogram1D;
import hep.aida.ref.VariableAxis;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HypocenterList
implements BinaryDataSet {
    private static final int MAX_BINS = 1000000;
    private List<Hypocenter> hypocenters;

    public HypocenterList() {
        this(new ArrayList<Hypocenter>(1));
    }

    public HypocenterList(ByteBuffer bb) {
        this.fromBinary(bb);
    }

    public HypocenterList(List<Hypocenter> hs) {
        this.hypocenters = hs;
    }

    public List<Hypocenter> getHypocenters() {
        return this.hypocenters;
    }

    public int size() {
        return this.hypocenters.size();
    }

    public double getStartTime() {
        if (this.hypocenters == null || this.hypocenters.size() == 0) {
            return Double.NaN;
        }
        return this.hypocenters.get((int)0).j2ksec;
    }

    public double getEndTime() {
        if (this.hypocenters == null || this.hypocenters.size() == 0) {
            return Double.NaN;
        }
        return this.hypocenters.get((int)(this.hypocenters.size() - 1)).j2ksec;
    }

    @Override
    public ByteBuffer toBinary() {
        ByteBuffer buffer = ByteBuffer.allocate(4 + this.hypocenters.size() * 6 * 8);
        buffer.putInt(this.hypocenters.size());
        for (Hypocenter hc : this.hypocenters) {
            hc.insertIntoByteBuffer(buffer);
        }
        buffer.flip();
        return buffer;
    }

    @Override
    public void fromBinary(ByteBuffer bb) {
        int rows = bb.getInt();
        this.hypocenters = new ArrayList<Hypocenter>(rows);
        for (int i = 0; i < rows; ++i) {
            Hypocenter hc = new Hypocenter(bb.getDouble(), bb.getInt(), bb.getDouble(), bb.getDouble(), bb.getDouble(), bb.getDouble());
            this.hypocenters.add(hc);
        }
    }

    public String toString() {
        return "HypocenterList: " + this.hypocenters.size() + " hypocenters";
    }

    private IAxis getHistogramAxis(BinSize bin) {
        int i;
        Date de;
        Date ds;
        double startTime = this.getStartTime();
        double endTime = this.getEndTime();
        int bins = -1;
        FixedAxis axis = null;
        if (bin == BinSize.MINUTE) {
            if ((bins = (int)((endTime -= (endTime - 43200.0) % 60.0 - 60.0) - (startTime -= (startTime - 43200.0) % 60.0)) / 60) > 1000000) {
                bin = BinSize.HOUR;
            } else {
                axis = new FixedAxis(bins, startTime, endTime);
            }
        }
        if (bin == BinSize.TENMINUTE) {
            if ((bins = (int)((endTime -= (endTime - 43200.0) % 600.0 - 600.0) - (startTime -= (startTime - 43200.0) % 600.0)) / 600) > 1000000) {
                bin = BinSize.HOUR;
            } else {
                axis = new FixedAxis(bins, startTime, endTime);
            }
        }
        if (bin == BinSize.HOUR) {
            if ((bins = (int)((endTime -= (endTime - 43200.0) % 3600.0 - 3600.0) - (startTime -= (startTime - 43200.0) % 3600.0)) / 3600) > 1000000) {
                bin = BinSize.DAY;
            } else {
                axis = new FixedAxis(bins, startTime, endTime);
            }
        }
        if (bin == BinSize.DAY) {
            if ((bins = (int)((endTime -= (endTime - 43200.0) % 86400.0 - 86400.0) - (startTime -= (startTime - 43200.0) % 86400.0)) / 86400) > 1000000) {
                bin = BinSize.WEEK;
            } else {
                axis = new FixedAxis(bins, startTime, endTime);
            }
        }
        if (bin == BinSize.WEEK) {
            if ((bins = (int)((endTime -= (endTime - 43200.0) % 604800.0 - 604800.0) - (startTime -= (startTime - 43200.0) % 604800.0)) / 604800) > 1000000) {
                bin = BinSize.MONTH;
            } else {
                axis = new FixedAxis(bins, startTime, endTime);
            }
        }
        if (bin == BinSize.MONTH) {
            ds = Util.j2KToDate((double)startTime);
            bins = Util.getMonthsBetween((Date)ds, (Date)(de = Util.j2KToDate((double)endTime))) + 1;
            if (bins <= 1000000) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(ds);
                cal.set(5, 1);
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                double[] edges = new double[bins + 1];
                for (i = 0; i < bins + 1; ++i) {
                    edges[i] = Util.dateToJ2K((Date)cal.getTime());
                    cal.add(2, 1);
                }
                axis = new VariableAxis(edges);
            } else {
                bin = BinSize.YEAR;
            }
        }
        if (bin == BinSize.YEAR) {
            ds = Util.j2KToDate((double)startTime);
            de = Util.j2KToDate((double)endTime);
            bins = Util.getYear((Date)de) - Util.getYear((Date)ds) + 1;
            double[] edges = new double[bins + 1];
            Calendar cal = Calendar.getInstance();
            cal.setTime(ds);
            cal.set(2, 1);
            cal.set(5, 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            for (i = 0; i < bins + 1; ++i) {
                edges[i] = Util.dateToJ2K((Date)cal.getTime());
                cal.add(1, 1);
            }
            axis = new VariableAxis(edges);
        }
        return axis;
    }

    public DoubleMatrix2D getCumulativeCounts() {
        DoubleMatrix2D result = DoubleFactory2D.dense.make(this.hypocenters.size(), 2);
        for (int i = 0; i < this.hypocenters.size(); ++i) {
            Hypocenter hc = this.hypocenters.get(i);
            result.setQuick(i, 0, hc.j2ksec);
            result.setQuick(i, 1, (double)i);
        }
        return result;
    }

    public DoubleMatrix2D getCumulativeMoment() {
        DoubleMatrix2D result = DoubleFactory2D.dense.make(this.hypocenters.size(), 2);
        for (int i = 0; i < this.hypocenters.size(); ++i) {
            Hypocenter hc = this.hypocenters.get(i);
            result.setQuick(i, 0, hc.j2ksec);
            double mo = Math.pow(10.0, 16.0 + 3.0 * hc.prefmag / 2.0);
            if (i == 0) {
                result.setQuick(i, 1, mo);
                continue;
            }
            result.setQuick(i, 1, result.getQuick(i - 1, 1) + mo);
        }
        return result;
    }

    public DoubleMatrix2D getCumulativeMagnitude() {
        DoubleMatrix2D result = this.getCumulativeMoment();
        double log10 = Math.log(10.0);
        for (int i = 0; i < result.rows(); ++i) {
            result.setQuick(i, 1, Math.log(result.getQuick(i, 1)) / log10 / 1.5 - 10.7);
        }
        return result;
    }

    public Histogram1D getCountsHistogram(BinSize bin) {
        if (this.hypocenters == null || this.hypocenters.size() == 0) {
            return null;
        }
        Histogram1D hist = new Histogram1D("", this.getHistogramAxis(bin));
        for (Hypocenter hc : this.hypocenters) {
            hist.fill(hc.j2ksec);
        }
        return hist;
    }

    public void project(Projection proj) {
        for (Hypocenter hc : this.hypocenters) {
            hc.project(proj);
        }
    }

    public String toCSV() {
        StringBuffer sb = new StringBuffer();
        for (Hypocenter hc : this.hypocenters) {
            sb.append(hc.toString() + "\n");
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BinSize {
        MINUTE("Minute"),
        TENMINUTE("TenMinute"),
        HOUR("Hour"),
        DAY("Day"),
        WEEK("Week"),
        MONTH("Month"),
        YEAR("Year");

        private String string;

        private BinSize(String s) {
            this.string = s;
        }

        public String toString() {
            return this.string;
        }

        public static BinSize fromString(String s) {
            if (s == null) {
                return null;
            }
            switch (s.charAt(0)) {
                case 'I': {
                    return MINUTE;
                }
                case 'a': {
                    return TENMINUTE;
                }
                case 'H': {
                    return HOUR;
                }
                case 'D': {
                    return DAY;
                }
                case 'W': {
                    return WEEK;
                }
                case 'M': {
                    return MONTH;
                }
                case 'Y': {
                    return YEAR;
                }
            }
            return null;
        }

        public int toSeconds() {
            switch (this.string.charAt(0)) {
                case 'I': {
                    return 60;
                }
                case 'a': {
                    return 600;
                }
                case 'H': {
                    return 3600;
                }
                case 'D': {
                    return 86400;
                }
                case 'W': {
                    return 604800;
                }
                case 'M': {
                    return 2419200;
                }
                case 'Y': {
                    return 31449600;
                }
            }
            return -1;
        }
    }
}

