/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data.hypo;

import gov.usgs.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class CUBEMessage {
    private static SimpleDateFormat dateIn = new SimpleDateFormat("yyyyMMddHHmmss");
    private static SimpleDateFormat dateOut = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
    public static final int EARTHQUAKE = 1;
    public static final int DELETE_EARTHQUAKE = 2;
    public static final int TEXT_MESSAGE = 3;
    public static final int LINK = 4;
    public static final int UNKNOWN = 5;
    private String message;

    public CUBEMessage(String m) {
        this.message = m;
    }

    public int getMessageType() {
        if (this.message == null || this.message.length() == 0) {
            return 5;
        }
        String mt = this.message.substring(0, 2);
        if (mt.equals("E ")) {
            return 1;
        }
        if (mt.equals("DE")) {
            return 2;
        }
        if (mt.equals("TX")) {
            return 3;
        }
        if (mt.equals("LI")) {
            return 4;
        }
        return 5;
    }

    public String getEventID() {
        return this.message.substring(2, 10);
    }

    public String getDataSource() {
        return this.message.substring(10, 12);
    }

    public char getVersion() {
        return this.message.charAt(12);
    }

    public Date getDate() {
        try {
            String ds = this.message.substring(13, 27);
            Date d = dateIn.parse(ds);
            int ts = Integer.parseInt(this.message.substring(27, 28));
            d.setTime(d.getTime() + (long)(ts * 100));
            return d;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Date(0L);
        }
    }

    public double getJ2KSec() {
        return Util.dateToJ2K((Date)this.getDate());
    }

    public double getLatitude() {
        String lat = this.message.substring(28, 35).trim();
        double r = 0.0;
        try {
            r = Double.parseDouble(lat) / 10000.0;
        }
        catch (Exception e) {
            // empty catch block
        }
        return r;
    }

    public double getLongitude() {
        String lon = this.message.substring(35, 43).trim();
        double r = 0.0;
        try {
            r = Double.parseDouble(lon) / 10000.0;
        }
        catch (Exception e) {
            // empty catch block
        }
        return r;
    }

    public double getDepth() {
        String depth = this.message.substring(43, 47).trim();
        double r = 0.0;
        try {
            r = Double.parseDouble(depth) / 10.0;
        }
        catch (Exception e) {
            // empty catch block
        }
        return r;
    }

    public double getMagnitude() {
        String depth = this.message.substring(47, 49).trim();
        double r = 0.0;
        try {
            r = Double.parseDouble(depth) / 10.0;
        }
        catch (Exception e) {
            // empty catch block
        }
        return r;
    }

    public static void main(String[] args) {
        try {
            File[] files = new File(".").listFiles();
            for (int i = 0; i < files.length; ++i) {
                BufferedReader in = new BufferedReader(new FileReader(files[i]));
                CUBEMessage msg = new CUBEMessage(in.readLine());
                if (msg.getMessageType() == 1) {
                    System.out.println(files[i].getName() + ": " + msg.getEventID() + " " + msg.getVersion() + " " + msg.getDataSource() + " " + dateOut.format(msg.getDate()) + " " + msg.getLongitude() + " " + msg.getLatitude() + " " + msg.getDepth() + " " + msg.getMagnitude());
                }
                in.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        dateIn.setTimeZone(TimeZone.getTimeZone("GMT"));
        dateOut.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

