/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data.heli;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.GenericDataMatrix;
import gov.usgs.vdx.data.wave.Wave;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelicorderData
extends GenericDataMatrix {
    private transient double bias = -1.0E300;
    private transient double meanMax = -1.0E300;

    @Override
    public void setColumnNames() {
        this.columnMap.put("time", 0);
        this.columnMap.put("min", 1);
        this.columnMap.put("max", 2);
    }

    public HelicorderData() {
    }

    public HelicorderData(ByteBuffer bb) {
        super(bb);
    }

    public HelicorderData(List<double[]> list) {
        super(list);
    }

    public void resetBiasMinMax() {
        this.bias = -1.0E300;
        this.meanMax = -1.0E300;
    }

    public DoubleMatrix2D getMin() {
        return this.data.viewPart(0, 1, this.rows(), 1);
    }

    public DoubleMatrix2D getMax() {
        return this.data.viewPart(0, 2, this.rows(), 1);
    }

    public double getBias() {
        if (this.bias != -1.0E300) {
            return this.bias;
        }
        double b = 0.0;
        int samples = 0;
        int numRows = this.data.rows();
        for (int i = 0; i < numRows; ++i) {
            double d1 = this.data.getQuick(i, 1);
            double d2 = this.data.getQuick(i, 2);
            if (d1 == (double)Wave.NO_DATA || d2 == (double)Wave.NO_DATA) continue;
            b += d2 - (d2 - d1) / 2.0;
            ++samples;
        }
        this.bias = b /= (double)samples;
        return this.bias;
    }

    private int findIndex(double t, int left, int right) {
        int mid = 0;
        while (left <= right) {
            mid = (left + right) / 2;
            double val = this.data.getQuick(mid, 0);
            if (val == t) {
                return mid;
            }
            if (t < val) {
                right = mid - 1;
                continue;
            }
            if (!(t > val)) continue;
            left = mid + 1;
        }
        return mid;
    }

    public double getBiasBetween(double t1, double t2) {
        double bias = 0.0;
        int samples = 0;
        int m = this.findIndex(t1, 0, this.data.rows() - 1);
        int n = this.findIndex(t2, 0, this.data.rows() - 1);
        for (int i = m; i < n; ++i) {
            double d1 = this.data.getQuick(i, 1);
            double d2 = this.data.getQuick(i, 2);
            if (d1 == (double)Wave.NO_DATA || d2 == (double)Wave.NO_DATA) continue;
            bias += d2 - (d2 - d1) / 2.0;
            ++samples;
        }
        return bias /= (double)samples;
    }

    public double[] getBiasByRow(double timeChunk) {
        double mint = this.getStartTime() - this.getStartTime() % timeChunk;
        double maxt = this.getEndTime() + (timeChunk - this.getEndTime() % timeChunk);
        int rows = (int)((maxt - mint) / timeChunk);
        double[] biases = new double[rows];
        double rowStartTime = mint;
        int samples = 0;
        int row = 0;
        for (int i = 0; i < this.data.rows(); ++i) {
            double t = this.data.getQuick(i, 0);
            double d1 = this.data.getQuick(i, 1);
            double d2 = this.data.getQuick(i, 2);
            if (t > rowStartTime + timeChunk) {
                int n = row;
                biases[n] = biases[n] / (double)samples;
                System.out.println(row + " " + biases[row]);
                ++row;
                samples = 0;
                rowStartTime += timeChunk;
            }
            if (d1 == (double)Wave.NO_DATA || d2 == (double)Wave.NO_DATA) continue;
            int n = row;
            biases[n] = biases[n] + (d2 - (d2 - d1) / 2.0);
            ++samples;
        }
        return biases;
    }

    public double removeBias() {
        int i;
        double bias = 0.0;
        for (i = 0; i < this.data.rows(); ++i) {
            bias += (this.data.getQuick(i, 2) - this.data.getQuick(i, 1)) / 2.0;
        }
        bias /= (double)this.data.rows();
        for (i = 0; i < this.data.rows(); ++i) {
            this.data.setQuick(i, 2, this.data.getQuick(i, 2) - bias);
            this.data.setQuick(i, 1, this.data.getQuick(i, 1) - bias);
        }
        return bias;
    }

    public double getMeanMax() {
        if (this.meanMax != -1.0E300) {
            return this.meanMax;
        }
        double mean = 0.0;
        int samples = 0;
        int numRows = this.data.rows();
        for (int i = 0; i < numRows; ++i) {
            double d = this.data.getQuick(i, 2);
            if (d == (double)Wave.NO_DATA) continue;
            mean += d;
            ++samples;
        }
        this.meanMax = mean / (double)samples;
        return this.meanMax;
    }

    public double getMeanRange() {
        double mean = 0.0;
        int samples = 0;
        for (int i = 0; i < this.data.rows(); ++i) {
            mean += this.data.getQuick(i, 2) - this.data.getQuick(i, 1);
            ++samples;
        }
        return mean / (double)samples;
    }

    @Override
    public double getStartTime() {
        return this.data.getQuick(0, 0);
    }

    @Override
    public double getEndTime() {
        return Math.round(this.data.getQuick(this.rows() - 1, 0));
    }

    public boolean overlaps(HelicorderData heli) {
        if (this.getEndTime() < heli.getStartTime()) {
            return false;
        }
        return !(this.getStartTime() > heli.getEndTime());
    }

    public int findClosestTimeIndexGreaterThan(double time) {
        for (int i = 0; i < this.rows(); ++i) {
            if (!(this.data.getQuick(i, 0) >= time)) continue;
            return i;
        }
        return -1;
    }

    public int findClosestTimeIndexLessThan(double time) {
        for (int i = this.rows() - 1; i >= 0; --i) {
            if (!(this.data.getQuick(i, 0) <= time)) continue;
            return i;
        }
        return -1;
    }

    public HelicorderData subset(double t1, double t2) {
        int i1 = this.findClosestTimeIndexGreaterThan(t1);
        int i2 = this.findClosestTimeIndexLessThan(t2);
        if (i1 == -1 || i2 == -1 || i2 - i1 == 0) {
            return null;
        }
        DoubleMatrix2D[][] ms = new DoubleMatrix2D[1][1];
        ms[0][0] = this.data.viewPart(i1, 0, i2 - i1, 3);
        HelicorderData hd = new HelicorderData();
        hd.data = DoubleFactory2D.dense.compose(ms);
        return hd;
    }

    public HelicorderData combine(HelicorderData heli) {
        if (this.getStartTime() >= heli.getStartTime() && this.getEndTime() <= heli.getEndTime()) {
            return heli;
        }
        if (this.getStartTime() <= heli.getStartTime() && this.getEndTime() >= heli.getEndTime()) {
            return this;
        }
        if (this.getStartTime() <= heli.getStartTime()) {
            DoubleMatrix2D[][] ms = new DoubleMatrix2D[2][1];
            ms[0][0] = this.data;
            int i = heli.findClosestTimeIndexGreaterThan(this.getEndTime());
            ms[1][0] = heli.getData().viewPart(i, 0, heli.rows() - i, 3);
            this.data = DoubleFactory2D.dense.compose(ms);
            return this;
        }
        if (heli.getStartTime() <= this.getStartTime()) {
            DoubleMatrix2D[][] ms = new DoubleMatrix2D[2][1];
            ms[0][0] = heli.getData();
            int i = this.findClosestTimeIndexLessThan(heli.getEndTime());
            if (i == -1) {
                i = 0;
            }
            ms[1][0] = this.getData().viewPart(i, 0, this.rows() - i, 3);
            this.data = DoubleFactory2D.dense.compose(ms);
            return this;
        }
        return null;
    }

    public void sort() {
        if (this.data == null) {
            return;
        }
        double[][] matrix = this.data.toArray();
        Arrays.sort(matrix, new Comparator<double[]>(){

            @Override
            public int compare(double[] o1, double[] o2) {
                return Double.compare(o1[0], o2[0]);
            }
        });
        this.data = DoubleFactory2D.dense.make(matrix);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < 3; ++j) {
                sb.append(this.data.getQuick(i, j));
                sb.append(" ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public String toCSV() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.rows(); ++i) {
            sb.append(Util.j2KToDateString((double)this.data.getQuick(i, 0)) + ",");
            sb.append(this.data.getQuick(i, 1) + ",");
            sb.append(this.data.getQuick(i, 2) + "\n");
        }
        return sb.toString();
    }
}

