/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectOption {
    private int soid;
    private int idx;
    private String code;
    private String name;

    public SelectOption(int soid, int idx, String code, String name) {
        this.soid = soid;
        this.idx = idx;
        this.code = code;
        this.name = name;
    }

    public SelectOption(int idx, String code, String name) {
        this.soid = 0;
        this.idx = idx;
        this.code = code;
        this.name = name;
    }

    public SelectOption(String ch) {
        String[] parts = ch.split(":");
        this.soid = Integer.parseInt(parts[0]);
        this.idx = Integer.parseInt(parts[1]);
        this.code = parts[2];
        this.name = parts[3];
    }

    public int getId() {
        return this.soid;
    }

    public int getIndex() {
        return this.idx;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public static Map<Integer, SelectOption> fromStringsToMap(List<String> ss) {
        LinkedHashMap<Integer, SelectOption> map = new LinkedHashMap<Integer, SelectOption>();
        for (String s : ss) {
            SelectOption so = new SelectOption(s);
            map.put(so.getId(), so);
        }
        return map;
    }

    public String toString() {
        return String.format("%d:%d:%s:%s", this.getId(), this.getIndex(), this.getCode(), this.getName());
    }
}

